/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.tomcat.dbcp.dbcp2.ListException;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSource;

abstract class InstanceKeyDataSourceFactory
implements ObjectFactory {
    private static final Map<String, InstanceKeyDataSource> INSTANCE_MAP = new ConcurrentHashMap<String, InstanceKeyDataSource>();

    InstanceKeyDataSourceFactory() {
    }

    static synchronized String registerNewInstance(InstanceKeyDataSource instanceKeyDataSource) {
        int n = 0;
        for (String string : INSTANCE_MAP.keySet()) {
            if (string == null) continue;
            try {
                n = Math.max(n, Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String string = String.valueOf(n + 1);
        INSTANCE_MAP.put(string, instanceKeyDataSource);
        return string;
    }

    static void removeInstance(String string) {
        if (string != null) {
            INSTANCE_MAP.remove(string);
        }
    }

    public static void closeAll() throws Exception {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>(INSTANCE_MAP.size());
        for (Map.Entry<String, InstanceKeyDataSource> entry : INSTANCE_MAP.entrySet()) {
            InstanceKeyDataSource instanceKeyDataSource;
            if (entry == null || (instanceKeyDataSource = entry.getValue()) == null) continue;
            try {
                instanceKeyDataSource.close();
            }
            catch (Exception exception) {
                arrayList.add(exception);
            }
        }
        INSTANCE_MAP.clear();
        if (!arrayList.isEmpty()) {
            throw new ListException("Could not close all InstanceKeyDataSource instances.", arrayList);
        }
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws IOException, ClassNotFoundException {
        Reference reference;
        InstanceKeyDataSource instanceKeyDataSource = null;
        if (object instanceof Reference && this.isCorrectClass((reference = (Reference)object).getClassName())) {
            RefAddr refAddr = reference.get("instanceKey");
            if (refAddr != null && refAddr.getContent() != null) {
                instanceKeyDataSource = INSTANCE_MAP.get(refAddr.getContent());
            } else {
                String string = null;
                if (name != null) {
                    string = name.toString();
                    instanceKeyDataSource = INSTANCE_MAP.get(string);
                }
                if (instanceKeyDataSource == null) {
                    InstanceKeyDataSource instanceKeyDataSource2 = this.getNewInstance(reference);
                    this.setCommonProperties(reference, instanceKeyDataSource2);
                    instanceKeyDataSource = instanceKeyDataSource2;
                    if (string != null) {
                        INSTANCE_MAP.put(string, instanceKeyDataSource2);
                    }
                }
            }
        }
        return instanceKeyDataSource;
    }

    private void setCommonProperties(Reference reference, InstanceKeyDataSource instanceKeyDataSource) throws IOException, ClassNotFoundException {
        RefAddr refAddr = reference.get("dataSourceName");
        if (refAddr != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDataSourceName(refAddr.getContent().toString());
        }
        if ((refAddr = reference.get("description")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDescription(refAddr.getContent().toString());
        }
        if ((refAddr = reference.get("jndiEnvironment")) != null && refAddr.getContent() != null) {
            byte[] byArray = (byte[])refAddr.getContent();
            instanceKeyDataSource.setJndiEnvironment((Properties)InstanceKeyDataSourceFactory.deserialize(byArray));
        }
        if ((refAddr = reference.get("loginTimeout")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setLoginTimeout(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("blockWhenExhausted")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultBlockWhenExhausted(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("evictionPolicyClassName")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultEvictionPolicyClassName(refAddr.getContent().toString());
        }
        if ((refAddr = reference.get("lifo")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultLifo(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("maxIdlePerKey")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultMaxIdle(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("maxTotalPerKey")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultMaxTotal(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("maxWaitMillis")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultMaxWaitMillis(Long.parseLong(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("minEvictableIdleTimeMillis")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultMinEvictableIdleTimeMillis(Long.parseLong(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("minIdlePerKey")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultMinIdle(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("numTestsPerEvictionRun")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultNumTestsPerEvictionRun(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("softMinEvictableIdleTimeMillis")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultSoftMinEvictableIdleTimeMillis(Long.parseLong(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("testOnCreate")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultTestOnCreate(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("testOnBorrow")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultTestOnBorrow(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("testOnReturn")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultTestOnReturn(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("testWhileIdle")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultTestWhileIdle(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("timeBetweenEvictionRunsMillis")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultTimeBetweenEvictionRunsMillis(Long.parseLong(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("validationQuery")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setValidationQuery(refAddr.getContent().toString());
        }
        if ((refAddr = reference.get("validationQueryTimeout")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setValidationQueryTimeout(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("rollbackAfterValidation")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setRollbackAfterValidation(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("maxConnLifetimeMillis")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setMaxConnLifetimeMillis(Long.parseLong(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("defaultAutoCommit")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultAutoCommit(Boolean.valueOf(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("defaultTransactionIsolation")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultTransactionIsolation(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("defaultReadOnly")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultReadOnly(Boolean.valueOf(refAddr.getContent().toString()));
        }
    }

    protected abstract boolean isCorrectClass(String var1);

    protected abstract InstanceKeyDataSource getNewInstance(Reference var1) throws IOException, ClassNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Object deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            Object object = objectInputStream.readObject();
            return object;
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

