/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.apache.juli.OneLineFormatter;

public class JsonFormatter
extends OneLineFormatter {
    private static final String DEFAULT_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSX";

    public JsonFormatter() {
        String string = LogManager.getLogManager().getProperty(JsonFormatter.class.getName() + ".timeFormat");
        if (string == null) {
            string = DEFAULT_TIME_FORMAT;
        }
        this.setTimeFormat(string);
    }

    @Override
    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        stringBuilder.append("\"time\": \"");
        this.addTimestamp(stringBuilder, logRecord.getMillis());
        stringBuilder.append("\", ");
        stringBuilder.append("\"level\": \"");
        stringBuilder.append(logRecord.getLevel().getLocalizedName());
        stringBuilder.append("\", ");
        stringBuilder.append("\"thread\": \"");
        stringBuilder.append(this.resolveThreadName(logRecord));
        stringBuilder.append("\", ");
        stringBuilder.append("\"class\": \"");
        stringBuilder.append(logRecord.getSourceClassName());
        stringBuilder.append("\", ");
        stringBuilder.append("\"method\": \"");
        stringBuilder.append(logRecord.getSourceMethodName());
        stringBuilder.append("\", ");
        stringBuilder.append("\"message\": \"");
        stringBuilder.append(JSONFilter.escape(this.formatMessage(logRecord)));
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            stringBuilder.append("\", ");
            stringBuilder.append("\"throwable\": [");
            boolean bl = true;
            do {
                if (!bl) {
                    stringBuilder.append(',');
                } else {
                    bl = false;
                }
                stringBuilder.append('\"').append(JSONFilter.escape(throwable.toString())).append('\"');
                for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                    stringBuilder.append(',').append('\"').append(' ').append(JSONFilter.escape(stackTraceElement.toString())).append('\"');
                }
            } while ((throwable = throwable.getCause()) != null);
            stringBuilder.append(']');
        } else {
            stringBuilder.append('\"');
        }
        stringBuilder.append('}');
        stringBuilder.append(System.lineSeparator());
        return stringBuilder.toString();
    }

    public static class JSONFilter {
        public static String escape(String string) {
            return JSONFilter.escape(string, 0, string.length()).toString();
        }

        public static CharSequence escape(CharSequence charSequence, int n, int n2) {
            StringBuilder stringBuilder = null;
            int n3 = n;
            for (int i = n; i < n2; ++i) {
                char c = charSequence.charAt(i);
                if (c >= ' ' && c != '\"' && c != '\\' && !Character.isHighSurrogate(c) && !Character.isLowSurrogate(c)) continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n2 + 20);
                }
                if (n3 < i) {
                    stringBuilder.append(charSequence.subSequence(n3, i));
                }
                n3 = i + 1;
                char c2 = JSONFilter.getPopularChar(c);
                if (c2 > '\u0000') {
                    stringBuilder.append('\\').append(c2);
                    continue;
                }
                stringBuilder.append("\\u");
                stringBuilder.append(String.format("%04X", c));
            }
            if (stringBuilder == null) {
                if (n == 0 && n2 == charSequence.length()) {
                    return charSequence;
                }
                return charSequence.subSequence(n, n2 - n);
            }
            if (n3 < n2) {
                stringBuilder.append(charSequence.subSequence(n3, n2));
            }
            return stringBuilder.toString();
        }

        private JSONFilter() {
        }

        private static char getPopularChar(char c) {
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    return c;
                }
                case '\b': {
                    return 'b';
                }
                case '\f': {
                    return 'f';
                }
                case '\n': {
                    return 'n';
                }
                case '\r': {
                    return 'r';
                }
                case '\t': {
                    return 't';
                }
            }
            return '\u0000';
        }
    }
}

