/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.osgi.framework.Bundle;
import org.protege.editor.core.plugin.PluginUtilities;

public class Icons {
    public static final String ALTERNATIVE_ICONS_PATH = "icons/";

    public static Icon getIcon(String name) {
        if (name == null) {
            return null;
        }
        try {
            URL url = Icons.getIconURLFromIconFileName(name);
            if (url == null) {
                return null;
            }
            return new ImageIcon(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static URL getIconURLFromIconFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        Bundle b = PluginUtilities.getInstance().getApplicationBundle();
        URL url = b.getResource(fileName);
        if (url != null) {
            return url;
        }
        if (!Icons.isNameAbsolute(fileName)) {
            return b.getResource(ALTERNATIVE_ICONS_PATH + fileName);
        }
        return null;
    }

    private static boolean isNameAbsolute(String name) {
        return name.startsWith("/");
    }
}

