/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlArrayWithAngleBracketsNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCollectionTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMapTypeNameSpec;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.SqlTypeName;

public abstract class RelToSqlConverterUtil {
    public static void unparseHiveTrim(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlLiteral valueToTrim = (SqlLiteral)call.operand(1);
        String value = Objects.requireNonNull(valueToTrim.toValue(), () -> "call.operand(1).toValue() for call " + call);
        if (value.matches("\\s+")) {
            RelToSqlConverterUtil.unparseTrimWithSpace(writer, call, leftPrec, rightPrec);
        } else {
            SqlLiteral trimFlag = (SqlLiteral)call.operand(0);
            SqlCharStringLiteral regexNode = RelToSqlConverterUtil.createRegexPatternLiteral(call.operand(1), trimFlag);
            SqlCharStringLiteral blankLiteral = SqlLiteral.createCharString("", call.getParserPosition());
            SqlNode[] trimOperands = new SqlNode[]{call.operand(2), regexNode, blankLiteral};
            SqlCall regexReplaceCall = SqlLibraryOperators.REGEXP_REPLACE_3.createCall(SqlParserPos.ZERO, trimOperands);
            regexReplaceCall.unparse(writer, leftPrec, rightPrec);
        }
    }

    public static void unparseTrimLR(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        String operatorName;
        SqlLiteral trimFlag = (SqlLiteral)call.operand(0);
        SqlLiteral valueToTrim = (SqlLiteral)call.operand(1);
        switch (trimFlag.getValueAs(SqlTrimFunction.Flag.class)) {
            case LEADING: {
                operatorName = "LTRIM";
                break;
            }
            case TRAILING: {
                operatorName = "RTRIM";
                break;
            }
            default: {
                operatorName = call.getOperator().getName();
            }
        }
        SqlWriter.Frame trimFrame = writer.startFunCall(operatorName);
        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        String value = Objects.requireNonNull(valueToTrim.toValue(), "valueToTrim.toValue()");
        if (!value.equals(" ")) {
            writer.literal(",");
            ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(trimFrame);
    }

    public static RexNode unparseIsTrueOrFalse(RexNode rexNode) {
        if (!(rexNode instanceof RexCall)) {
            return rexNode;
        }
        RexCall call = (RexCall)rexNode;
        switch (call.getOperator().getKind()) {
            case IS_FALSE: {
                RexNode operandIsFalse = (RexNode)call.operands.get(0);
                if (RexUtil.isDeterministic(operandIsFalse)) {
                    RexNode isNotNullFunc = RexBuilder.DEFAULT.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operandIsFalse);
                    RexNode notFunc = RexBuilder.DEFAULT.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operandIsFalse);
                    return RexBuilder.DEFAULT.makeCall((SqlOperator)SqlStdOperatorTable.AND, isNotNullFunc, notFunc);
                }
                throw new UnsupportedOperationException("Unsupported unparse: " + call.getOperator().getName());
            }
            case IS_NOT_FALSE: {
                RexNode operandIsNotFalse = (RexNode)call.operands.get(0);
                if (RexUtil.isDeterministic(operandIsNotFalse)) {
                    RexNode isNullFunc = RexBuilder.DEFAULT.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, operandIsNotFalse);
                    return RexBuilder.DEFAULT.makeCall((SqlOperator)SqlStdOperatorTable.OR, isNullFunc, operandIsNotFalse);
                }
                throw new UnsupportedOperationException("Unsupported unparse: " + call.getOperator().getName());
            }
            case IS_TRUE: {
                RexNode operandIsTrue = (RexNode)call.operands.get(0);
                if (RexUtil.isDeterministic(operandIsTrue)) {
                    RexNode isNotNullFunc = RexBuilder.DEFAULT.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operandIsTrue);
                    return RexBuilder.DEFAULT.makeCall((SqlOperator)SqlStdOperatorTable.AND, isNotNullFunc, operandIsTrue);
                }
                throw new UnsupportedOperationException("Unsupported unparse: " + call.getOperator().getName());
            }
            case IS_NOT_TRUE: {
                RexNode operandIsNotTrue = (RexNode)call.operands.get(0);
                if (RexUtil.isDeterministic(operandIsNotTrue)) {
                    RexNode isNullFunc = RexBuilder.DEFAULT.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, operandIsNotTrue);
                    RexNode notFunc = RexBuilder.DEFAULT.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operandIsNotTrue);
                    return RexBuilder.DEFAULT.makeCall((SqlOperator)SqlStdOperatorTable.OR, isNullFunc, notFunc);
                }
                throw new UnsupportedOperationException("Unsupported unparse: " + call.getOperator().getName());
            }
        }
        return rexNode;
    }

    public static void unparseSparkArrayAndMap(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        String keyword = call.getKind() == SqlKind.ARRAY_VALUE_CONSTRUCTOR ? "array" : "map";
        writer.keyword(keyword);
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }

    private static void unparseTrimWithSpace(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        String operatorName;
        SqlLiteral trimFlag = (SqlLiteral)call.operand(0);
        switch (trimFlag.getValueAs(SqlTrimFunction.Flag.class)) {
            case LEADING: {
                operatorName = "LTRIM";
                break;
            }
            case TRAILING: {
                operatorName = "RTRIM";
                break;
            }
            default: {
                operatorName = call.getOperator().getName();
            }
        }
        SqlWriter.Frame trimFrame = writer.startFunCall(operatorName);
        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        writer.endFunCall(trimFrame);
    }

    public static SqlCharStringLiteral createRegexPatternLiteral(SqlNode call, SqlLiteral trimFlag) {
        String regexPattern = Objects.requireNonNull(((SqlCharStringLiteral)call).toValue(), () -> "null value for SqlNode " + call);
        String escaped = RelToSqlConverterUtil.escapeSpecialChar(regexPattern);
        StringBuilder builder = new StringBuilder();
        switch (trimFlag.getValueAs(SqlTrimFunction.Flag.class)) {
            case LEADING: {
                builder.append("^(").append(escaped).append(")*");
                break;
            }
            case TRAILING: {
                builder.append("(").append(escaped).append(")*$");
                break;
            }
            default: {
                builder.append("^(").append(escaped).append(")*|(").append(escaped).append(")*$");
            }
        }
        return SqlLiteral.createCharString(builder.toString(), call.getParserPosition());
    }

    private static String escapeSpecialChar(String inputString) {
        String[] specialCharacters;
        for (String specialCharacter : specialCharacters = new String[]{"\\", "^", "$", "{", "}", "[", "]", "(", ")", ".", "*", "+", "?", "|", "<", ">", "-", "&", "%", "@"}) {
            if (!inputString.contains(specialCharacter)) continue;
            inputString = inputString.replace(specialCharacter, "\\" + specialCharacter);
        }
        return inputString;
    }

    public static SqlSpecialOperator specialOperatorByName(String opName) {
        return new SqlSpecialOperator(opName, SqlKind.OTHER_FUNCTION){

            @Override
            public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
                writer.print(this.getName());
                SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
                for (SqlNode operand : call.getOperandList()) {
                    writer.sep(",");
                    operand.unparse(writer, 0, 0);
                }
                writer.endList(frame);
            }
        };
    }

    public static void unparseBoolLiteralToCondition(SqlWriter writer, boolean value) {
        SqlWriter.Frame frame = writer.startList("(", ")");
        writer.literal("1");
        writer.sep(SqlStdOperatorTable.EQUALS.getName());
        writer.literal(value ? "1" : "0");
        writer.endList(frame);
    }

    public static SqlDataTypeSpec getCastSpecClickHouseSqlMapType(SqlDialect dialect, RelDataType type, SqlParserPos pos) {
        MapSqlType mapSqlType = (MapSqlType)type;
        SqlDataTypeSpec keySpec = (SqlDataTypeSpec)dialect.getCastSpec(mapSqlType.getKeyType());
        SqlDataTypeSpec valueSpec = (SqlDataTypeSpec)dialect.getCastSpec(mapSqlType.getValueType());
        SqlDataTypeSpec nonNullKeySpec = Objects.requireNonNull(keySpec, "keySpec");
        SqlDataTypeSpec nonNullValueSpec = Objects.requireNonNull(valueSpec, "valueSpec");
        ClickHouseSqlMapTypeNameSpec sqlMapTypeNameSpec = new ClickHouseSqlMapTypeNameSpec(nonNullKeySpec, nonNullValueSpec, pos);
        return new SqlDataTypeSpec(sqlMapTypeNameSpec, SqlParserPos.ZERO);
    }

    public static SqlDataTypeSpec getCastSpecClickHouseSqlArrayType(SqlDialect dialect, RelDataType type, SqlParserPos pos) {
        ArraySqlType arraySqlType = (ArraySqlType)type;
        SqlDataTypeSpec arrayValueSpec = (SqlDataTypeSpec)dialect.getCastSpec(arraySqlType.getComponentType());
        SqlDataTypeSpec nonNullarrayValueSpec = Objects.requireNonNull(arrayValueSpec, "arrayValueSpec");
        ClickHouseSqlArrayTypeNameSpec sqlArrayTypeNameSpec = new ClickHouseSqlArrayTypeNameSpec(nonNullarrayValueSpec.getTypeNameSpec(), arraySqlType.getSqlTypeName(), pos);
        return new SqlDataTypeSpec(sqlArrayTypeNameSpec, SqlParserPos.ZERO);
    }

    public static SqlDataTypeSpec getCastSpecAngleBracketArrayType(SqlDialect dialect, RelDataType type, SqlParserPos pos) {
        ArraySqlType arraySqlType = (ArraySqlType)type;
        SqlDataTypeSpec arrayValueSpec = (SqlDataTypeSpec)dialect.getCastSpec(arraySqlType.getComponentType());
        SqlDataTypeSpec nonNullarrayValueSpec = Objects.requireNonNull(arrayValueSpec, "arrayValueSpec");
        SqlArrayWithAngleBracketsNameSpec sqlArrayTypeNameSpec = new SqlArrayWithAngleBracketsNameSpec(nonNullarrayValueSpec.getTypeNameSpec(), arraySqlType.getSqlTypeName(), pos);
        return new SqlDataTypeSpec(sqlArrayTypeNameSpec, SqlParserPos.ZERO);
    }

    public static class ClickHouseSqlArrayTypeNameSpec
    extends SqlCollectionTypeNameSpec {
        public ClickHouseSqlArrayTypeNameSpec(SqlTypeNameSpec elementTypeName, SqlTypeName collectionTypeName, SqlParserPos pos) {
            super(elementTypeName, collectionTypeName, pos);
        }

        @Override
        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.print("Array");
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
            this.getElementTypeName().unparse(writer, leftPrec, rightPrec);
            writer.endList(frame);
        }
    }

    public static class ClickHouseSqlMapTypeNameSpec
    extends SqlMapTypeNameSpec {
        public ClickHouseSqlMapTypeNameSpec(SqlDataTypeSpec keyType, SqlDataTypeSpec valType, SqlParserPos pos) {
            super(keyType, valType, pos);
        }

        @Override
        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.print("Map");
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
            writer.sep(",");
            this.getKeyType().unparse(writer, leftPrec, rightPrec);
            writer.sep(",");
            this.getValType().unparse(writer, leftPrec, rightPrec);
            writer.endList(frame);
        }
    }
}

