/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.dlsfls;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.Version;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluationException;
import org.opensearch.security.privileges.dlsfls.DlsFlsProcessedConfig;
import org.opensearch.security.privileges.dlsfls.DlsRestriction;
import org.opensearch.security.privileges.dlsfls.DocumentPrivileges;
import org.opensearch.security.privileges.dlsfls.FieldMasking;
import org.opensearch.security.privileges.dlsfls.FieldPrivileges;
import org.opensearch.security.privileges.dlsfls.IndexToRuleMap;
import org.opensearch.security.support.Base64Helper;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportRequest;

public class DlsFlsLegacyHeaders {
    static final Version LEGACY_HEADERS_UNNECESSARY_AS_OF = Version.V_3_0_0;
    public static final String TRANSIENT_HEADER = "_opendistro_security_dls_fls_legacy_headers";
    private final DlsFlsProcessedConfig config;
    private final String dlsHeader;
    private final String flsHeader;
    private final String fmHeader;

    public static boolean possiblyRequired(ClusterService clusterService) {
        return !clusterService.state().nodes().getMinNodeVersion().onOrAfter(LEGACY_HEADERS_UNNECESSARY_AS_OF);
    }

    public static void prepare(ThreadContext threadContext, PrivilegesEvaluationContext context, DlsFlsProcessedConfig config, Metadata metadata, boolean doFilterLevelDls) throws PrivilegesEvaluationException {
        DlsFlsLegacyHeaders preparedHeaders = new DlsFlsLegacyHeaders(context, config, metadata, doFilterLevelDls);
        if (context.getRequest() instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest(threadContext)) {
            preparedHeaders.performResponseHeaderDecoration(threadContext);
        } else if (threadContext.getTransient(TRANSIENT_HEADER) == null) {
            threadContext.putTransient(TRANSIENT_HEADER, (Object)preparedHeaders);
        }
    }

    public DlsFlsLegacyHeaders(PrivilegesEvaluationContext context, DlsFlsProcessedConfig config, Metadata metadata, boolean doFilterLevelDls) throws PrivilegesEvaluationException {
        this.config = config;
        this.dlsHeader = !doFilterLevelDls ? DlsFlsLegacyHeaders.getDlsHeader(context, config.getDocumentPrivileges(), metadata) : null;
        this.flsHeader = DlsFlsLegacyHeaders.getFlsHeader(context, config.getFieldPrivileges(), metadata);
        this.fmHeader = DlsFlsLegacyHeaders.getFieldMaskingHeader(context, config.getFieldMasking(), metadata);
    }

    public void performHeaderDecoration(Transport.Connection connection, TransportRequest request, Map<String, String> headerMap) {
        if (connection.getVersion().onOrAfter(LEGACY_HEADERS_UNNECESSARY_AS_OF)) {
            return;
        }
        if (request instanceof ActionRequest) {
            return;
        }
        if (this.dlsHeader != null) {
            headerMap.put("_opendistro_security_dls_query", this.dlsHeader);
        }
        if (this.flsHeader != null) {
            headerMap.put("_opendistro_security_fls_fields", this.flsHeader);
        }
        if (this.fmHeader != null) {
            headerMap.put("_opendistro_security_masked_fields", this.fmHeader);
        }
    }

    public void performResponseHeaderDecoration(ThreadContext threadContext) {
        if (this.dlsHeader != null) {
            threadContext.addResponseHeader("_opendistro_security_dls_query", this.dlsHeader);
        }
        if (this.flsHeader != null) {
            threadContext.addResponseHeader("_opendistro_security_fls_fields", this.flsHeader);
        }
        if (this.fmHeader != null) {
            threadContext.addResponseHeader("_opendistro_security_masked_fields", this.fmHeader);
        }
    }

    public String getDlsHeader() {
        return this.dlsHeader;
    }

    public String getFlsHeader() {
        return this.flsHeader;
    }

    public String getFmHeader() {
        return this.fmHeader;
    }

    private static String getDlsHeader(PrivilegesEvaluationContext context, DocumentPrivileges documentPrivileges, Metadata metadata) throws PrivilegesEvaluationException {
        IndexToRuleMap dlsRestrictionMap = documentPrivileges.getRestrictions(context, (Collection)metadata.indices().keySet(), documentPrivileges.unrestricted());
        if (dlsRestrictionMap.isUnrestricted()) {
            return null;
        }
        HashMap dlsQueriesByIndex = new HashMap();
        for (Map.Entry entry : dlsRestrictionMap.getIndexMap().entrySet()) {
            if (entry.getValue() == documentPrivileges.unrestricted()) continue;
            dlsQueriesByIndex.put((String)entry.getKey(), ((DlsRestriction)entry.getValue()).getQueries().stream().map(query -> query.getRenderedSource()).collect(Collectors.toSet()));
        }
        return Base64Helper.serializeObject(dlsQueriesByIndex);
    }

    private static String getFlsHeader(PrivilegesEvaluationContext context, FieldPrivileges fieldPrivileges, Metadata metadata) throws PrivilegesEvaluationException {
        IndexToRuleMap flsRuleMap = fieldPrivileges.getRestrictions(context, (Collection)metadata.indices().keySet(), fieldPrivileges.unrestricted());
        if (flsRuleMap.isUnrestricted()) {
            return null;
        }
        HashMap<String, HashSet> flsFields = new HashMap<String, HashSet>();
        for (Map.Entry entry : flsRuleMap.getIndexMap().entrySet()) {
            if (entry.getValue() == fieldPrivileges.unrestricted()) continue;
            flsFields.put((String)entry.getKey(), Sets.newHashSet(((FieldPrivileges.FlsRule)entry.getValue()).getSource()));
        }
        return Base64Helper.serializeObject(flsFields);
    }

    private static String getFieldMaskingHeader(PrivilegesEvaluationContext context, FieldMasking fieldMasking, Metadata metadata) throws PrivilegesEvaluationException {
        IndexToRuleMap fmRuleMap = fieldMasking.getRestrictions(context, (Collection)metadata.indices().keySet(), fieldMasking.unrestricted());
        if (fmRuleMap.isUnrestricted()) {
            return null;
        }
        HashMap<String, HashSet> maskedFieldsMap = new HashMap<String, HashSet>();
        for (Map.Entry entry : fmRuleMap.getIndexMap().entrySet()) {
            if (entry.getValue() == fieldMasking.unrestricted()) continue;
            maskedFieldsMap.put((String)entry.getKey(), Sets.newHashSet(((FieldMasking.FieldMaskingRule)entry.getValue()).getSource()));
        }
        return Base64Helper.serializeObject(maskedFieldsMap);
    }
}

