/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.opensaml.integration;

import java.lang.ref.Cleaner;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.shared.collection.IndexingObjectStore;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensearch.security.opensaml.integration.CleanerFactory;

public class SecurityX509CertificateImpl
extends AbstractXMLObject
implements X509Certificate {
    private static final IndexingObjectStore<String> B64_CERT_STORE = new IndexingObjectStore();
    private static final Cleaner CLEANER = CleanerFactory.create(SecurityX509CertificateImpl.class);
    private Cleaner.Cleanable cleanable;
    private String b64CertIndex;

    protected SecurityX509CertificateImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getValue() {
        return (String)B64_CERT_STORE.get(this.b64CertIndex);
    }

    public void setValue(String newValue) {
        String newCert;
        String currentCert = (String)B64_CERT_STORE.get(this.b64CertIndex);
        if (!Objects.equals(currentCert, newCert = this.prepareForAssignment(currentCert, newValue))) {
            if (this.cleanable != null) {
                this.cleanable.clean();
                this.cleanable = null;
            }
            this.b64CertIndex = B64_CERT_STORE.put((Object)newCert);
            if (this.b64CertIndex != null) {
                this.cleanable = CLEANER.register((Object)this, new CleanerState(this.b64CertIndex));
            }
        }
    }

    public List<XMLObject> getOrderedChildren() {
        return Collections.emptyList();
    }

    static class CleanerState
    implements Runnable {
        private String index;

        public CleanerState(@Nonnull String idx) {
            this.index = idx;
        }

        @Override
        public void run() {
            B64_CERT_STORE.remove(this.index);
        }
    }
}

