/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.agents;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.agent.MLToolSpec;
import org.opensearch.ml.common.contextmanager.ContextManagerContext;
import org.opensearch.ml.common.hooks.HookEvent;
import org.opensearch.ml.common.hooks.HookRegistry;
import org.opensearch.ml.common.hooks.PostToolEvent;
import org.opensearch.ml.common.hooks.PreLLMEvent;
import org.opensearch.ml.common.memory.Memory;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.memory.ConversationIndexMemory;

public class AgentContextUtil {
    private static final Logger log = LogManager.getLogger(AgentContextUtil.class);

    public static ContextManagerContext buildContextManagerContextForToolOutput(String toolOutput, Map<String, String> parameters, List<MLToolSpec> toolSpecs, Memory memory) {
        String userPrompt;
        ContextManagerContext.ContextManagerContextBuilder builder = ContextManagerContext.builder();
        String systemPrompt = parameters.get("system_prompt");
        if (systemPrompt != null) {
            builder.systemPrompt(systemPrompt);
        }
        if ((userPrompt = parameters.get("question")) != null) {
            builder.userPrompt(userPrompt);
        }
        if (toolSpecs != null) {
            builder.toolConfigs(toolSpecs);
        }
        HashMap<String, String> contextParameters = new HashMap<String, String>();
        contextParameters.putAll(parameters);
        contextParameters.put("_current_tool_output", toolOutput);
        builder.parameters(contextParameters);
        return builder.build();
    }

    public static Object extractProcessedToolOutput(ContextManagerContext context) {
        if (context.getParameters() != null) {
            return context.getParameters().get("_current_tool_output");
        }
        return null;
    }

    public static Object extractFromContext(ContextManagerContext context, String key) {
        if (context.getParameters() != null) {
            return context.getParameters().get(key);
        }
        return null;
    }

    public static ContextManagerContext buildContextManagerContext(Map<String, String> parameters, List<String> interactions, List<MLToolSpec> toolSpecs, Memory memory) {
        String userPrompt;
        ContextManagerContext.ContextManagerContextBuilder builder = ContextManagerContext.builder();
        String systemPrompt = parameters.get("system_prompt");
        if (systemPrompt != null) {
            builder.systemPrompt(systemPrompt);
        }
        if ((userPrompt = parameters.get("question")) != null) {
            builder.userPrompt(userPrompt);
        }
        if (memory instanceof ConversationIndexMemory) {
            String string = parameters.get("chat_history");
        }
        if (toolSpecs != null) {
            builder.toolConfigs(toolSpecs);
        }
        builder.toolInteractions((List)(interactions != null ? interactions : new ArrayList()));
        HashMap<String, String> contextParameters = new HashMap<String, String>();
        contextParameters.putAll(parameters);
        builder.parameters(contextParameters);
        return builder.build();
    }

    public static Object emitPostToolHook(Object toolOutput, Map<String, String> parameters, List<MLToolSpec> toolSpecs, Memory memory, HookRegistry hookRegistry) {
        if (hookRegistry != null) {
            try {
                if (toolOutput == null) {
                    log.warn("Tool output is null, skipping POST_TOOL hook");
                    return null;
                }
                ContextManagerContext context = AgentContextUtil.buildContextManagerContextForToolOutput(StringUtils.toJson((Object)toolOutput), parameters, toolSpecs, memory);
                PostToolEvent event = new PostToolEvent(null, null, context, new HashMap());
                hookRegistry.emit((HookEvent)event);
                Object processedOutput = AgentContextUtil.extractProcessedToolOutput(context);
                return processedOutput != null ? processedOutput : toolOutput;
            }
            catch (Exception e) {
                log.error("Failed to emit POST_TOOL hook event", (Throwable)e);
                return toolOutput;
            }
        }
        return toolOutput;
    }

    public static ContextManagerContext emitPreLLMHook(Map<String, String> parameters, List<String> interactions, List<MLToolSpec> toolSpecs, Memory memory, HookRegistry hookRegistry) {
        ContextManagerContext context = AgentContextUtil.buildContextManagerContext(parameters, interactions, toolSpecs, memory);
        if (hookRegistry == null) {
            return context;
        }
        try {
            PreLLMEvent event = new PreLLMEvent(context, new HashMap());
            hookRegistry.emit((HookEvent)event);
            return context;
        }
        catch (Exception e) {
            log.error("Failed to emit PRE_LLM hook event", (Throwable)e);
            return context;
        }
    }

    public static void updateParametersFromContext(Map<String, String> parameters, ContextManagerContext context) {
        if (context.getSystemPrompt() != null) {
            parameters.put("system_prompt", context.getSystemPrompt());
        }
        if (context.getUserPrompt() != null) {
            parameters.put("question", context.getUserPrompt());
        }
        if (context.getChatHistory() == null || !context.getChatHistory().isEmpty()) {
            // empty if block
        }
        if (context.getToolInteractions() != null && !context.getToolInteractions().isEmpty()) {
            parameters.put("_interactions", ", " + String.join((CharSequence)", ", context.getToolInteractions()));
        }
        if (context.getParameters() != null) {
            for (Map.Entry entry : context.getParameters().entrySet()) {
                parameters.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

