/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.derivedsource;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.SegmentReadState;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.knn.index.codec.derivedsource.DerivedFieldInfo;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceLuceneHelper;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReaders;
import org.opensearch.knn.index.codec.derivedsource.PerFieldDerivedVectorTransformer;
import org.opensearch.knn.index.codec.derivedsource.PerFieldDerivedVectorTransformerFactory;

public class DerivedSourceVectorTransformer {
    @Generated
    private static final Logger log = LogManager.getLogger(DerivedSourceVectorTransformer.class);
    private final DerivedSourceReaders derivedSourceReaders;
    Function<Map<String, Object>, Map<String, Object>> derivedSourceVectorTransformer;
    Map<String, PerFieldDerivedVectorTransformer> perFieldDerivedVectorTransformers;
    private boolean isNested;
    private final DerivedSourceLuceneHelper derivedSourceLuceneHelper;

    public DerivedSourceVectorTransformer(DerivedSourceReaders derivedSourceReaders, SegmentReadState segmentReadState, List<DerivedFieldInfo> fieldsToInjectVector) {
        this.derivedSourceReaders = derivedSourceReaders;
        this.perFieldDerivedVectorTransformers = new HashMap<String, PerFieldDerivedVectorTransformer>();
        for (DerivedFieldInfo derivedFieldInfo : fieldsToInjectVector) {
            this.isNested = derivedFieldInfo.isNested() || this.isNested;
            PerFieldDerivedVectorTransformer perFieldDerivedVectorTransformer = PerFieldDerivedVectorTransformerFactory.create(derivedFieldInfo.fieldInfo(), derivedFieldInfo.isNested(), derivedSourceReaders);
            this.perFieldDerivedVectorTransformers.put(derivedFieldInfo.name(), perFieldDerivedVectorTransformer);
        }
        this.derivedSourceLuceneHelper = new DerivedSourceLuceneHelper(derivedSourceReaders, segmentReadState);
    }

    public void initialize(String[] includes, String[] excludes) {
        Set<String> fieldsToRemove = this.getFieldsToExclude(includes, excludes);
        for (String fieldName : fieldsToRemove) {
            this.perFieldDerivedVectorTransformers.remove(fieldName);
        }
        HashMap<String, PerFieldDerivedVectorTransformer> transformerFunctions = new HashMap<String, PerFieldDerivedVectorTransformer>();
        transformerFunctions.putAll(this.perFieldDerivedVectorTransformers);
        this.derivedSourceVectorTransformer = XContentMapValues.transform(transformerFunctions, (boolean)true);
    }

    private Set<String> getFieldsToExclude(String[] includes, String[] excludes) {
        HashSet<String> fieldsToRemove = new HashSet<String>();
        Set<String> allFields = this.perFieldDerivedVectorTransformers.keySet();
        if (includes != null && includes.length > 0) {
            for (String fieldName : allFields) {
                boolean matched = false;
                String[] stringArray = includes;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String includePattern = stringArray[i];
                    if (!Regex.simpleMatch((String)includePattern, (String)fieldName)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                fieldsToRemove.add(fieldName);
            }
        }
        if (excludes != null && excludes.length > 0) {
            block2: for (String fieldName : allFields) {
                if (fieldsToRemove.contains(fieldName)) continue;
                for (String excludePattern : excludes) {
                    if (!Regex.simpleMatch((String)excludePattern, (String)fieldName)) continue;
                    fieldsToRemove.add(fieldName);
                    continue block2;
                }
            }
        }
        return fieldsToRemove;
    }

    public boolean hasFieldsToInject() {
        return !this.perFieldDerivedVectorTransformers.isEmpty();
    }

    public byte[] injectVectors(int docId, byte[] sourceAsBytes) throws IOException {
        Tuple mapTuple = XContentHelper.convertToMap((BytesReference)BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(sourceAsBytes)), (boolean)true, (MediaType)MediaTypeRegistry.getDefaultMediaType());
        Map sourceAsMap = (Map)mapTuple.v2();
        int offset = 0;
        if (this.isNested) {
            offset = this.derivedSourceLuceneHelper.getFirstChild(docId);
        }
        for (PerFieldDerivedVectorTransformer vectorTransformer : this.perFieldDerivedVectorTransformers.values()) {
            vectorTransformer.setCurrentDoc(offset, docId);
        }
        Map<String, Object> copy = this.derivedSourceVectorTransformer.apply(sourceAsMap);
        BytesStreamOutput bStream = new BytesStreamOutput(1024);
        MediaType actualContentType = (MediaType)mapTuple.v1();
        XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)actualContentType, (OutputStream)bStream).map(copy);
        builder.close();
        return BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)builder));
    }
}

