/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import shaded.com.google.common.collect.ImmutableMap;

public class RenameOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final Map<ReferenceExpression, ReferenceExpression> mapping;
    private final Map<String, ReferenceExpression> nameMapping;

    public RenameOperator(PhysicalPlan input, Map<ReferenceExpression, ReferenceExpression> mapping) {
        this.input = input;
        this.mapping = mapping;
        this.nameMapping = mapping.entrySet().stream().collect(Collectors.toMap(entry -> ((ReferenceExpression)entry.getKey()).getAttr(), entry -> (ReferenceExpression)entry.getValue()));
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitRename(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.input.hasNext();
    }

    @Override
    public ExprValue next() {
        ExprValue inputValue = (ExprValue)this.input.next();
        if (ExprCoreType.STRUCT == inputValue.type()) {
            Map<String, ExprValue> tupleValue = ExprValueUtils.getTupleValue(inputValue);
            ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
            for (String bindName : tupleValue.keySet()) {
                if (this.nameMapping.containsKey(bindName)) {
                    mapBuilder.put((Object)this.nameMapping.get(bindName).getAttr(), (Object)tupleValue.get(bindName));
                    continue;
                }
                mapBuilder.put((Object)bindName, (Object)tupleValue.get(bindName));
            }
            return ExprTupleValue.fromExprValueMap((Map<String, ExprValue>)mapBuilder.build());
        }
        return inputValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenameOperator)) {
            return false;
        }
        RenameOperator other = (RenameOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        Map<ReferenceExpression, ReferenceExpression> this$mapping = this.getMapping();
        Map<ReferenceExpression, ReferenceExpression> other$mapping = other.getMapping();
        return !(this$mapping == null ? other$mapping != null : !((Object)this$mapping).equals(other$mapping));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RenameOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        Map<ReferenceExpression, ReferenceExpression> $mapping = this.getMapping();
        result = result * 59 + ($mapping == null ? 43 : ((Object)$mapping).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RenameOperator(input=" + String.valueOf(this.getInput()) + ", mapping=" + String.valueOf(this.getMapping()) + ")";
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public Map<ReferenceExpression, ReferenceExpression> getMapping() {
        return this.mapping;
    }
}

