/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.streaming;

import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.streaming.StreamingCostEstimable;

@ExperimentalApi
public record StreamingCostMetrics(boolean streamable, int topNSize) {
    public StreamingCostMetrics {
        assert (topNSize >= 0) : "topNSize must be non-negative";
    }

    public static StreamingCostMetrics nonStreamable() {
        return new StreamingCostMetrics(false, 0);
    }

    public static StreamingCostMetrics neutral() {
        return new StreamingCostMetrics(true, 1);
    }

    public StreamingCostMetrics combineWithSubAggregation(StreamingCostMetrics subAggMetrics) {
        assert (subAggMetrics != null) : "subAggMetrics must not be null";
        if (!this.streamable || !subAggMetrics.streamable) {
            return StreamingCostMetrics.nonStreamable();
        }
        try {
            int combinedTopNSize = Math.multiplyExact(this.topNSize, subAggMetrics.topNSize);
            return new StreamingCostMetrics(true, combinedTopNSize);
        }
        catch (ArithmeticException e) {
            return StreamingCostMetrics.nonStreamable();
        }
    }

    public StreamingCostMetrics combineWithSibling(StreamingCostMetrics siblingMetrics) {
        assert (siblingMetrics != null) : "siblingMetrics must not be null";
        if (!this.streamable || !siblingMetrics.streamable) {
            return StreamingCostMetrics.nonStreamable();
        }
        try {
            int combinedTopNSize = Math.addExact(this.topNSize, siblingMetrics.topNSize);
            return new StreamingCostMetrics(true, combinedTopNSize);
        }
        catch (ArithmeticException e) {
            return StreamingCostMetrics.nonStreamable();
        }
    }

    public static StreamingCostMetrics estimateFromFactories(AggregatorFactory[] factories, SearchContext searchContext) {
        assert (factories.length > 0) : "factories array must be non-empty";
        StreamingCostMetrics combined = null;
        for (AggregatorFactory factory : factories) {
            StreamingCostMetrics metrics = StreamingCostMetrics.estimateFromFactory(factory, searchContext);
            if (!metrics.streamable()) {
                return StreamingCostMetrics.nonStreamable();
            }
            combined = combined == null ? metrics : combined.combineWithSibling(metrics);
        }
        return combined;
    }

    private static StreamingCostMetrics estimateFromFactory(AggregatorFactory factory, SearchContext searchContext) {
        if (!(factory instanceof StreamingCostEstimable)) {
            return StreamingCostMetrics.nonStreamable();
        }
        StreamingCostEstimable estimable = (StreamingCostEstimable)((Object)factory);
        StreamingCostMetrics factoryMetrics = estimable.estimateStreamingCost(searchContext);
        if (!factoryMetrics.streamable()) {
            return StreamingCostMetrics.nonStreamable();
        }
        AggregatorFactory[] subFactories = factory.getSubFactories().getFactories();
        if (subFactories.length > 0) {
            StreamingCostMetrics subMetrics = StreamingCostMetrics.estimateFromFactories(subFactories, searchContext);
            if (!subMetrics.streamable()) {
                return StreamingCostMetrics.nonStreamable();
            }
            factoryMetrics = factoryMetrics.combineWithSubAggregation(subMetrics);
        }
        return factoryMetrics;
    }
}

