/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.metal.MetalUtils;
import com.jidesoft.swing.TristateButtonModel;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalIconFactory
implements Serializable {
    private static Icon checkBoxIcon;

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        private void paintOceanIcon(Component c, Graphics g, int x, int y) {
            ButtonModel model = ((JCheckBox)c).getModel();
            g.translate(x, y);
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g.setColor(MetalLookAndFeel.getControlShadow());
                    g.fillRect(0, 0, w, h);
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.fillRect(0, 0, w, 2);
                    g.fillRect(0, 2, 2, h - 2);
                    g.fillRect(w - 1, 1, 1, h - 1);
                    g.fillRect(1, h - 1, w - 2, 1);
                } else if (model.isRollover()) {
                    MetalUtils.drawGradient(c, g, "CheckBox.gradient", 0, 0, w, h, true);
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, h - 1);
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                    g.drawRect(1, 1, w - 3, h - 3);
                    g.drawRect(2, 2, w - 5, h - 5);
                } else {
                    MetalUtils.drawGradient(c, g, "CheckBox.gradient", 0, 0, w, h, true);
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, h - 1);
                }
                g.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawRect(0, 0, w - 1, h - 1);
            }
            g.translate(-x, -y);
            if (model instanceof TristateButtonModel && ((TristateButtonModel)model).isMixed()) {
                this.drawSquare(c, g, x, y);
            } else if (model.isSelected()) {
                this.drawCheck(c, g, x, y);
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                this.paintOceanIcon(c, g, x, y);
                return;
            }
            ButtonModel model = ((JCheckBox)c).getModel();
            int controlSize = this.getControlSize();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g.setColor(MetalLookAndFeel.getControlShadow());
                    g.fillRect(x, y, controlSize - 1, controlSize - 1);
                    MetalUtils.drawPressed3DBorder(g, x, y, controlSize, controlSize);
                } else {
                    MetalUtils.drawFlush3DBorder(g, x, y, controlSize, controlSize);
                }
                g.setColor(c.getForeground());
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(x, y, controlSize - 2, controlSize - 2);
            }
            if (model instanceof TristateButtonModel && ((TristateButtonModel)model).isMixed()) {
                this.drawSquare(c, g, x, y);
            } else if (model.isSelected()) {
                this.drawCheck(c, g, x, y);
            }
        }

        protected void drawCheck(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            g.fillRect(x + 3, y + 5, 2, controlSize - 8);
            g.drawLine(x + (controlSize - 4), y + 3, x + 5, y + (controlSize - 6));
            g.drawLine(x + (controlSize - 4), y + 4, x + 5, y + (controlSize - 5));
        }

        protected void drawSquare(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            g.fillRect(x + 3, y + 3, controlSize - 6, controlSize - 6);
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }
    }
}

