/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttestedCredentialData {
    private final AAGUID aaguid;
    private final byte[] credentialId;
    private final COSEKey coseKey;

    public AttestedCredentialData(@NotNull AAGUID aaguid, @NotNull byte[] credentialId, @NotNull COSEKey coseKey) {
        AssertUtil.notNull(aaguid, "aaguid must not be null");
        AssertUtil.notNull(credentialId, "credentialId must not be null");
        AssertUtil.notNull(coseKey, "coseKey must not be null");
        this.aaguid = aaguid;
        this.credentialId = credentialId;
        this.coseKey = coseKey;
    }

    private AttestedCredentialData() {
        this.aaguid = null;
        this.credentialId = null;
        this.coseKey = null;
    }

    @NotNull
    public AAGUID getAaguid() {
        return this.aaguid;
    }

    @NotNull
    public byte[] getCredentialId() {
        return ArrayUtil.clone(this.credentialId);
    }

    @NotNull
    public COSEKey getCOSEKey() {
        return this.coseKey;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestedCredentialData that = (AttestedCredentialData)o;
        return Objects.equals(this.aaguid, that.aaguid) && Arrays.equals(this.credentialId, that.credentialId) && Objects.equals(this.coseKey, that.coseKey);
    }

    public int hashCode() {
        int result = Objects.hash(this.aaguid, this.coseKey);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        return result;
    }

    public String toString() {
        return "AttestedCredentialData(aaguid=" + String.valueOf(this.aaguid) + ", credentialId=" + ArrayUtil.toHexString(this.credentialId) + ", coseKey=" + String.valueOf(this.coseKey) + ")";
    }
}

