/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.subscription;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Flow;

public class MultiSubscriberAdapter<T>
implements MultiSubscriber<T>,
ContextSupport {
    private final Flow.Subscriber<? super T> downstream;

    public MultiSubscriberAdapter(Flow.Subscriber<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.downstream.onSubscribe(subscription);
    }

    @Override
    public void onItem(T item) {
        this.downstream.onNext(item);
    }

    @Override
    public void onFailure(Throwable failure) {
        this.downstream.onError(failure);
    }

    @Override
    public void onCompletion() {
        this.downstream.onComplete();
    }

    @Override
    public Context context() {
        if (this.downstream instanceof ContextSupport) {
            return ((ContextSupport)((Object)this.downstream)).context();
        }
        return Context.empty();
    }
}

