/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging;

import jakarta.transaction.TransactionManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.CrossSiteIllegalLifecycleStateException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.configuration.io.Location;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.concurrent.FileSystemLock;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.interceptors.impl.ContainerFullException;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.logging.annotations.Description;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.topology.CacheJoinException;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.MissingMembersException;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.InvalidTransactionException;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.util.ByteString;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;
import org.jboss.logging.annotations.Param;
import org.jgroups.View;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    public static final String LOG_ROOT = "org.infinispan.";
    public static final Log CONFIG = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.CONFIG");
    public static final Log CLUSTER = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.CLUSTER");
    public static final Log CONTAINER = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.CONTAINER");
    public static final Log PERSISTENCE = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.PERSISTENCE");
    public static final Log SECURITY = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.SECURITY");
    public static final Log XSITE = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.XSITE");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Problem encountered when applying state for key %s!", id=16)
    public void problemApplyingStateForKey(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Expected just one response; got %s", id=21)
    public void expectedJustOneResponse(Map<Address, Response> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="wakeUpInterval is <= 0, not starting expired purge thread", id=25)
    public void notStartingEvictionThread();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Caught exception purging data container!", id=26)
    public void exceptionPurgingDataContainer(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to passivate entry under %s", id=28)
    public void unableToPassivateEntry(Object var1, @Cause Throwable var2);

    @Message(value="The '%s' JMX domain is already in use.", id=34)
    public JmxDomainConflictException jmxMBeanAlreadyRegistered(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Did not find attribute %s", id=36)
    public void couldNotFindAttribute(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to update attribute name %s with value %s", id=37)
    public void failedToUpdateAttribute(String var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Did not find queried attribute with name %s", id=42)
    public void queriedAttributeNotFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception while writing value for attribute %s", id=43)
    public void errorWritingValueForAttribute(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not invoke set on attribute %s with value %s", id=44)
    public void couldNotInvokeSetOnAttribute(String var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unknown responses from remote cache: %s", id=46)
    public void unknownResponsesFromRemoteCache(Collection<Response> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while doing remote call", id=47)
    public void errorDoingRemoteCall(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Caught exception when handling command %s", id=71)
    public void exceptionHandlingCommand(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error while replicating", id=73)
    public void unexpectedErrorReplicating(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Starting JGroups channel `%s`", id=78)
    public void startingJGroupsChannel(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Starting JGroups channel `%s` with stack `%s`", id=78)
    public void startingJGroupsChannel(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Channel `%s` local address is `%s`, physical addresses are `%s`", id=79)
    public void localAndPhysicalAddress(String var1, Address var2, List<Address> var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Disconnecting JGroups channel `%s`", id=80)
    public void disconnectJGroups(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Problem closing channel `%s`; setting it to null", id=81)
    public void problemClosingChannel(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Class [%s] cannot be cast to JGroupsChannelLookup! Not using a channel lookup.", id=83)
    public void wrongTypeForJGroupsChannelLookup(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Errors instantiating [%s]! Not using a channel lookup.", id=84)
    public void errorInstantiatingJGroupsChannelLookup(String var1, @Cause Exception var2);

    @Message(value="Error while trying to create a channel using the specified configuration file: %s", id=85)
    public CacheConfigurationException errorCreatingChannelFromConfigFile(String var1, @Cause Exception var2);

    @Message(value="Error while trying to create a channel using the specified configuration XML: %s", id=86)
    public CacheConfigurationException errorCreatingChannelFromXML(String var1, @Cause Exception var2);

    @Message(value="Error while trying to create a channel using the specified configuration string: %s", id=87)
    public CacheConfigurationException errorCreatingChannelFromConfigString(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to use any JGroups configuration mechanisms provided in properties %s. Using default JGroups configuration!", id=88)
    public void unableToUseJGroupsPropertiesProvided(TypedProperties var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="getCoordinator(): Interrupted while waiting for members to be set", id=89)
    public void interruptedWaitingForCoordinator(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Received new, MERGED cluster view for channel %s: %s", id=93)
    public void receivedMergedView(String var1, View var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Received new cluster view for channel %s: %s", id=94)
    public void receivedClusterView(String var1, View var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while processing a prepare in a single-phase transaction", id=97)
    public void errorProcessing1pcPrepareCommand(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception during rollback", id=98)
    public void errorRollingBack(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Stopping, but there are %s local transactions and %s remote transactions that did not finish in time.", id=100)
    public void unfinishedTransactionsRemain(int var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed synchronization registration", id=101)
    public void failedSynchronizationRegistration(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to roll back global transaction %s", id=102)
    public void unableToRollbackGlobalTx(GlobalTransaction var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Using EmbeddedTransactionManager", id=104)
    public void fallingBackToEmbeddedTm();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed creating initial JNDI context", id=105)
    public void failedToCreateInitialCtx(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Retrieving transaction manager %s", id=107)
    public void retrievingTm(TransactionManager var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Recovery call will be ignored as recovery is disabled. More on recovery: http://community.jboss.org/docs/DOC-16646", id=115)
    public void recoveryIgnored();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Missing the list of prepared transactions from node %s. Received response is %s", id=116)
    public void missingListPreparedTransactions(Object var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="There's already a prepared transaction with this xid: %s. New transaction is %s. Are there two different transactions having same Xid in the cluster?", id=117)
    public void preparedTxAlreadyExists(RecoveryAwareTransaction var1, RecoveryAwareRemoteTransaction var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to set value!", id=121)
    public void unableToSetValue(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to stop() from FAILED state, but caught exception", id=126)
    public void failedToCallStopAfterFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Infinispan version: %s", id=128)
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to register listener of class %s, but no valid, public methods annotated with method-level event annotations found! Ignoring listener.", id=133)
    public void noAnnotateMethodsFoundInListener(Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to invoke method %s on Object instance %s - removing this target object from list of listeners!", id=134)
    public void unableToInvokeListenerMethodAndRemoveListener(Method var1, Object var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not lock key %s in order to invalidate from L1 at node %s, skipping....", id=135)
    public void unableToLockToInvalidate(Object var1, Address var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error executing command %s on %s, writing keys %s", id=136)
    public void executionError(String var1, String var2, String var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Failed invalidating remote cache", id=137)
    public void failedInvalidatingRemoteCache(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not rollback prepared 1PC transaction. This transaction will be rolled back by the recovery process, if enabled. Transaction: %s", id=141)
    public void couldNotRollbackPrepared1PcTransaction(LocalTransaction var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error invalidating keys from L1 after rehash", id=147)
    public void failedToInvalidateKeys(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Passivation configured without an eviction policy being selected. Only manually evicted entities will be passivated.", id=152)
    public void passivationWithoutEviction();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not complete injected transaction.", id=160)
    public void couldNotCompleteInjectedTransaction(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Using a batchMode transaction manager", id=161)
    public void usingBatchModeTransactionManager();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Could not instantiate transaction manager", id=162)
    public void couldNotInstantiateTransactionManager(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s has been deprecated as a synonym for %s. Use one of %s instead", id=177)
    public void randomCacheModeSynonymsDeprecated(String var1, String var2, List<String> var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while processing a commit in a two-phase transaction", id=188)
    public void errorProcessing2pcCommitCommand(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="While stopping a cache or cache manager, one of its components failed to stop", id=189)
    public void componentFailedToStop(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed loading keys from cache store", id=194)
    public void failedLoadingKeysFromCacheStore(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error during rebalance for cache %s on node %s, topology id = %d", id=195)
    public void rebalanceError(String var1, Address var2, int var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to recover cluster state after the current node became the coordinator (or after merge), will retry", id=196)
    public void failedToRecoverClusterState(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error updating cluster member list for view %d, waiting for next view", id=197)
    public void errorUpdatingMembersList(int var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="This cache is configured to backup to its own site (%s).", id=201)
    public void cacheBackupsDataToSameSite(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Encountered issues while backing up data for cache %s to site %s", id=202)
    @Description(value="This message indicates an issue has occurred with state transfer operations. First check that the site is online and if any network issues have occurred. Confirm that the relay nodes in the cluster are not overloaded with cross-site replication requests. In some cases garbage collection pauses can also interrupt backup operations. You can either increase the amount of memory available to relay nodes or increase the number of relay nodes in the cluster.")
    public void warnXsiteBackupFailed(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The rollback request for tx %s cannot be processed by the cache %s as this cache is not transactional!", id=203)
    public void cannotRespondToRollback(GlobalTransaction var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The commit request for tx %s cannot be processed by the cache %s as this cache is not transactional!", id=204)
    public void cannotRespondToCommit(GlobalTransaction var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Trying to bring back an non-existent site (%s)!", id=205)
    public void tryingToBringOnlineNonexistentSite(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="No live owners found for segments %s of cache %s. Excluded owners: %s", id=208)
    public void noLiveOwnersFoundForSegments(Collection<Integer> var1, String var2, Collection<Address> var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to retrieve transactions of cache %s from node %s, segments %s", id=209)
    public void failedToRetrieveTransactionsForSegments(String var1, Address var2, Collection<Integer> var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to request state of cache %s from node %s, segments %s", id=210)
    public void failedToRequestSegments(String var1, Address var2, Collection<Integer> var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to remove entry under %s from cache store after activation", id=214)
    public void unableToRemoveEntryAfterActivation(Object var1, @Cause Throwable var2);

    @Message(value="Unknown migrator %s", id=215)
    public IllegalArgumentException unknownMigrator(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%d entries migrated to cache %s in %s", id=216)
    public void entriesMigrated(long var1, String var3, String var4);

    @Message(value="Received exception from %s, see cause for remote stack trace", id=217)
    public RemoteException remoteException(Address var1, @Cause Throwable var2);

    @Message(value="Custom interceptor missing class", id=222)
    public CacheConfigurationException customInterceptorMissingClass();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Custom interceptor '%s' does not extend BaseCustomInterceptor, which is recommended", id=223)
    public void suggestCustomInterceptorInheritance(String var1);

    @Message(value="Custom interceptor '%s' specifies more than one position", id=224)
    public CacheConfigurationException multipleCustomInterceptorPositions(String var1);

    @Message(value="Custom interceptor '%s' doesn't specify a position", id=225)
    public CacheConfigurationException missingCustomInterceptorPosition(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to recover cache %s state after the current node became the coordinator", id=228)
    public void failedToRecoverCacheState(String var1, @Cause Throwable var2);

    @Message(value="Unexpected initial version type (only NumericVersion instances supported): %s", id=229)
    public IllegalArgumentException unexpectedInitialVersion(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to start rebalance for cache %s", id=230)
    public void rebalanceStartError(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Root element for %s already registered in ParserRegistry by %s. Cannot install %s.", id=234)
    public void parserRootElementAlreadyRegistered(String var1, String var2, String var3);

    @Message(value="Configuration parser %s does not declare any Namespace annotations", id=235)
    public CacheConfigurationException parserDoesNotDeclareNamespaces(String var1);

    @Message(value="Directory %s does not exist and cannot be created!", id=238)
    public CacheConfigurationException directoryCannotBeCreated(String var1);

    @Message(value="Missing foreign externalizer with id=%s, either externalizer was not configured by client, or module lifecycle implementation adding externalizer was not loaded properly", id=242)
    public CacheException missingForeignExternalizer(int var1);

    @Message(value="Type of data read is unknown. Id=%d is not amongst known reader indexes.", id=243)
    public CacheException unknownExternalizerReaderIndex(int var1);

    @Message(value="AdvancedExternalizer's getTypeClasses for externalizer %s must return a non-empty set", id=244)
    public CacheConfigurationException advanceExternalizerTypeClassesUndefined(String var1);

    @Message(value="Duplicate id found! AdvancedExternalizer id=%d for %s is shared by another externalizer (%s). Reader index is %d", id=245)
    public CacheConfigurationException duplicateExternalizerIdFound(int var1, Class<?> var2, String var3, int var4);

    @Message(value="Internal %s externalizer is using an id(%d) that exceeded the limit. It needs to be smaller than %d", id=246)
    public CacheConfigurationException internalExternalizerIdLimitExceeded(AdvancedExternalizer<?> var1, int var2, int var3);

    @Message(value="Foreign %s externalizer is using a negative id(%d). Only positive id values are allowed.", id=247)
    public CacheConfigurationException foreignExternalizerUsingNegativeId(AdvancedExternalizer<?> var1, int var2);

    @Message(value="The cache loader configuration %s does not specify the loader class using @ConfigurationFor", id=249)
    public CacheConfigurationException loaderConfigurationDoesNotSpecifyLoaderClass(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while processing prepare", id=255)
    public void errorProcessingPrepare(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to execute outbound transfer", id=261)
    public void failedOutBoundTransferExecution(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to enlist TransactionXaAdapter to transaction", id=262)
    public void failedToEnlistTransactionXaAdapter(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Not using an L1 invalidation reaper thread. This could lead to memory leaks as the requestors map may grow indefinitely!", id=264)
    public void warnL1NotHavingReaperThread();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems creating interceptor %s", id=267)
    public void unableToCreateInterceptor(Class<?> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to broadcast invalidations as a part of the prepare phase. Rolling back.", id=268)
    public void unableToRollbackInvalidationsDuringPrepare(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cache used for Grid metadata should be synchronous.", id=269)
    public void warnGridFSMetadataCacheRequiresSync();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not commit local tx %s", id=270)
    public void warnCouldNotCommitLocalTx(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not rollback local tx %s", id=271)
    public void warnCouldNotRollbackLocalTx(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception removing recovery information", id=272)
    public void warnExceptionRemovingRecovery(@Cause Throwable var1);

    @Message(value="Indexing can not be enabled on caches in Invalidation mode", id=273)
    public CacheConfigurationException invalidConfigurationIndexingWithInvalidation();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Persistence enabled without any CacheLoaderInterceptor in InterceptorChain!", id=274)
    public void persistenceWithoutCacheLoaderInterceptor();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Persistence enabled without any CacheWriteInterceptor in InterceptorChain!", id=275)
    public void persistenceWithoutCacheWriteInterceptor();

    @Message(value="Indexing can only be enabled if infinispan-query.jar is available on your classpath, and this jar has not been detected.", id=278)
    public CacheConfigurationException invalidConfigurationIndexingWithoutModule();

    @Message(value="Failed to read stored entries from file. Error in file %s at offset %d", id=279)
    public PersistenceException errorReadingFileStore(String var1, long var2);

    @Message(value="Caught exception [%s] while invoking method [%s] on listener instance: %s", id=280)
    public CacheListenerException exceptionInvokingListener(String var1, Method var2, Object var3, @Cause Throwable var4);

    @Message(value="%s reported that a third node was suspected, see cause for info on the node that was suspected", id=281)
    public SuspectException thirdPartySuspected(Address var1, @Cause SuspectException var2);

    @Message(value="Cannot enable Invocation Batching when the Transaction Mode is NON_TRANSACTIONAL, set the transaction mode to TRANSACTIONAL", id=282)
    public CacheConfigurationException invocationBatchingNeedsTransactionalCache();

    @Message(value="A cache configured with invocation batching can't have recovery enabled", id=283)
    public CacheConfigurationException invocationBatchingCannotBeRecoverable();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problem encountered while installing cluster listener", id=284)
    public void clusterListenerInstallationFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Issue when retrieving cluster listeners from %s response was %s", id=285)
    public void unsuccessfulResponseForClusterListeners(Address var1, Response var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Issue when retrieving cluster listeners from %s", id=286)
    public void exceptionDuringClusterListenerRetrieval(Address var1, @Cause Throwable var2);

    @Message(value="Unauthorized access: subject '%s' lacks '%s' permission", id=287)
    public SecurityException unauthorizedAccess(String var1, String var2);

    @Message(value="A principal-to-role mapper has not been specified", id=288)
    public CacheConfigurationException invalidPrincipalRoleMapper();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cannot send cross-site state chunk to '%s'.", id=289)
    @Description(value="During a state transfer operation it was not possible to transfer a batch of cache entries. First check that the site is online and if any network issues have occurred. Confirm that the relay nodes in the cluster are not overloaded with cross-site replication requests. In some cases garbage collection pauses can also interrupt backup operations. You can either increase the amount of memory available to relay nodes or increase the number of relay nodes in the cluster.")
    public void unableToSendXSiteState(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cannot apply cross-site state chunk.", id=291)
    @Description(value="During a state transfer operation it was not possible to apply a batch of cache entries. Ensure that sites are online and check network status.")
    public void unableToApplyXSiteState(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Ignoring attribute %s at %s, please remove from configuration file", id=293)
    public void ignoreAttribute(Object var1, Location var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Ignoring element %s at %s, please remove from configuration file", id=294)
    public void ignoreXmlElement(Object var1, Location var2);

    @Message(value="No thread pool with name '%s' found", id=295)
    public CacheConfigurationException undefinedThreadPoolName(String var1);

    @Message(value="Attempt to add a %s permission to a SecurityPermissionCollection", id=296)
    public IllegalArgumentException invalidPermission(Permission var1);

    @Message(value="Attempt to add a permission to a read-only SecurityPermissionCollection", id=297)
    public SecurityException readOnlyPermissionCollection();

    @Message(value="Unable to acquire lock after %s for key %s and requestor %s. Lock is held by %s", id=299)
    public TimeoutException unableToAcquireLock(String var1, Object var2, Object var3, Object var4);

    @Message(value="There was an exception while processing retrieval of entry values", id=300)
    public CacheException exceptionProcessingEntryRetrievalValues(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Issue when retrieving transactions from %s, response was %s", id=302)
    public void unsuccessfulResponseRetrievingTransactionsForSegments(Address var1, Response var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="More than one configuration file with specified name on classpath. The first one will be used:\n %s", id=304)
    public void ambiguousConfigurationFiles(String var1);

    @Message(value="Cluster is operating in degraded mode because of node failures.", id=305)
    public AvailabilityException partitionDegraded();

    @Message(value="Key '%s' is not available. Not all owners are in this partition", id=306)
    public AvailabilityException degradedModeKeyUnavailable(Object var1);

    @Message(value="Cannot clear when the cluster is partitioned", id=307)
    public AvailabilityException clearDisallowedWhilePartitioned();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Rebalancing enabled", id=308)
    public void rebalancingEnabled();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Rebalancing suspended", id=309)
    public void rebalancingSuspended();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Starting new rebalance phase for cache %s, topology %s", id=310)
    public void startingRebalancePhase(String var1, CacheTopology var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cyclic dependency detected between caches, stop order ignored", id=321)
    public void stopOrderIgnored();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cannot restart cross-site state transfer to site %s", id=322)
    @Description(value="It was not possible to resume a state transfer operation to a backup location. Ensure that sites are online and check network status.")
    public void failedToRestartXSiteStateTransfer(String var1, @Cause Throwable var2);

    @Message(value="%s is in '%s' state and so it does not accept new invocations. Either restart it or recreate the cache container.", id=323)
    public IllegalLifecycleStateException cacheIsTerminated(String var1, String var2);

    @Message(value="%s is in 'STOPPING' state and this is an invocation not belonging to an on-going transaction, so it does not accept new invocations. Either restart it or recreate the cache container.", id=324)
    public IllegalLifecycleStateException cacheIsStopping(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Remote transaction %s timed out. Rolling back after %d ms", id=326)
    public void remoteTransactionTimeout(GlobalTransaction var1, long var2);

    @Message(value="Cannot find a parser for element '%s' in namespace '%s' at %s. Check that your configuration is up-to-date for Infinispan '%s' and you have the proper dependency in the classpath", id=327)
    public CacheConfigurationException unsupportedConfiguration(String var1, String var2, Location var3, String var4);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Rebalance phase %s confirmed for cache %s on node %s, topology id = %d", id=328)
    public void rebalancePhaseConfirmedOnNode(CacheTopology.Phase var1, String var2, Address var3, int var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to read rebalancing status from coordinator %s", id=329)
    public void errorReadingRebalancingStatus(Address var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to invoke method %s on Object instance %s ", id=331)
    public void unableToInvokeListenerMethod(Method var1, Object var2, @Cause Throwable var3);

    @Message(value="Two-phase commit can only be used with synchronous backup strategy.", id=335)
    public CacheConfigurationException twoPhaseCommitAsyncBackup();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Finished rebalance for cache %s, topology %s", id=336)
    public void finishedRebalance(String var1, CacheTopology var2);

    @Message(value="Backup configuration must include a 'site'.", id=337)
    @Description(value="Caches that use cross-site replication must include a site in the configuration. Edit the cache and specify the name of the site in the backup configuration.")
    public CacheConfigurationException backupMissingSite();

    @Message(value="You must specify a 'failure-policy-class' to use a custom backup failure policy for backup '%s'.", id=338)
    @Description(value="The backup configuration for the cache uses a custom failure policy but does not include the fully qualified class of a custom failure policy implementation. Specify the failure policy class in the backup configuration or use a different failure policy.")
    public CacheConfigurationException missingBackupFailurePolicyClass(String var1);

    @Message(value="Remote cache name is missing or null in backup configuration.", id=339)
    @Description(value="Cross-site replication backs up data to caches with the same name by default. If you want to backup to a cache with a different name, you must specify the name of the remote cache in the 'backup-for' configuration. Modify cache configuration to include the name of the remote cache.")
    public CacheConfigurationException backupForNullCache();

    @Message(value="Remote cache name and remote site is missing or null in backup configuration.", id=340)
    @Description(value="Cross-site replication backs up data to caches with the same name by default. If you want to backup to a cache with a different name, you must specify the name of the remote cache and the remote site in the 'backup-for' configuration. Modify cache configuration to include the name of the remote cache and remote site.")
    public CacheConfigurationException backupForMissingParameters();

    @Message(value="Must have a transport set in the global configuration in order to define a clustered cache", id=343)
    public CacheConfigurationException missingTransportConfiguration();

    @Message(value="reaperWakeUpInterval must be >= 0, we got %d", id=344)
    public CacheConfigurationException invalidReaperWakeUpInterval(long var1);

    @Message(value="completedTxTimeout must be >= 0, we got %d", id=345)
    public CacheConfigurationException invalidCompletedTxTimeout(long var1);

    @Message(value="Enabling the L1 cache is only supported when using DISTRIBUTED as a cache mode.  Your cache mode is set to %s", id=350)
    public CacheConfigurationException l1OnlyForDistributedCache(String var1);

    @Message(value="Using a L1 lifespan of 0 or a negative value is meaningless", id=351)
    public CacheConfigurationException l1InvalidLifespan();

    @Message(value="Enabling the L1 cache is not supported when using EXCEPTION based eviction.", id=352)
    public CacheConfigurationException l1NotValidWithExpirationEviction();

    @Message(value="Cannot define both interceptor class (%s) and interceptor instance (%s)", id=354)
    public CacheConfigurationException interceptorClassAndInstanceDefined(String var1, String var2);

    @Message(value="Unable to instantiate loader/writer instance for StoreConfiguration %s", id=355)
    public CacheConfigurationException unableToInstantiateClass(Class<?> var1);

    @Message(value="A cache configuration named %s already exists. This cannot be configured externally by the user.", id=358)
    public CacheConfigurationException existingConfigForInternalCache(String var1);

    @Message(value="Keys '%s' are not available. Not all owners are in this partition", id=359)
    public AvailabilityException degradedModeKeysUnavailable(Collection<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The xml element eviction-executor has been deprecated and replaced by expiration-executor, please update your configuration file.", id=360)
    public void evictionExecutorDeprecated();

    @Message(value="Cannot commit remote transaction %s as it was already rolled back", id=361)
    public CacheException remoteTransactionAlreadyRolledBack(GlobalTransaction var1);

    @Message(value="Could not find status for remote transaction %s, please increase transaction.completedTxTimeout", id=362)
    public TimeoutException remoteTransactionStatusMissing(GlobalTransaction var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No filter indexing service provider found for indexed filter of type %s", id=363)
    public void noFilterIndexingServiceProviderFound(String var1);

    @Message(value="Attempted to register cluster listener of class %s, but listener is annotated as only observing pre events!", id=364)
    public CacheException clusterListenerRegisteredWithOnlyPreEvents(Class<?> var1);

    @Message(value="Could not find the specified JGroups configuration file '%s'", id=365)
    public CacheConfigurationException jgroupsConfigurationNotFound(String var1);

    @Message(value="Cannot remove cache configuration '%s' because it is in use", id=371)
    public IllegalStateException configurationInUse(String var1);

    @Message(value="Attempted to start a cache using configuration template '%s'", id=373)
    public CacheConfigurationException templateConfigurationStartAttempt(String var1);

    @Message(value="No such template '%s' when declaring '%s'", id=374)
    public CacheConfigurationException undeclaredConfiguration(String var1, String var2);

    @Message(value="No such template/configuration '%s'", id=375)
    public CacheConfigurationException noConfiguration(String var1);

    @Message(value="Interceptor stack is not supported in simple cache", id=376)
    public UnsupportedOperationException interceptorStackNotSupported();

    @Message(value="Explicit lock operations are not supported in simple cache", id=377)
    public UnsupportedOperationException lockOperationsNotSupported();

    @Message(value="Invocation batching not enabled in current configuration! Please enable it.", id=378)
    public CacheConfigurationException invocationBatchingNotEnabled();

    @Message(value="This configuration is not supported for simple cache", id=381)
    public CacheConfigurationException notSupportedInSimpleCache();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Global state persistence was enabled without specifying a location", id=382)
    public void missingGlobalStatePersistentLocation();

    @Message(value="Unable to broadcast invalidation messages", id=384)
    public RuntimeException unableToBroadcastInvalidation(@Cause Throwable var1);

    @Message(value="Failed to read persisted state from file %s. Aborting.", id=386)
    public CacheConfigurationException failedReadingPersistentState(@Cause IOException var1, File var2);

    @Message(value="Failed to write state to file %s.", id=387)
    public CacheConfigurationException failedWritingGlobalState(@Cause IOException var1, File var2);

    @Message(value="The state file %s is not writable. Aborting.", id=388)
    public CacheConfigurationException nonWritableStateFile(File var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Loaded global state, version=%s timestamp=%s", id=389)
    public void globalStateLoad(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Persisted state, version=%s timestamp=%s", id=390)
    public void globalStateWrite(String var1, String var2);

    @Message(value="Recovery not supported with non transactional cache", id=391)
    public CacheConfigurationException recoveryNotSupportedWithNonTxCache();

    @Message(value="Recovery not supported with Synchronization", id=392)
    public CacheConfigurationException recoveryNotSupportedWithSynchronization();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Transaction notifications are disabled.  This prevents cluster listeners from working properly!", id=395)
    public void transactionNotificationsDisabled();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Received unsolicited state from node %s for segment %d of cache %s", id=396)
    public void ignoringUnsolicitedState(Address var1, int var2, String var3);

    @Message(value="CH Factory '%s' cannot restore a persisted CH of class '%s'", id=398)
    public IllegalStateException persistentConsistentHashMismatch(String var1, String var2);

    @Message(value="Timeout while waiting for %d members in cluster. Last view had %s", id=399)
    public TimeoutException timeoutWaitingForInitialNodes(int var1, List<?> var2);

    @Message(value="Node %s was suspected", id=400)
    @Description(value="A node in the cluster is offline or cannot be reached on the network. If you are using cross-site replication this message indicates that the relay nodes are not reachable. Check network settings for all nodes in the cluster.")
    public SuspectException remoteNodeSuspected(Address var1);

    @Message(value="Node %s timed out, time : %s %s", id=401)
    public TimeoutException remoteNodeTimedOut(Address var1, long var2, TimeUnit var4);

    @Message(value="Timeout waiting for view %d. Current view is %d, current status is %s", id=402)
    public TimeoutException coordinatorTimeoutWaitingForView(int var1, int var2, Object var3);

    @Message(value="No indexable classes were defined for this indexed cache. The configuration must contain classes or protobuf message types annotated with '@Indexed'", id=403)
    public CacheConfigurationException noIndexableClassesDefined();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Caught exception while invoking a cache manager listener!", id=405)
    public void failedInvokingCacheManagerListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The replication queue is no longer supported since version 9.0. Attribute %s on line %d will be ignored.", id=406)
    public void ignoredReplicationQueueAttribute(String var1, int var2);

    @Message(value="Extraneous members %s are attempting to join cache %s, as they were not members of the persisted state", id=407)
    public CacheJoinException extraneousMembersJoinRestoredCache(List<Address> var1, String var2);

    @Message(value="Node %s with persistent state attempting to join cache %s on cluster without state", id=408)
    public CacheJoinException nodeWithPersistentStateJoiningClusterWithoutState(Address var1, String var2);

    @Message(value="Node %s without persistent state attempting to join cache %s on cluster with state", id=409)
    public CacheJoinException nodeWithoutPersistentStateJoiningCacheWithState(Address var1, String var2);

    @Message(value="Node %s attempting to join cache %s with incompatible state", id=410)
    public CacheJoinException nodeWithIncompatibleStateJoiningCache(Address var1, String var2);

    @Message(value="Cannot determine a synthetic transaction configuration from mode=%s, xaEnabled=%s, recoveryEnabled=%s, batchingEnabled=%s", id=412)
    public CacheConfigurationException unknownTransactionConfiguration(TransactionMode var1, boolean var2, boolean var3, boolean var4);

    @Message(value="Unable to instantiate serializer for %s", id=413)
    public CacheConfigurationException unableToInstantiateSerializer(Class<?> var1);

    @Message(value="Global security authorization should be enabled if cache authorization enabled.", id=414)
    public CacheConfigurationException globalSecurityAuthShouldBeEnabled();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The %s is no longer supported since version %s. Attribute %s on line %d will be ignored.", id=415)
    public void ignoredAttribute(String var1, String var2, String var3, int var4);

    @Message(value="It is not possible for a store to be transactional in a non-transactional cache. ", id=417)
    public CacheConfigurationException transactionalStoreInNonTransactionalCache();

    @Message(value="It is not possible for a store to be transactional when passivation is enabled. ", id=418)
    public CacheConfigurationException transactionalStoreInPassivatedCache();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Eviction of an entry invoked without an explicit eviction strategy for cache %s", id=419)
    public void evictionDisabled(String var1);

    @Message(value="Cannot enable '%s' in invalidation caches!", id=420)
    public CacheConfigurationException attributeNotAllowedInInvalidationMode(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while handling view %s", id=421)
    public void viewHandlingError(int var1, @Cause Throwable var2);

    @Message(value="Failed waiting for topology %d", id=422)
    public TimeoutException failedWaitingForTopology(int var1);

    @Message(value="Duplicate id found! AdvancedExternalizer id=%d is shared by another externalizer (%s)", id=423)
    public CacheConfigurationException duplicateExternalizerIdFound(int var1, String var2);

    @Message(value="Memory eviction is enabled, please specify a maximum size or count greater than zero", id=424)
    public CacheConfigurationException invalidEvictionSize();

    @Message(value="Timeout after %s waiting for acks (%s). Id=%s, Topology Id=%s", id=427)
    public TimeoutException timeoutWaitingForAcks(String var1, String var2, long var3, int var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="'%1$s' at %3$s has been deprecated. Please use '%2$s' instead", id=428)
    public void configDeprecatedUseOther(Enum<?> var1, Enum<?> var2, Location var3);

    @Message(value="On key %s previous read version (%s) is different from currently read version (%s)", id=429)
    public WriteSkewException writeSkewOnRead(@Param Object var1, Object var2, EntryVersion var3, EntryVersion var4);

    @Message(value="%s cannot be shared", id=430)
    public CacheConfigurationException nonSharedStoreConfiguredAsShared(String var1);

    @Message(value="Missing configuration for default cache '%s' declared on container", id=432)
    public CacheConfigurationException missingDefaultCacheDeclaration(String var1);

    @Message(value="A default cache has been requested, but no cache has been set as default for this container", id=433)
    public CacheConfigurationException noDefaultCache();

    @Message(value="Cache manager initialized with a default cache configuration but without a name for it. Set it in the GlobalConfiguration.", id=435)
    public CacheConfigurationException defaultCacheConfigurationWithoutName();

    @Message(value="Cache '%s' has been requested, but no matching cache configuration exists", id=436)
    public CacheConfigurationException noSuchCacheConfiguration(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to validate '%s' with the implementing store as the @ConfigurationFor annotation is missing", id=437)
    public void warnConfigurationForAnnotationMissing(String var1);

    @Message(value="Cache with name '%s' is defined more than once!", id=438)
    public CacheConfigurationException duplicateCacheName(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Received new cross-site view: %s", id=439)
    @Description(value="A cluster has either joined or left the global cluster view.")
    public void receivedXSiteClusterView(Collection<String> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error sending response for request %d@%s, command %s", id=440)
    public void errorSendingResponse(long var1, org.jgroups.Address var3, Object var4);

    @Message(value="Unsupported async cache mode '%s' for transactional caches", id=441)
    public CacheConfigurationException unsupportedAsyncCacheMode(CacheMode var1);

    @Message(value="Invalid cache loader configuration for '%s'. In order for a cache loader to be transactional, it must also be shared.", id=443)
    public CacheConfigurationException clusteredTransactionalStoreMustBeShared(String var1);

    @Message(value="Invalid cache loader configuration for '%s'. A cache loader cannot be both Asynchronous and transactional.", id=444)
    public CacheConfigurationException transactionalStoreCannotBeAsync(String var1);

    @Message(value="Multiple sites have the same name '%s'. This configuration is not valid.", id=446)
    @Description(value="The name for each cluster that participates in cross-site replication must have a unique site name. Modify JGroups RELAY2 configuration and specify a unique site name for each backup location.")
    public CacheConfigurationException multipleSitesWithSameName(String var1);

    @Message(value="'awaitInitialTransfer' can be enabled only if cache mode is distributed or replicated.", id=448)
    public CacheConfigurationException awaitInitialTransferOnlyForDistOrRepl();

    @Message(value="Timeout value for cross-site replication state transfer must be equal to or greater than one.", id=449)
    @Description(value="The value of the timeout attribute is zero or a negative number. Specify a value of at least one for the timeout attribute in the cross-site state transfer configuration for your cache.")
    public CacheConfigurationException invalidXSiteStateTransferTimeout();

    @Message(value="Wait time between retries for cross-site replication state transfer must be equal to or greater than one.", id=450)
    @Description(value="The value of the wait-time attribute is zero or a negative number. Specify a value of at least one for the wait-time attribute in the cross-site state transfer configuration for your cache.")
    public CacheConfigurationException invalidXSiteStateTransferWaitTime();

    @Message(value="Timed out waiting for view %d, current view is %d", id=451)
    public TimeoutException timeoutWaitingForView(int var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to update topology for cache %s", id=452)
    public void topologyUpdateError(String var1, @Cause Throwable var2);

    @Message(value="Attempt to define configuration for cache %s which already exists", id=453)
    public CacheConfigurationException configAlreadyDefined(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failure during leaver transactions cleanup", id=455)
    public void transactionCleanupError(@Cause Throwable var1);

    @Message(value="Class %s should be a subclass of %s", id=461)
    public CacheException invalidEncodingClass(Class<?> var1, Class<?> var2);

    @Message(value="ConflictManager.getConflicts() already in progress", id=462)
    public IllegalStateException getConflictsAlreadyInProgress();

    @Message(value="Unable to retrieve conflicts as StateTransfer is currently in progress for cache '%s'", id=463)
    public IllegalStateException getConflictsStateTransferInProgress(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The partition handling 'enabled' attribute has been deprecated. Please update your configuration to use 'when-split' instead", id=464)
    public void partitionHandlingConfigurationEnabledDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception encountered when trying to resolve conflict on Keys '%s': %s", id=466)
    public void exceptionDuringConflictResolution(Object var1, Throwable var2);

    @Message(value="Cache manager is stopping", id=472)
    public IllegalLifecycleStateException cacheManagerIsStopping();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Invalid message type %s received from %s", id=473)
    public void invalidMessageType(int var1, org.jgroups.Address var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error processing request %d@%s", id=474)
    public void errorProcessingRequest(long var1, org.jgroups.Address var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error processing response for request %d from %s", id=475)
    public void errorProcessingResponse(long var1, org.jgroups.Address var3, @Cause Throwable var4);

    @Message(value="Timed out waiting for responses for request %d from %s after %s", id=476)
    public TimeoutException requestTimedOut(long var1, String var3, String var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Cannot perform operation %s for site %s", id=477)
    @Description(value="It was not possible to successfully complete an operation on a backup location. Set logging levels to TRACE to analyze and troubleshoot the issue.")
    public void xsiteAdminOperationError(String var1, String var2, @Cause Throwable var3);

    @Message(value="Couldn't find a local transaction corresponding to remote site transaction %s", id=478)
    public CacheException unableToFindRemoteSiteTransaction(GlobalTransaction var1);

    @Message(value="LocalTransaction not found but present in the tx table for remote site transaction %s", id=479)
    public IllegalStateException unableToFindLocalTransactionFromRemoteSiteTransaction(GlobalTransaction var1);

    @Message(value="Cannot create remote transaction %s, the originator is not in the cluster view", id=481)
    public CacheException remoteTransactionOriginatorNotInView(GlobalTransaction var1);

    @Message(value="Cannot create remote transaction %s, already completed", id=482)
    public CacheException remoteTransactionAlreadyCompleted(GlobalTransaction var1);

    @Message(value="Wildcards not allowed in cache names: '%s'", id=484)
    public CacheConfigurationException wildcardsNotAllowedInCacheNames(String var1);

    @Message(value="Configuration '%s' matches multiple wildcard templates", id=485)
    public CacheConfigurationException configurationNameMatchesMultipleWildcards(String var1);

    @Message(value="Cannot register Wrapper: duplicate Id %d", id=486)
    public EncodingException duplicateIdWrapper(byte var1);

    @Message(value="Wrapper with class '%s' not found", id=487)
    public EncodingException wrapperClassNotFound(Class<?> var1);

    @Message(value="Wrapper with Id %d not found", id=488)
    public EncodingException wrapperIdNotFound(byte var1);

    @Message(value="Cannot register Encoder: duplicate Id %d", id=489)
    public EncodingException duplicateIdEncoder(short var1);

    @Message(value="Encoder with class '%s' not found", id=490)
    public EncodingException encoderClassNotFound(Class<?> var1);

    @Message(value="Encoder with Id %d not found", id=491)
    public EncodingException encoderIdNotFound(short var1);

    @Message(value="Cannot find transcoder between '%s' to '%s'", id=492)
    public EncodingException cannotFindTranscoder(MediaType var1, MediaType var2);

    @Message(value="%s encountered error transcoding content", id=495)
    public EncodingException errorTranscoding(String var1, @Cause Throwable var2);

    @Message(value="%s encountered unsupported content '%s' during transcoding", id=497)
    public EncodingException unsupportedContent(String var1, Object var2);

    @Message(value="Could not serialize the configuration of cache '%s' (%s)", id=499)
    public CacheConfigurationException configurationSerializationFailed(String var1, Configuration var2, @Cause Exception var3);

    @Message(value="Cannot create clustered configuration for cache '%s' because configuration %n%s%n is incompatible with the existing configuration %n%s", id=500)
    public CacheConfigurationException incompatibleClusterConfiguration(String var1, Configuration var2, Configuration var3);

    @Message(value="Cannot persist cache configuration as global state is disabled", id=501)
    public CacheConfigurationException globalStateDisabled();

    @Message(value="Error while persisting global configuration state", id=502)
    public CacheConfigurationException errorPersistingGlobalConfiguration(@Cause Throwable var1);

    @Message(value="Size (bytes) based eviction needs either off-heap or a binary compatible storage configured in the cache encoding", id=504)
    public CacheConfigurationException offHeapMemoryEvictionNotSupportedWithObject();

    @Message(value="Cache %s already exists", id=507)
    public CacheConfigurationException cacheExists(String var1);

    @Message(value="Cannot rename file %s to %s", id=508)
    public CacheConfigurationException cannotRenamePersistentFile(String var1, File var2, @Cause Throwable var3);

    @Message(value="Unable to add a 'null' EntryMergePolicyFactory", id=509)
    public IllegalArgumentException unableToAddNullEntryMergePolicyFactory();

    @Message(value="ConfigurationStrategy set to CUSTOM, but none specified", id=510)
    public CacheConfigurationException customStorageStrategyNotSet();

    @Message(value="ConfigurationStrategy cannot be set to MANAGED in embedded mode", id=511)
    public CacheConfigurationException managerConfigurationStorageUnavailable();

    @Message(value="Cannot acquire lock '%s' for persistent global state", id=512)
    public CacheConfigurationException globalStateCannotAcquireLockFile(@Cause Throwable var1, FileSystemLock var2);

    @Message(value="Exception based eviction requires a transactional cache that doesn't allow for 1 phase commit or synchronizations", id=513)
    public CacheConfigurationException exceptionBasedEvictionOnlySupportedInTransactionalCaches();

    @Message(value="Container eviction limit %d reached, write operation(s) is blocked", id=514)
    public ContainerFullException containerFull(long var1);

    @Message(value="The configuration is immutable", id=515)
    public UnsupportedOperationException immutableConfiguration();

    @Message(value="The state file for '%s' is invalid. Startup halted to prevent further corruption of persistent state", id=516)
    public CacheConfigurationException invalidPersistentState(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring cache topology from %s during merge: %s", id=517)
    public void ignoringCacheTopology(Collection<Address> var1, CacheTopology var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Updating topology for cache %s, topology %s, availability mode %s", id=518)
    public void updatingTopology(String var1, CacheTopology var2, AvailabilityMode var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Updating stable topology for cache %s, topology %s", id=519)
    public void updatingStableTopology(String var1, CacheTopology var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Updating availability mode for cache %s from %s to %s, topology %s", id=520)
    public void updatingAvailabilityMode(String var1, AvailabilityMode var2, AvailabilityMode var3, CacheTopology var4);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Cache %s recovered after merge with topology = %s, availability mode %s", id=521)
    public void cacheRecoveredAfterMerge(String var1, CacheTopology var2, AvailabilityMode var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Conflict resolution starting for cache %s with topology %s", id=522)
    public void startingConflictResolution(String var1, CacheTopology var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Conflict resolution finished for cache %s with topology %s", id=523)
    public void finishedConflictResolution(String var1, CacheTopology var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Conflict resolution failed for cache %s with topology %s", id=524)
    public void failedConflictResolution(String var1, CacheTopology var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Conflict resolution cancelled for cache %s with topology %s", id=525)
    public void cancelledConflictResolution(String var1, CacheTopology var2);

    @Message(value="Maximum startup attempts exceeded for store %s", id=527)
    public PersistenceException storeStartupAttemptsExceeded(String var1, @Cause Throwable var2);

    @Message(value="Cannot acquire lock %s as this partition is DEGRADED", id=528)
    public AvailabilityException degradedModeLockUnavailable(Object var1);

    @Message(value="Class '%s' blocked by deserialization allow list. Include the class name in the server allow list to authorize.", id=529)
    public CacheException errorDeserializing(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unsupported async cache mode '%s' for transactional caches, forcing %s", id=530)
    public void unsupportedAsyncCacheMode(CacheMode var1, CacheMode var2);

    @Message(value="Store or loader %s must implement SegmentedLoadWriteStore or its config must extend AbstractSegmentedStoreConfiguration if configured as segmented", id=531)
    public CacheConfigurationException storeNotSegmented(Class<?> var1);

    @Message(value="Invalid cache loader configuration for '%s'.  If a cache loader is configured with passivation, the cache loader cannot be shared in a cluster!", id=532)
    public CacheConfigurationException passivationStoreCannotBeShared(String var1);

    @Message(value="Content '%s (MediaType: '%s') cannot be converted to '%s'", id=533)
    public EncodingException cannotConvertContent(Object var1, MediaType var2, MediaType var3, @Cause Throwable var4);

    @Message(value="Grouping requires OBJECT storage type but was: %s", id=534)
    public CacheConfigurationException groupingOnlyCompatibleWithObjectStorage(StorageType var1);

    @Message(value="Grouping requires application/x-java-object storage type but was: {key=%s, value=%s}", id=535)
    public CacheConfigurationException groupingOnlyCompatibleWithObjectStorage(MediaType var1, MediaType var2);

    @Message(value="Factory doesn't know how to construct component %s", id=537)
    public CacheConfigurationException factoryCannotConstructComponent(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error stopping module %s", id=538)
    public void moduleStopError(String var1, @Cause Throwable var2);

    @Message(value="Duplicate JGroups stack '%s'", id=539)
    public CacheConfigurationException duplicateJGroupsStack(String var1);

    @Message(value="No such JGroups stack '%s'", id=540)
    public CacheConfigurationException missingJGroupsStack(String var1);

    @Message(value="Error while trying to create a channel using the specified configuration '%s'", id=541)
    public CacheConfigurationException errorCreatingChannelFromConfigurator(String var1, @Cause Throwable var2);

    @Message(value="Invalid parser scope. Expected '%s' but was '%s'", id=542)
    public CacheConfigurationException invalidScope(String var1, String var2);

    @Message(value="Cannot use stack.position when stack.combine is '%s'", id=543)
    public CacheConfigurationException jgroupsNoStackPosition(String var1);

    @Message(value="The protocol '%s' does not exist in the base stack for operation '%s'", id=544)
    public CacheConfigurationException jgroupsNoSuchProtocol(String var1, String var2);

    @Message(value="Inserting protocol '%s' in a JGroups stack requires the 'stack.position' attribute", id=545)
    public CacheConfigurationException jgroupsInsertRequiresPosition(String var1);

    @Message(value="Duplicate remote site '%s' in stack '%s'", id=546)
    @Description(value="The name for each cluster that participates in cross-site replication must have a unique site name. Modify JGroups RELAY2 configuration and specify a unique site name for each backup location.")
    public CacheConfigurationException duplicateRemoteSite(String var1, String var2);

    @Message(value="JGroups stack '%s' declares remote sites but does not include the RELAY2 protocol.", id=547)
    @Description(value="Cross-site replication requires the JGroups RELAY2 protocol. Modify the JGroups configuration to include a RELAY2 stack.")
    public CacheConfigurationException jgroupsRemoteSitesWithoutRelay(String var1);

    @Message(value="JGroups stack '%s' has a RELAY2 protocol without remote sites.", id=548)
    @Description(value="Each cluster that participates in cross-site replication must be identified with a site name in the RELAY2 stack. Modify JGroups configuration and specify a unique site name for each backup location.")
    public CacheConfigurationException jgroupsRelayWithoutRemoteSites(String var1);

    @Message(value="A store cannot be shared when utilised with a local cache.", id=549)
    public CacheConfigurationException sharedStoreWithLocalCache();

    @Message(value="Invalidation mode only supports when-split=ALLOW_READ_WRITES", id=550)
    public CacheConfigurationException invalidationPartitionHandlingNotSuported();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The custom interceptors configuration has been deprecated and are ignored", id=551)
    public void customInterceptorsIgnored();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring 'marshaller' attribute. Common marshallers are already available at runtime, and to deploy a custom marshaller, consult the 'Encoding' section in the user guide", id=553)
    public void marshallersNotSupported();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Starting user marshaller '%s'", id=556)
    public void startingUserMarshaller(String var1);

    @Message(value="Unable to configure JGroups Stack '%s'", id=557)
    public CacheConfigurationException unableToAddJGroupsStack(String var1, @Cause Exception var2);

    @Message(value="The store location '%s' is not a child of the global persistent location '%s'", id=558)
    public CacheConfigurationException forbiddenStoreLocation(Path var1, Path var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cannot marshall '%s'", id=559)
    public void cannotMarshall(Class<?> var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The AdvancedExternalizer configuration has been deprecated and will be removed in the future", id=560)
    public void advancedExternalizerDeprecated();

    @Message(value="Chunk size must be positive, got %d", id=561)
    public CacheConfigurationException invalidChunkSize(int var1);

    @Message(value="Invalid cache loader configuration for '%s'.  If a cache loader is configured with purgeOnStartup, the cache loader cannot be shared in a cluster!", id=562)
    public CacheConfigurationException sharedStoreShouldNotBePurged(String var1);

    @Message(value="Invalid cache loader configuration for '%s'.  This implementation does not support being segmented!", id=563)
    public CacheConfigurationException storeDoesNotSupportBeingSegmented(String var1);

    @Message(value="Thread Pool Factory %s is blocking, but pool %s requires non blocking threads", id=566)
    public CacheConfigurationException threadPoolFactoryIsBlocking(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to persist Infinispan internal caches as no global state enabled", id=569)
    @Once
    public void warnUnableToPersistInternalCaches();

    @Message(value="Unexpected response from %s: %s", id=570)
    public IllegalArgumentException unexpectedResponse(Address var1, Response var2);

    @Message(value="RELAY2 not found in the protocol stack. Cannot perform cross-site operations.", id=571)
    @Description(value="To back up caches from one site to another the cluster transport uses the JGroups RELAY2 protocol. Add RELAY2 to your cluster transport configuration.")
    public CacheConfigurationException crossSiteUnavailable();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="index mode attribute is deprecated and should no longer be specified because its value is automatically detected. Most previously supported values are no longer supported. Please check the upgrade guide.", id=572)
    public void indexModeDeprecated();

    @Message(value="Cannot recreate persisted configuration for cache '%s' because configuration %n%s%n is incompatible with the existing configuration %n%s", id=573)
    public CacheConfigurationException incompatiblePersistedConfiguration(String var1, Configuration var2, Configuration var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Global state cannot persisted because it is incomplete (usually caused by errors at startup).", id=574)
    public void incompleteGlobalState();

    @Message(value="PartitionStrategy must be ALLOW_READ_WRITES when numOwners is 1", id=575)
    public CacheConfigurationException singleOwnerNotSetToAllowReadWrites();

    @Message(value="Cross-site replication not available for local cache.", id=576)
    @Description(value="Cross-site replication capabilities do not apply to local cache mode. Either remove the backup configuration from the local cache or use a distributed or replicated cache mode.")
    public CacheConfigurationException xsiteInLocalCache();

    @Message(value="Converting from unwrapped protostream payload requires the 'type' parameter to be supplied in the destination MediaType", id=577)
    public MarshallingException missingTypeForUnwrappedPayload();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Migrating '%s' persisted data to new format...", id=578)
    public void startMigratingPersistenceData(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="'%s' persisted data successfully migrated.", id=579)
    public void persistedDataSuccessfulMigrated(String var1);

    @Message(value="Failed to migrate '%s' persisted data.", id=580)
    public PersistenceException persistedDataMigrationFailed(String var1, @Cause Throwable var2);

    @Message(value="Cannot configure both maxCount and maxSize in memory configuration", id=583)
    public CacheConfigurationException cannotProvideBothSizeAndCount();

    @Message(value="The memory attribute(s) %s have been deprecated and cannot be used in conjunction with the new configuration", id=584)
    public CacheConfigurationException cannotUseDeprecatedAndReplacement(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Single media-type was specified for keys and values, ignoring individual configurations", id=585)
    public void ignoringSpecificMediaTypes();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The memory configuration element '%s' has been deprecated. Please update your configuration", id=586)
    public void warnUsingDeprecatedMemoryConfigs(String var1);

    @Message(value="Cannot change max-size since max-count is already defined", id=587)
    public CacheConfigurationException cannotChangeMaxSize();

    @Message(value="Cannot change max-count since max-size is already defined", id=588)
    public CacheConfigurationException cannotChangeMaxCount();

    @Message(value="A store cannot be configured with both preload and purgeOnStartup", id=589)
    public CacheConfigurationException preloadAndPurgeOnStartupConflict();

    @Message(value="Store cannot be configured with both read and write only!", id=590)
    public CacheConfigurationException storeBothReadAndWriteOnly();

    @Message(value="Store cannot be configured with purgeOnStartup, shared or passivation if it is read only!", id=591)
    public CacheConfigurationException storeReadOnlyExceptions();

    @Message(value="Store cannot be configured with fetchPersistenceState or preload if it is write only!", id=592)
    public CacheConfigurationException storeWriteOnlyExceptions();

    @Message(value="Store %s cannot be configured to be %s as the implementation specifies it is already %s!", id=593)
    public CacheConfigurationException storeConfiguredHasBothReadAndWriteOnly(String var1, NonBlockingStore.Characteristic var2, NonBlockingStore.Characteristic var3);

    @Message(value="At most one store can be set to 'preload'!", id=594)
    public CacheConfigurationException onlyOnePreloadStoreAllowed();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="ClusterLoader has been deprecated and will be removed in a future version with no direct replacement", id=595)
    public void warnUsingDeprecatedClusterLoader();

    @Message(value="Store %s cannot be configured to be transactional as it does not contain the TRANSACTIONAL characteristic", id=597)
    public CacheConfigurationException storeConfiguredTransactionalButCharacteristicNotPresent(String var1);

    @Message(value="Store must specify a location when global state is disabled", id=598)
    public CacheConfigurationException storeLocationRequired();

    @Message(value="Store '%s' must specify the '%s' attribute when global state is disabled", id=598)
    public CacheConfigurationException storeLocationRequired(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Configuration for cache '%s' does not define the encoding for keys or values. If you use operations that require data conversion or queries, you should configure the cache with a specific MediaType for keys or values.", id=599)
    public void unknownEncoding(String var1);

    @Message(value="Store %s cannot be configured to be shared as it does not contain the SHARED characteristic", id=600)
    public CacheConfigurationException storeConfiguredSharedButCharacteristicNotPresent(String var1);

    @Message(value="Store %s cannot be configured to be segmented as it does not contain the SEGMENTABLE characteristic", id=601)
    public CacheConfigurationException storeConfiguredSegmentedButCharacteristicNotPresent(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Conversions between JSON and Java Objects are deprecated and will be removed in a future version. To read/write values as JSON, it is recommended to define a protobuf schema and store data in the cache using 'application/x-protostream' as MediaType", id=602)
    public void jsonObjectConversionDeprecated();

    @Message(value="Cannot handle cross-site request from site '%s'. Cache '%s' not found.", id=603)
    @Description(value="A remote cluster attempted to replicate data to a cache that does not exist on the local cluster. Either create the cache or modify the backup configuration for the cache on the remote site.")
    public CacheConfigurationException xsiteCacheNotFound(String var1, ByteString var2);

    @Message(value="Cannot handle cross-site request from site '%s'. Cache '%s' is stopped.", id=604)
    @Description(value="A remote cluster attempted to replicate data to a cache that is not available. Start, or restart, the cache.")
    public CrossSiteIllegalLifecycleStateException xsiteCacheNotStarted(String var1, ByteString var2);

    @Message(value="Cannot handle cross-site request from site '%s'. Cache '%s' is not clustered.", id=605)
    @Description(value="A remote cluster attempted to replicate data to a local cache. Either recreate the cache with a distributed or replicated mode or remove the backup configuration.")
    public CacheConfigurationException xsiteInLocalCache(String var1, ByteString var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Remote site '%s' has an invalid cache configuration. Taking the backup location offline.", id=606)
    @Description(value="An attempt was made to replicate data to a cache that does not have a valid configuration. Check the cache at the remote site and recreate it with a valid distributed or replicated configuration.")
    public void xsiteInvalidConfigurationRemoteSite(String var1, @Cause CacheConfigurationException var2);

    @Message(value="The XSiteEntryMergePolicy is missing. The cache configuration must include a merge policy.", id=607)
    @Description(value="To resolve conflicting entries between backup locations cache configuration must include a merge policy. Recreate the cache and specify a merge policy from the org.infinispan.xsite.spi.XSiteMergePolicy enum or use a conflict resolution algorithm.")
    public CacheConfigurationException missingXSiteEntryMergePolicy();

    @LogMessage(level=Logger.Level.FATAL)
    @Message(value="[IRAC] Unexpected error occurred.", id=608)
    @Description(value="During conflict resolution for cross-site replication an unexpected error occurred. To ensure data consistency between backup locations you should initiate state transfer to synchronize data between clusters.")
    public void unexpectedErrorFromIrac(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Cannot obtain cache '%s' as it is in FAILED state. Please check the configuration", id=609)
    public void cannotObtainFailedCache(String var1, @Cause Throwable var2);

    @Message(value="Cache configuration must not declare indexed entities if it is not indexed", id=610)
    public CacheConfigurationException indexableClassesDefined();

    @Message(value="Invalid index storage", id=611)
    public CacheConfigurationException invalidIndexStorage();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Indexing configuration using properties has been deprecated and will be removed in a future version, please use the <index-writer> and <index-reader> elements to configure indexing behavior.", id=613)
    @Once
    public void deprecatedIndexProperties();

    @Message(value="It is not allowed to have different indexing configuration for each indexed type in a cache.", id=614)
    public CacheConfigurationException foundDifferentIndexConfigPerType();

    @Message(value="Unable to unmarshall '%s' as a marshaller is not present in the user or global SerializationContext", id=615)
    public MarshallingException marshallerMissingFromUserAndGlobalContext(String var1);

    @Message(value="Unsupported persisted data version: %s", id=616)
    public PersistenceException persistedDataMigrationUnsupportedVersion(String var1);

    @Message(value="Site '%s' not found.", id=617)
    @Description(value="A backup location that is configured as a site in the JGroups RELAY2 stack is not available. Check the JGroups configuration and cache configuration to ensure that the remote site is configured correctly. If the configuration is correct then check that the backup location is online.")
    public IllegalArgumentException siteNotFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cleanup failed for cross-site state transfer. Invoke the cancel-push-state(%s) command if any nodes indicate pending operations to push state.", id=618)
    @Description(value="When cross-site state transfer operations complete or fail due to a network timeout or other exception, the coordinator node sends a cancel-push-state command to other nodes. If any nodes indicate that there are pending operations to push state to a remote site, you can invoke the cancel-push-state command again on those nodes.")
    public void xsiteCancelSendFailed(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cleanup failed for cross-site state transfer. Invoke the cancel-receive(%s) command in site %s if any nodes indicate pending operations to receive state.", id=619)
    @Description(value="When cross-site state transfer operations complete or fail due to a network timeout or other exception, the coordinator node sends a cancel-receive command to nodes. If any nodes indicate that there are pending operations to receive state from a remote site, you can invoke the cancel-receive command again.")
    public void xsiteCancelReceiveFailed(@Cause Throwable var1, String var2, String var3);

    @Message(value="Cross-site state transfer to '%s' already started", id=620)
    @Description(value="An attempt was made to initiate cross-site state transfer while the operation was already in progress. Wait for the state transfer operation to complete before initiating a subsequent operation. Alternatively you can cancel the cross-site state transfer operation that is in progress.")
    public CacheException xsiteStateTransferAlreadyInProgress(String var1);

    @Message(value="Element '%1$s' has been removed at %3$s. Please use element '%2$s' instead", id=621)
    public CacheConfigurationException elementRemovedUseOther(String var1, String var2, Location var3);

    @Message(value="Element '%s' at %s has been removed with no replacement", id=622)
    public CacheConfigurationException elementRemoved(String var1, Location var2);

    @Message(value="Attribute '%1$s' has been removed at %3$s. Please use attribute '%2$s' instead", id=623)
    public CacheConfigurationException attributeRemovedUseOther(String var1, String var2, Location var3);

    @Message(value="Attribute '%s' at %s has been removed with no replacement", id=624)
    public CacheConfigurationException attributeRemoved(String var1, Location var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Index path not provided and global state disabled, will use the current working directory for storage.", id=625)
    public void indexLocationWorkingDir();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Index path '%s' is not absolute and global state is disabled, will use a dir relative to the current working directory.", id=626)
    public void indexRelativeWorkingDir(String var1);

    @Message(value="Invalid cache loader configuration for '%s'.  This implementation only supports being segmented!", id=627)
    public CacheConfigurationException storeRequiresBeingSegmented(String var1);

    @Message(value="Invalid cache roles '%s'", id=628)
    public CacheConfigurationException noSuchGlobalRoles(Set<String> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception completing partial completed transaction %s. Retrying later.", id=629)
    public void failedPartitionHandlingTxCompletion(GlobalTransaction var1, @Cause Throwable var2);

    @Message(value="Cross-site state transfer mode cannot be null.", id=633)
    @Description(value="The mode attribute for cross-site state transfer configuration must have a value of AUTO or MANUAL. Modify the cache configuration with a valid value for the mode attribute.")
    public CacheConfigurationException invalidXSiteStateTransferMode();

    @Message(value="Cross-site automatic state transfer is not compatible with SYNC backup strategy.", id=634)
    @Description(value="Automatic state transfer is not possible if the backup strategy for cross-site replication is synchronous. Modify the cache configuration and set the state transfer mode to MANUAL. Alternatively you can change the backup strategy to use asynchronous mode.")
    public CacheConfigurationException autoXSiteStateTransferModeNotAvailableInSync();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="[%s] Failed to receive a response from any nodes. Automatic cross-site state transfer to site '%s' is not started.", id=635)
    @Description(value="Before it starts automatic cross-site state transfer operations, the coordinator node checks all local nodes to determine if state transfer is necessary. This error occurs when the coordinator node gets an exception from one or more local nodes. Check that nodes in the cluster are online and operating as expected.")
    public void unableToStartXSiteAutStateTransfer(String var1, String var2, @Cause Throwable var3);

    @Message(value="State transfer timeout (%d) must be greater than or equal to the remote timeout (%d)", id=636)
    public CacheConfigurationException invalidStateTransferTimeout(Long var1, Long var2);

    @Message(value="Timeout waiting for topology %d, current topology is %d", id=637)
    public TimeoutException topologyTimeout(int var1, int var2);

    @Message(value="Timeout waiting for topology %d transaction data", id=638)
    public TimeoutException transactionDataTimeout(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="SingleFileStore has been deprecated and will be removed in a future version, replaced by SoftIndexFileStore", id=640)
    public void warnUsingDeprecatedSingleFileStore();

    @Message(value="The transaction %s is already rolled back", id=641)
    public InvalidTransactionException transactionAlreadyRolledBack(GlobalTransaction var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Attempting to recover possibly corrupted data file %s", id=642)
    public void startRecoveringCorruptPersistenceData(String var1);

    @Message(value="Failed to recover '%s' persisted data.", id=644)
    public PersistenceException corruptDataMigrationFailed(String var1, @Cause Throwable var2);

    @Message(value="Asynchronous cache modes, such as %s, cannot use SYNC touch mode for maximum idle expiration.", id=645)
    public CacheConfigurationException invalidTouchMode(CacheMode var1);

    @Message(value="capacityFactor must be positive", id=646)
    public IllegalArgumentException illegalCapacityFactor();

    @Message(value="The configuration for internal cache '%s' cannot be modified", id=647)
    public IllegalArgumentException cannotUpdateInternalCache(String var1);

    @Message(value="Cache '%s' is non empty, cannot add store.", id=648)
    public PersistenceException cannotAddStore(String var1);

    @Message(value="SingleFileStore does not support max-entries when segmented", id=649)
    public CacheConfigurationException segmentedSingleFileStoreDoesNotSupportMaxEntries();

    @Message(value="Read invalid data in SingleFileStore file %s, please remove the file and retry", id=650)
    public PersistenceException invalidSingleFileStoreData(String var1);

    @Message(value="Max idle is not allowed while using a store without passivation", id=651)
    public CacheConfigurationException maxIdleNotAllowedWithoutPassivation();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Max idle is not supported when using a store", id=652)
    public void maxIdleNotTestedWithPassivation();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The '%s' attribute on the '%s' element has been deprecated. Please use the '%s' attribute instead", id=653)
    public void attributeDeprecatedUseOther(Enum<?> var1, Enum<?> var2, Enum<?> var3);

    @Message(value="Problem encountered when preloading key %s!", id=654)
    public PersistenceException problemPreloadingKey(Object var1, @Cause Throwable var2);

    @Message(value="Unable to convert text content to JSON: '%s'", id=655)
    public EncodingException invalidJson(String var1);

    @Message(value="The backup '%s' configuration 'failure-policy=%s' is not valid with an ASYNC backup strategy.", id=656)
    @Description(value="Only the 'WARN' and 'IGNORE' failure policies are compatible with asynchronous backups for cross-site replication. Modify the backup configuration for the cache to change the failure policy or use the synchronous backup strategy.")
    public CacheConfigurationException invalidPolicyWithAsyncStrategy(String var1, BackupFailurePolicy var2);

    @Message(value="The backup '%s' configuration 'failure-policy-class' is not compatible with 'failure-policy=%s'. Use 'failure-policy=\"CUSTOM\"'", id=657)
    @Description(value="The backup configuration for the cache specifies the fully qualified class of a custom failure policy implementation. This is valid with the custom failure policy only. Change the cache configuration to use 'failure-policy=\"CUSTOM\"' or remove the failure policy class.")
    public CacheConfigurationException failurePolicyClassNotCompatibleWith(String var1, BackupFailurePolicy var2);

    @Message(value="Initial state transfer timed out for cache %s on %s", id=658)
    public TimeoutException initialStateTransferTimeout(String var1, Address var2);

    @Message(value="Component %s failed to start", id=659)
    public CacheConfigurationException componentFailedToStart(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="%s start failed, stopping any running components", id=660)
    public void startFailure(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="'%s' has been deprecated with no replacement.", id=661)
    public void configDeprecated(Enum<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to transfer cross-site tombstones to %s for segments %s.", id=662)
    @Description(value="Cross-site tombstones are metadata that ensure data consistency. This error indicates that it was not possible to replicate tombstones for some segments during normal operations. No action necessary.")
    public void failedToTransferTombstones(Address var1, IntSet var2, @Cause Throwable var3);

    @Message(value="Name must be less than 256 bytes, current name '%s' exceeds the size.", id=663)
    public CacheConfigurationException invalidNameSize(String var1);

    @Message(value="Invalid index startup mode: %s", id=664)
    public CacheConfigurationException invalidIndexStartUpMode(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="There was an error in submitted periodic task with %s, not rescheduling.", id=665)
    public void scheduledTaskEncounteredThrowable(Object var1, @Cause Throwable var2);

    @Message(value="Transport clusterName cannot be null.", id=666)
    public CacheConfigurationException requireNonNullClusterName();

    @Message(value="Transport node-name is not set.", id=667)
    public CacheConfigurationException requireNodeName();

    @Message(value="Transport node-name must be present in raft-members: %s", id=668)
    public CacheConfigurationException nodeNameNotInRaftMembers(String var1);

    @Message(value="FORK protocol required on JGroups channel.", id=669)
    public IllegalArgumentException forkProtocolRequired();

    @Message(value="Error creating fork channel for %s", id=670)
    @LogMessage(level=Logger.Level.ERROR)
    public void errorCreatingForkChannel(String var1, @Cause Throwable var2);

    @Message(value="RAFT protocol is not available. Reason: %s", id=671)
    @LogMessage(level=Logger.Level.WARN)
    public void raftProtocolUnavailable(String var1);

    @Message(value="RAFT protocol is available.", id=672)
    @LogMessage(level=Logger.Level.INFO)
    public void raftProtocolAvailable();

    @Message(value="Cannot persist RAFT data as global state is disabled", id=673)
    public CacheConfigurationException raftGlobalStateDisabled();

    @Message(value="There was an error when resetting the SIFS index for cache %s", id=674)
    public PersistenceException issueEncounteredResettingIndex(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Caught exception while invoking a event logger listener!", id=675)
    public void failedInvokingEventLoggerListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Store '%s'#isAvailable check threw Exception", id=676)
    public void storeIsAvailableCheckThrewException(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Store '%s'#isAvailable completed Exceptionally", id=677)
    public void storeIsAvailableCompletedExceptionally(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Persistence is unavailable because of store %s", id=678)
    public void persistenceUnavailable(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Persistence is now available", id=679)
    public void persistenceAvailable();

    @Message(value="Expiration (Max idle or Lifespan) is not allowed while using a store '%s' that does not support expiration, unless it is configured as read only", id=680)
    public CacheConfigurationException expirationNotAllowedWhenStoreDoesNotSupport(String var1);

    @Message(value="Missing required property '%s' for attribute '%s' at %s", id=681)
    public CacheConfigurationException missingRequiredProperty(String var1, String var2, Location var3);

    @Message(value="Attribute '%2$s' of element '%1$s' has an illegal value '%3$s' at %4$s: %5$s", id=686)
    public CacheConfigurationException invalidAttributeValue(String var1, String var2, String var3, Location var4, String var5);

    @Message(value="Attribute '%2$s' of element '%1$s' has an illegal value '%3$s' at %5$s. Expecting one of %4$s.", id=687)
    public CacheConfigurationException invalidAttributeEnumValue(String var1, String var2, String var3, String var4, Location var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attribute '%s' of element '%s' has been deprecated since schema version %d.%d. Refer to the upgrade guide", id=688)
    public void attributeDeprecated(String var1, String var2, int var3, int var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Recovering cache '%s' but there are missing members, known members %s of a total of %s", id=689)
    public void recoverFromStateMissingMembers(String var1, List<Address> var2, int var3);

    public MissingMembersException recoverFromStateMissingMembers(String var1, List<Address> var2, String var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="We cannot find a configuration for the cache '%s' in the available configurations: '%s'. This cache has been probably removed by another thread. Skip to writing it.", id=690)
    public void configurationNotFound(String var1, Collection<String> var2);

    @Message(value="Indexed entity name must not be null or empty", id=691)
    public CacheConfigurationException indexedEntityNameMissing();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Flushed ACL Cache", id=692)
    public void flushedACLCache();

    @Message(value="Dangling lock file '%s' in persistent global state, probably left behind by an unclean shutdown. ", id=693)
    public CacheConfigurationException globalStateLockFilePresent(FileSystemLock var1);

    @Message(value="Cache '%s' has number of owners %d but is missing too many members (%d/%d) to reinstall topology", id=694)
    public MissingMembersException missingTooManyMembers(String var1, int var2, int var3, int var4);

    @Message(value="Query module not found. Add infinispan-query or infinispan-query-core to the classpath.", id=695)
    public CacheException queryNotSupported();

    @Message(value="Simple caches do not support queries. Use standard caches for querying.", id=969)
    public CacheException querySimpleCacheNotSupported();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to register metrics with id %s. Reason: %s", id=970)
    public void metricRegistrationFailed(String var1, String var2);

    @Message(value="Cannot handle cross-site request from site '%s'. CacheManager isn't started yet.", id=971)
    public CrossSiteIllegalLifecycleStateException xsiteCacheManagerDoesNotAllowInvocations(String var1);

    @Message(value="Tracing collector endpoint '%s' is not valid.", id=972)
    public CacheConfigurationException invalidTracingCollectorEndpoint(String var1, @Cause Throwable var2);

    @Message(value="Cannot use id %d for commands, as it is already in use by %s", id=973)
    public IllegalArgumentException commandIdAlreadyInUse(byte var1, String var2);

    @Message(value="Security container cannot be enabled/disabled at cache level, since it is configured globally.", id=974)
    public CacheConfigurationException securityCacheTracing();

    @Message(value="The alias '%s' is already being used by cache '%s'", id=975)
    public CacheConfigurationException duplicateAliasName(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Received new cross-site event, site(s) %s: %s", id=976)
    @Description(value="A cluster has either joined or left the global cluster view.")
    public void crossSiteViewEvent(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to initialize cache: '%s'", id=708)
    public void failedToInitializeCache(String var1, @Cause Throwable var2);

    @Message(value="Failed to backup cache `%s` to one or more remote sites: %s", id=709)
    public String failedToBackupData(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to initialize global registry", id=710)
    public void failedToInitializeGlobalRegistry(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="View event rejected. The installed view id '%s' is newer than the received view: %s", id=711)
    public void rejectOutdatedView(int var1, String var2);
}

