/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.HashMap;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.representations.AccessToken;

public class NonceBackwardsCompatibleMapper
implements OIDCAccessTokenMapper,
ProtocolMapper {
    public static final String PROVIDER_ID = "oidc-nonce-backwards-compatible-mapper";

    public String getProtocol() {
        return "openid-connect";
    }

    public void close() {
    }

    public final ProtocolMapper create(KeycloakSession session) {
        return new NonceBackwardsCompatibleMapper();
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Nonce backwards compatible";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Adds the nonce claim to Access, Refresh and ID token";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().build();
    }

    @Override
    public AccessToken transformAccessToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        token.setNonce((String)clientSessionCtx.getAttribute("nonce", String.class));
        return token;
    }

    public static ProtocolMapperModel create(String name) {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(PROVIDER_ID);
        mapper.setProtocol("openid-connect");
        HashMap config = new HashMap();
        mapper.setConfig(config);
        return mapper;
    }
}

