/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.api;

import java.util.function.Supplier;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PosixShim;

public class API {
    public static IRubyObject sysFailWithPath(ThreadContext context, String path2) {
        throw context.runtime.newSystemCallError("bad path for cloexec: " + path2);
    }

    public static int newPipe(ThreadContext context, int[] pipes) {
        int ret = API.cloexecPipe(context, pipes);
        return ret;
    }

    public static int cloexecPipe(ThreadContext context, int[] pipes) {
        int ret = context.runtime.getPosix().pipe(pipes);
        if (ret == -1) {
            return -1;
        }
        API.fdFixCloexec(context, pipes[0]);
        API.fdFixCloexec(context, pipes[1]);
        return ret;
    }

    public static void fdFixCloexec(ThreadContext context, int fd) {
        PosixShim shim = new PosixShim(context.runtime);
        OpenFile.fdFixCloexec(shim, fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T rescueTypeError(ThreadContext context, T dflt, Supplier<T> func) {
        boolean exceptionRequiresBacktrace = context.exceptionRequiresBacktrace;
        try {
            context.setExceptionRequiresBacktrace(false);
            T t = func.get();
            return t;
        }
        catch (TypeError te) {
            T t = dflt;
            return t;
        }
        finally {
            context.setExceptionRequiresBacktrace(exceptionRequiresBacktrace);
        }
    }

    public static class ModeAndPermission {
        public IRubyObject mode;
        public IRubyObject permission;

        public ModeAndPermission(IRubyObject mode2, IRubyObject permission) {
            this.mode = mode2;
            this.permission = permission;
        }
    }
}

