/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Denoise an image using curvature driven flow.


CurvatureFlowImageFilter implements a curvature driven image denoising algorithm. Iso-
brightness contours in the grayscale input image are viewed as a level
set. The level set is then evolved using a curvature-based speed
function:

\\[ I_t = \\kappa |\\nabla I| \\] where $ \\kappa $ is the curvature.

The advantage of this approach is that sharp boundaries are preserved
with smoothing occurring only within a region. However, it should be
noted that continuous application of this scheme will result in the
eventual removal of all information as each contour shrinks to zero
and disappear.

Note that unlike level set segmentation algorithms, the image to be
denoised is already the level set and can be set directly as the input
using the SetInput() method.

This filter has two parameters: the number of update iterations to be
performed and the timestep between each update.

The timestep should be "small enough" to ensure numerical stability.
Stability is guarantee when the timestep meets the CFL (Courant-
Friedrichs-Levy) condition. Broadly speaking, this condition ensures
that each contour does not move more than one grid position at each
timestep. In the literature, the timestep is typically user specified
and have to manually tuned to the application.

This filter make use of the multi-threaded finite difference solver
hierarchy. Updates are computed using a CurvatureFlowFunction object. A zero flux Neumann boundary condition when computing
derivatives near the data boundary.

This filter may be streamed. To support streaming this filter produces
a padded output which takes into account edge effects. The size of the
padding is m_NumberOfIterations on each edge. Users of this filter
should only make use of the center valid central region.


WARNING:
This filter assumes that the input and output types have the same
dimensions. This filter also requires that the output image pixels are
of a floating point type. This filter works for any dimensional
images.
 Reference: "Level Set Methods and Fast Marching Methods", J.A.
Sethian, Cambridge Press, Chapter 16, Second edition, 1999.


See:
 DenseFiniteDifferenceImageFilter

 CurvatureFlowFunction

 MinMaxCurvatureFlowImageFilter

 BinaryMinMaxCurvatureFlowImageFilter

 itk::simple::CurvatureFlow for the procedural interface

 itk::CurvatureFlowImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCurvatureFlowImageFilter.h
*/
public class CurvatureFlowImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected CurvatureFlowImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.CurvatureFlowImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(CurvatureFlowImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(CurvatureFlowImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::CurvatureFlowImageFilter::~CurvatureFlowImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_CurvatureFlowImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::CurvatureFlowImageFilter::CurvatureFlowImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  CurvatureFlowImageFilter() {
    this(SimpleITKJNI.new_CurvatureFlowImageFilter(), true);
  }

  /**
Self&amp; itk::simple::CurvatureFlowImageFilter::SetTimeStep(double TimeStep)

Set the timestep parameter.

*/
public  void setTimeStep(double TimeStep) {
    SimpleITKJNI.CurvatureFlowImageFilter_setTimeStep(swigCPtr, this, TimeStep);
  }

  /**
double itk::simple::CurvatureFlowImageFilter::GetTimeStep() const

Get the timestep parameter.

*/
public  double getTimeStep() {
    return SimpleITKJNI.CurvatureFlowImageFilter_getTimeStep(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CurvatureFlowImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.CurvatureFlowImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::CurvatureFlowImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.CurvatureFlowImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
std::string itk::simple::CurvatureFlowImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.CurvatureFlowImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::CurvatureFlowImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.CurvatureFlowImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::CurvatureFlowImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.CurvatureFlowImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
