/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import org.jetbrains.kotlin.io.vavr.collection.ArrayType;
import org.jetbrains.kotlin.io.vavr.collection.HashSet;
import org.jetbrains.kotlin.io.vavr.collection.Iterator;
import org.jetbrains.kotlin.io.vavr.collection.LinkedHashMap;
import org.jetbrains.kotlin.io.vavr.collection.List;
import org.jetbrains.kotlin.io.vavr.collection.Map;
import org.jetbrains.kotlin.io.vavr.collection.Seq;
import org.jetbrains.kotlin.io.vavr.collection.Set;
import org.jetbrains.kotlin.io.vavr.collection.Traversable;
import org.jetbrains.kotlin.io.vavr.control.Option;

final class Collections {
    static boolean areEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        java.util.Iterator<?> iter1 = iterable1.iterator();
        java.util.Iterator<?> iter2 = iterable2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (Objects.equals(iter1.next(), iter2.next())) continue;
            return false;
        }
        return iter1.hasNext() == iter2.hasNext();
    }

    static <K, V> boolean equals(Map<K, V> source, Object object) {
        if (source == object) {
            return true;
        }
        if (source != null && object instanceof Map) {
            Map map = (Map)object;
            if (source.size() != map.size()) {
                return false;
            }
            try {
                return source.forAll(map::contains);
            }
            catch (ClassCastException e2) {
                return false;
            }
        }
        return false;
    }

    static <V> boolean equals(Seq<V> source, Object object) {
        if (object == source) {
            return true;
        }
        if (source != null && object instanceof Seq) {
            Seq seq = (Seq)object;
            return seq.size() == source.size() && Collections.areEqual(source, seq);
        }
        return false;
    }

    static <V> boolean equals(Set<V> source, Object object) {
        if (source == object) {
            return true;
        }
        if (source != null && object instanceof Set) {
            Set set = (Set)object;
            if (source.size() != set.size()) {
                return false;
            }
            try {
                return source.forAll(set::contains);
            }
            catch (ClassCastException e2) {
                return false;
            }
        }
        return false;
    }

    static <T, C, R extends Iterable<T>> Map<C, R> groupBy(Traversable<T> source, Function<? super T, ? extends C> classifier, Function<? super Iterable<T>, R> mapper) {
        Objects.requireNonNull(classifier, "classifier is null");
        Objects.requireNonNull(mapper, "mapper is null");
        Map<C, R> results = LinkedHashMap.empty();
        for (Map.Entry<C, Collection<T>> entry : Collections.groupBy(source, classifier)) {
            results = results.put(entry.getKey(), mapper.apply(entry.getValue()));
        }
        return results;
    }

    private static <T, C> java.util.Set<Map.Entry<C, Collection<T>>> groupBy(Traversable<T> source, Function<? super T, ? extends C> classifier) {
        java.util.LinkedHashMap<Object, Collection> results = new java.util.LinkedHashMap<Object, Collection>(source.isTraversableAgain() ? source.size() : 16);
        for (Object value2 : source) {
            C key = classifier.apply(value2);
            results.computeIfAbsent(key, k2 -> new ArrayList()).add(value2);
        }
        return results.entrySet();
    }

    static int hashOrdered(Iterable<?> iterable) {
        return Collections.hash(iterable, (acc, hash) -> acc * 31 + hash);
    }

    static int hashUnordered(Iterable<?> iterable) {
        return Collections.hash(iterable, (acc, hash) -> acc + hash);
    }

    private static int hash(Iterable<?> iterable, IntBinaryOperator accumulator) {
        if (iterable == null) {
            return 0;
        }
        int hashCode = 1;
        for (Object o2 : iterable) {
            hashCode = accumulator.applyAsInt(hashCode, Objects.hashCode(o2));
        }
        return hashCode;
    }

    static boolean isEmpty(Iterable<?> iterable) {
        return iterable instanceof Traversable && ((Traversable)iterable).isEmpty() || iterable instanceof Collection && ((Collection)iterable).isEmpty() || !iterable.iterator().hasNext();
    }

    static <T> boolean isTraversableAgain(Iterable<? extends T> iterable) {
        return iterable instanceof Collection || iterable instanceof Traversable && ((Traversable)iterable).isTraversableAgain();
    }

    static <T> T last(Traversable<T> source) {
        if (source.isEmpty()) {
            throw new NoSuchElementException("last of empty " + source.stringPrefix());
        }
        java.util.Iterator it = source.iterator();
        T result2 = null;
        while (it.hasNext()) {
            result2 = (T)it.next();
        }
        return result2;
    }

    static <K, V, K2, U extends Map<K2, V>> U mapKeys(Map<K, V> source, U zero, Function<? super K, ? extends K2> keyMapper, BiFunction<? super V, ? super V, ? extends V> valueMerge) {
        Objects.requireNonNull(zero, "zero is null");
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        Objects.requireNonNull(valueMerge, "valueMerge is null");
        return (U)source.foldLeft(zero, (acc, entry) -> {
            Object k2 = keyMapper.apply((Object)entry._1);
            Object v2 = entry._2;
            Option v1 = acc.get(k2);
            Object v3 = v1.isDefined() ? valueMerge.apply((Object)v1.get(), (Object)v2) : v2;
            return acc.put(k2, v3);
        });
    }

    static <C extends Traversable<T>, T> C removeAll(C source, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (source.isEmpty()) {
            return source;
        }
        HashSet removed = HashSet.ofAll(elements);
        return (C)(removed.isEmpty() ? source : source.filter(e2 -> !removed.contains(e2)));
    }

    static <C extends Traversable<T>, T> C retainAll(C source, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (source.isEmpty()) {
            return source;
        }
        HashSet<? extends T> retained = HashSet.ofAll(elements);
        return (C)source.filter(retained::contains);
    }

    static <T, U, R extends Traversable<U>> R scanLeft(Traversable<? extends T> source, U zero, BiFunction<? super U, ? super T, ? extends U> operation, Function<Iterator<U>, R> finisher) {
        Objects.requireNonNull(operation, "operation is null");
        Iterator<? extends U> iterator2 = source.iterator().scanLeft(zero, operation);
        return (R)((Traversable)finisher.apply(iterator2));
    }

    static void subSequenceRangeCheck(int beginIndex, int endIndex, int length) {
        if (beginIndex < 0 || endIndex > length) {
            throw new IndexOutOfBoundsException("subSequence(" + beginIndex + ", " + endIndex + "), length = " + length);
        }
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("subSequence(" + beginIndex + ", " + endIndex + ")");
        }
    }

    static <T> IterableWithSize<T> withSize(Iterable<? extends T> iterable) {
        return Collections.isTraversableAgain(iterable) ? Collections.withSizeTraversable(iterable) : Collections.withSizeTraversable(List.ofAll(iterable));
    }

    private static <T> IterableWithSize<T> withSizeTraversable(Iterable<? extends T> iterable) {
        if (iterable instanceof Collection) {
            return new IterableWithSize<T>(iterable, ((Collection)iterable).size());
        }
        return new IterableWithSize<T>(iterable, ((Traversable)iterable).size());
    }

    static class IterableWithSize<T> {
        private final Iterable<? extends T> iterable;
        private final int size;

        IterableWithSize(Iterable<? extends T> iterable, int size) {
            this.iterable = iterable;
            this.size = size;
        }

        java.util.Iterator<? extends T> iterator() {
            return this.iterable.iterator();
        }

        int size() {
            return this.size;
        }

        Object[] toArray() {
            if (this.iterable instanceof Collection) {
                return ((Collection)this.iterable).toArray();
            }
            return ArrayType.asArray(this.iterator(), this.size());
        }
    }
}

