/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.merge;

import javax.swing.Icon;
import org.gephi.datalab.api.AttributeColumnsMergeStrategiesController;
import org.gephi.datalab.plugin.manipulators.columns.merge.GeneralColumnTitleChooser;
import org.gephi.datalab.plugin.manipulators.columns.merge.ui.GeneralColumnTitleChooserUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.columns.merge.AttributeColumnsMergeStrategy;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Table;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MaximumNumber
implements AttributeColumnsMergeStrategy,
GeneralColumnTitleChooser {
    private Table table;
    private Column[] columns;
    private String columnTitle;

    public void setup(Table table, Column[] columns) {
        this.table = table;
        this.columns = columns;
    }

    public void execute() {
        ((AttributeColumnsMergeStrategiesController)Lookup.getDefault().lookup(AttributeColumnsMergeStrategiesController.class)).maxValueNumbersMerge(this.table, this.columns, this.columnTitle);
    }

    public String getName() {
        return NbBundle.getMessage(MaximumNumber.class, (String)"MaximumNumber.name");
    }

    public String getDescription() {
        return NbBundle.getMessage(MaximumNumber.class, (String)"MaximumNumber.description");
    }

    public boolean canExecute() {
        for (Column column : this.columns) {
            if (AttributeUtils.isNumberType((Class)column.getTypeClass())) continue;
            return false;
        }
        return true;
    }

    public ManipulatorUI getUI() {
        return new GeneralColumnTitleChooserUI();
    }

    public int getType() {
        return 100;
    }

    public int getPosition() {
        return 700;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/plus-white.png", (boolean)false);
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public String getColumnTitle() {
        return this.columnTitle;
    }

    @Override
    public void setColumnTitle(String columnTitle) {
        this.columnTitle = columnTitle;
    }
}

