/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.search.plugin;

import org.gephi.desktop.search.api.SearchRequest;
import org.gephi.desktop.search.impl.SearchCategoryImpl;
import org.gephi.desktop.search.spi.SearchProvider;
import org.gephi.desktop.search.spi.SearchResultsBuilder;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.ElementIterable;
import org.openide.util.NbBundle;

public class ElementLabelSearchProvider
implements SearchProvider<Element> {
    @Override
    public void search(SearchRequest request, SearchResultsBuilder<Element> resultsBuilder) {
        String query = request.getQuery();
        if (request.isCategoryIncluded(SearchCategoryImpl.NODES())) {
            this.matchElementLabel((ElementIterable<? extends Element>)request.getGraph().getNodes(), query, resultsBuilder);
        }
        if (request.isCategoryIncluded(SearchCategoryImpl.EDGES())) {
            this.matchElementLabel((ElementIterable<? extends Element>)request.getGraph().getEdges(), query, resultsBuilder);
        }
    }

    protected void matchElementLabel(ElementIterable<? extends Element> iterable, String query, SearchResultsBuilder<Element> resultsBuilder) {
        String matchLocation = this.toMatchLocation();
        for (Element element : iterable) {
            if (this.match(element, query) && !resultsBuilder.addResult(element, this.toHtmlDisplay(element, query), matchLocation)) {
                iterable.doBreak();
                break;
            }
            if (!resultsBuilder.isObsolete()) continue;
            iterable.doBreak();
            break;
        }
    }

    protected boolean match(Element element, String query) {
        return element.getLabel() != null && element.getLabel().equalsIgnoreCase(query);
    }

    protected String toMatchLocation() {
        return NbBundle.getMessage(ElementLabelSearchProvider.class, (String)"ElementLabelSearchProvider.match");
    }

    protected String toHtmlDisplay(Element element, String query) {
        return NbBundle.getMessage(ElementLabelSearchProvider.class, (String)"ElementLabelSearchProvider.result", (Object)element.getLabel());
    }
}

