/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultButtonModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.infonode.gui.PopupListListener;
import net.infonode.gui.UIManagerUtil;
import net.infonode.gui.panel.SimplePanel;

public class PopupList
extends SimplePanel {
    private Popup popup = new Popup();
    private ArrayList listeners = new ArrayList(1);

    public PopupList(AbstractButton component) {
        this.setLayout(new BoxLayout(this, 1));
        this.setButton(component);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ((PopupButtonModel)((AbstractButton)PopupList.this.getComponent(0)).getModel()).setPressedInternal(false);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ((PopupButtonModel)((AbstractButton)PopupList.this.getComponent(0)).getModel()).setPressedInternal(true);
            }
        });
    }

    public JList getList() {
        return this.popup.getList();
    }

    public void setButton(AbstractButton component) {
        if (this.getComponentCount() > 0) {
            AbstractButton c = (AbstractButton)this.getComponent(0);
            c.removeMouseListener(this.popup.getMouseListener());
            c.removeMouseMotionListener(this.popup.getMouseMotionListener());
            this.remove(c);
        }
        this.add(component);
        component.setModel(new PopupButtonModel());
        component.setAutoscrolls(true);
        component.setFocusable(false);
        component.addMouseListener(this.popup.getMouseListener());
        component.addMouseMotionListener(this.popup.getMouseMotionListener());
    }

    public AbstractButton getButton() {
        return this.getComponentCount() == 0 ? null : (AbstractButton)this.getComponent(0);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.popup != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    public void addPopupListListener(PopupListListener l) {
        this.listeners.add(l);
    }

    public void removePopupListListener(PopupListListener l) {
        this.listeners.remove(l);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.getList().addListSelectionListener(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.getList().removeListSelectionListener(l);
    }

    private void fireWillBecomeVisible() {
        Object[] l = this.listeners.toArray();
        int i = 0;
        while (i < l.length) {
            ((PopupListListener)l[i]).willBecomeVisible(this);
            ++i;
        }
    }

    private class Popup
    extends JPopupMenu {
        private JList list = new JList();
        private JScrollPane scrollPane = new JScrollPane(this.list, 20, 31);
        private int oldIndex;

        Popup() {
            this.setLayout(new BoxLayout(this, 1));
            this.scrollPane.setBorder(null);
            this.setBorderPainted(true);
            this.setBorder(new LineBorder(UIManagerUtil.getColor("controlDkShadow", Color.BLACK), 1));
            this.add(this.scrollPane);
            this.scrollPane.getViewport().setOpaque(false);
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        Popup.this.setVisible(false);
                    }
                }
            });
            this.update();
        }

        public MouseMotionListener getMouseMotionListener() {
            return new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        Component c = (Component)e.getSource();
                        Point p = SwingUtilities.convertPoint(c, e.getPoint(), Popup.this.scrollPane);
                        int index = Popup.this.list.locationToIndex(SwingUtilities.convertPoint(Popup.this.scrollPane, p, Popup.this.list));
                        if (!c.contains(e.getPoint()) && (Popup.this.scrollPane.contains(p) || p.getY() > (double)(Popup.this.scrollPane.getY() + Popup.this.scrollPane.getHeight()) || p.getY() < (double)Popup.this.scrollPane.getY())) {
                            Popup.this.list.setSelectedIndex(index);
                            Popup.this.list.ensureIndexIsVisible(index);
                        }
                    }
                }
            };
        }

        public MouseListener getMouseListener() {
            return new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        if (Popup.this.isVisible()) {
                            Popup.this.setVisible(false);
                            return;
                        }
                        Popup.this.update();
                        Popup.this.scrollPane.setViewportView(null);
                        Popup.this.list.setValueIsAdjusting(true);
                        PopupList.this.fireWillBecomeVisible();
                        Popup.this.list.setVisibleRowCount(Math.min(Popup.this.list.getModel().getSize(), 8));
                        Popup.this.oldIndex = Popup.this.list.getSelectedIndex();
                        Popup.this.list.ensureIndexIsVisible(Popup.this.oldIndex);
                        Popup.this.scrollPane.setViewportView(Popup.this.list);
                        Component c = (Component)e.getSource();
                        Popup.this.show(c, 0, c.getHeight());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        if (!Popup.this.isVisible()) {
                            return;
                        }
                        Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), Popup.this.scrollPane);
                        if (Popup.this.scrollPane.contains(p)) {
                            Popup.this.list.setValueIsAdjusting(false);
                        } else if (!((Component)e.getSource()).contains(e.getPoint())) {
                            Popup.this.list.setSelectedIndex(Popup.this.oldIndex);
                            Popup.this.list.setValueIsAdjusting(false);
                        }
                    }
                }
            };
        }

        public JList getList() {
            return this.list;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(new LineBorder(UIManagerUtil.getColor("controlDkShadow", Color.BLACK), 1));
            if (this.list != null) {
                this.update();
            }
        }

        private void update() {
            this.scrollPane.getViewport().setOpaque(false);
            this.scrollPane.setBorder(null);
        }
    }

    private class PopupButtonModel
    extends DefaultButtonModel {
        private boolean pressed;

        private PopupButtonModel() {
        }

        @Override
        public boolean isPressed() {
            return super.isPressed() || this.pressed;
        }

        @Override
        public boolean isArmed() {
            return super.isArmed() || this.pressed;
        }

        public void setPressedInternal(boolean pressed) {
            this.pressed = pressed;
            this.fireStateChanged();
        }
    }
}

