﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/notifications/Notifications_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Notifications {
namespace Model {

/**
 * <p>A resource affected by or closely linked to an event.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/Resource">AWS
 * API Reference</a></p>
 */
class Resource {
 public:
  AWS_NOTIFICATIONS_API Resource() = default;
  AWS_NOTIFICATIONS_API Resource(Aws::Utils::Json::JsonView jsonValue);
  AWS_NOTIFICATIONS_API Resource& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_NOTIFICATIONS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique identifier for the resource.</p> <p>At least one id or ARN is
   * required.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  Resource& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the resource. At least one id or ARN is
   * required.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  Resource& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The URL to the resource's detail page. If a detail page URL is unavailable,
   * it is the URL to an informational page that describes the resource's type.</p>
   */
  inline const Aws::String& GetDetailUrl() const { return m_detailUrl; }
  inline bool DetailUrlHasBeenSet() const { return m_detailUrlHasBeenSet; }
  template <typename DetailUrlT = Aws::String>
  void SetDetailUrl(DetailUrlT&& value) {
    m_detailUrlHasBeenSet = true;
    m_detailUrl = std::forward<DetailUrlT>(value);
  }
  template <typename DetailUrlT = Aws::String>
  Resource& WithDetailUrl(DetailUrlT&& value) {
    SetDetailUrl(std::forward<DetailUrlT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A map of tags assigned to a resource. A tag is a string-to-string map of
   * key-value pairs.</p>
   */
  inline const Aws::Vector<Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Vector<Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Vector<Aws::String>>
  Resource& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsT = Aws::String>
  Resource& AddTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace_back(std::forward<TagsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_arn;

  Aws::String m_detailUrl;

  Aws::Vector<Aws::String> m_tags;
  bool m_idHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_detailUrlHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Notifications
}  // namespace Aws
