/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.zaproxy.zap.model.Tech;

public class TechSet {
    @Deprecated
    public static final TechSet AllTech = new TechSet(Tech.getTopLevel());
    private TreeSet<Tech> includeTech = new TreeSet();
    private TreeSet<Tech> excludeTech = new TreeSet();

    public TechSet() {
    }

    public TechSet(Tech ... include) {
        this(include, (Tech[])null);
    }

    public TechSet(Tech[] include, Tech[] exclude) {
        if (include != null) {
            for (Tech tech : include) {
                this.include(tech);
            }
        }
        if (exclude != null) {
            for (Tech tech : exclude) {
                this.exclude(tech);
            }
        }
    }

    public TechSet(Set<Tech> include) {
        this.includeTech.addAll(include);
    }

    public TechSet(TechSet techSet) {
        this.includeTech.addAll(techSet.includeTech);
        this.excludeTech.addAll(techSet.excludeTech);
    }

    public void include(Tech tech) {
        this.excludeTech.remove(tech);
        this.includeTech.add(tech);
    }

    public void includeAll(Tech tech) {
        Set<Tech> techs = TechSet.getAll(tech);
        this.includeTech.addAll(techs);
        this.excludeTech.removeAll(techs);
    }

    public void exclude(Tech tech) {
        this.includeTech.remove(tech);
        this.excludeTech.add(tech);
    }

    public void excludeAll(Tech tech) {
        Set<Tech> techs = TechSet.getAll(tech);
        this.excludeTech.addAll(techs);
        this.includeTech.removeAll(techs);
    }

    public boolean includes(Tech tech) {
        if (tech == null) {
            return false;
        }
        if (this.excludeTech.contains(tech)) {
            return false;
        }
        if (this.includeTech.contains(tech)) {
            return true;
        }
        return this.includes(tech.getParent());
    }

    public boolean includesAny(Tech ... techs) {
        if (techs == null || techs.length == 0) {
            return false;
        }
        for (Tech tech : techs) {
            if (!this.includes(tech)) continue;
            return true;
        }
        return false;
    }

    public TreeSet<Tech> getIncludeTech() {
        TreeSet<Tech> copy = new TreeSet<Tech>();
        copy.addAll(this.includeTech);
        return copy;
    }

    public TreeSet<Tech> getExcludeTech() {
        TreeSet<Tech> copy = new TreeSet<Tech>();
        copy.addAll(this.excludeTech);
        return copy;
    }

    public void print() {
        System.out.println("TechSet: " + this.hashCode());
        for (Tech tech : this.includeTech) {
            System.out.println("\tInclude: " + String.valueOf(tech));
        }
        for (Tech tech : this.excludeTech) {
            System.out.println("\tExclude: " + String.valueOf(tech));
        }
    }

    public static TechSet getAllTech() {
        return new TechSet(Tech.getTopLevel());
    }

    public int hashCode() {
        return Objects.hash(this.excludeTech, this.includeTech);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TechSet)) {
            return false;
        }
        TechSet other = (TechSet)obj;
        return Objects.equals(this.excludeTech, other.excludeTech) && Objects.equals(this.includeTech, other.includeTech);
    }

    static Set<Tech> getAll(Tech aTech) {
        TreeSet<Tech> techs = new TreeSet<Tech>();
        Iterator<Tech> iterator = Tech.getAll().iterator();
        while (iterator.hasNext()) {
            for (Tech tech = iterator.next(); tech != null; tech = tech.getParent()) {
                if (!tech.is(aTech)) continue;
                techs.add(tech);
            }
        }
        return techs;
    }
}

