/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.core;

import com.strobel.core.Selector;
import com.strobel.core.VerifyArgument;
import com.strobel.util.ContractUtils;

public final class Selectors {
    private static final Selector<?, ?> IDENTITY_SELECTOR = new Selector<Object, Object>(){

        @Override
        public Object select(Object source) {
            return source;
        }
    };
    private static final Selector<String, String> TO_UPPERCASE = new Selector<String, String>(){

        @Override
        public String select(String source) {
            if (source == null) {
                return null;
            }
            return source.toUpperCase();
        }
    };
    private static final Selector<String, String> TO_LOWERCASE = new Selector<String, String>(){

        @Override
        public String select(String source) {
            if (source == null) {
                return null;
            }
            return source.toUpperCase();
        }
    };
    private static final Selector<?, String> TO_STRING = new Selector<Object, String>(){

        @Override
        public String select(Object source) {
            if (source == null) {
                return null;
            }
            return source.toString();
        }
    };

    private Selectors() {
        throw ContractUtils.unreachable();
    }

    public static <T> Selector<T, T> identity() {
        return IDENTITY_SELECTOR;
    }

    public static Selector<String, String> toUpperCase() {
        return TO_UPPERCASE;
    }

    public static Selector<String, String> toLowerCase() {
        return TO_LOWERCASE;
    }

    public static <T> Selector<T, String> asString() {
        return TO_STRING;
    }

    public static <T, R> Selector<T, R> cast(final Class<R> destinationType) {
        return new Selector<T, R>(){

            @Override
            public R select(T source) {
                return destinationType.cast(source);
            }
        };
    }

    public static <T, U, R> Selector<T, R> combine(final Selector<? super T, ? extends U> first, final Selector<? super U, ? extends R> second) {
        VerifyArgument.notNull(first, "first");
        VerifyArgument.notNull(second, "second");
        return new Selector<T, R>(){

            @Override
            public R select(T source) {
                return second.select(first.select(source));
            }
        };
    }
}

