/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.sql;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.jstl.sql.SQLExecutionTag;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.taglibs.standard.resources.Resources;

public abstract class DateParamTagSupport
extends TagSupport {
    private static final String TIMESTAMP_TYPE = "timestamp";
    private static final String TIME_TYPE = "time";
    private static final String DATE_TYPE = "date";
    protected String type;
    protected Date value;

    public DateParamTagSupport() {
        this.init();
    }

    private void init() {
        this.value = null;
        this.type = null;
    }

    @Override
    public int doEndTag() throws JspException {
        SQLExecutionTag parent = (SQLExecutionTag)((Object)DateParamTagSupport.findAncestorWithClass(this, SQLExecutionTag.class));
        if (parent == null) {
            throw new JspTagException(Resources.getMessage("SQL_PARAM_OUTSIDE_PARENT"));
        }
        if (this.value != null) {
            this.convertValue();
        }
        parent.addSQLParameter(this.value);
        return 6;
    }

    private void convertValue() throws JspException {
        if (this.type == null || this.type.equalsIgnoreCase(TIMESTAMP_TYPE)) {
            if (!(this.value instanceof Timestamp)) {
                this.value = new Timestamp(this.value.getTime());
            }
        } else if (this.type.equalsIgnoreCase(TIME_TYPE)) {
            if (!(this.value instanceof Time)) {
                this.value = new Time(this.value.getTime());
            }
        } else if (this.type.equalsIgnoreCase(DATE_TYPE)) {
            if (!(this.value instanceof java.sql.Date)) {
                this.value = new java.sql.Date(this.value.getTime());
            }
        } else {
            throw new JspException(Resources.getMessage("SQL_DATE_PARAM_INVALID_TYPE", this.type));
        }
    }
}

