/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;

public class Eckert5Projection
extends Projection {
    private static final double XF = 0.4410127717245515;
    private static final double RXF = 2.267508027238226;
    private static final double YF = 0.882025543449103;
    private static final double RYF = 1.133754013619113;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.x = 0.4410127717245515 * (1.0 + Math.cos(lpphi)) * lplam;
        out.y = 0.882025543449103 * lpphi;
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.y = 1.133754013619113 * xyy;
        out.x = 2.267508027238226 * xyx / (1.0 + Math.cos(out.y));
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Eckert V";
    }
}

