/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.document.common;

import java.io.IOException;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.protobufs.ShardFailure;
import org.opensearch.protobufs.ShardInfo;
import org.opensearch.transport.grpc.proto.response.exceptions.opensearchexception.OpenSearchExceptionProtoUtils;

public class ShardInfoProtoUtils {
    private ShardInfoProtoUtils() {
    }

    public static ShardInfo toProto(ReplicationResponse.ShardInfo shardInfo) throws IOException {
        ShardInfo.Builder shardInfoBuilder = ShardInfo.newBuilder();
        shardInfoBuilder.setTotal(shardInfo.getTotal());
        shardInfoBuilder.setSuccessful(shardInfo.getSuccessful());
        shardInfoBuilder.setFailed(shardInfo.getFailed());
        for (ReplicationResponse.ShardInfo.Failure failure : shardInfo.getFailures()) {
            shardInfoBuilder.addFailures(ShardInfoProtoUtils.toProto(failure));
        }
        return shardInfoBuilder.build();
    }

    private static ShardFailure toProto(ReplicationResponse.ShardInfo.Failure failure) throws IOException {
        ShardFailure.Builder shardFailure = ShardFailure.newBuilder();
        shardFailure.setIndex(failure.index());
        shardFailure.setShard(failure.shardId());
        shardFailure.setNode(failure.nodeId());
        shardFailure.setReason(OpenSearchExceptionProtoUtils.generateThrowableProto(failure.getCause()));
        shardFailure.setStatus(failure.status().name());
        shardFailure.setPrimary(failure.primary());
        return shardFailure.build();
    }
}

