/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.fielddata.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ToLongBiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.Accountable;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.cache.Cache;
import org.opensearch.common.cache.CacheBuilder;
import org.opensearch.common.cache.RemovalListener;
import org.opensearch.common.cache.RemovalNotification;
import org.opensearch.common.cache.RemovalReason;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.RatioValue;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexFieldDataCache;
import org.opensearch.index.fielddata.LeafFieldData;
import org.opensearch.index.shard.ShardUtils;
import org.opensearch.threadpool.ThreadPool;

@PublicApi(since="1.0.0")
public class IndicesFieldDataCache
implements RemovalListener<Key, Accountable>,
Releasable {
    private static final Logger logger = LogManager.getLogger(IndicesFieldDataCache.class);
    public static final RatioValue MAX_SIZE_PERCENTAGE = new RatioValue(35.0);
    public static final Setting<ByteSizeValue> INDICES_FIELDDATA_CACHE_SIZE_KEY = Setting.memorySizeSetting("indices.fielddata.cache.size", MAX_SIZE_PERCENTAGE.toString(), Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final IndexFieldDataCache.Listener indicesFieldDataCacheListener;
    private final Cache<Key, Accountable> cache;
    private final ThreadPool threadPool;
    private Set<Index> indicesToClear;
    private Map<Index, Set<String>> fieldsToClear;
    private Set<IndexReader.CacheKey> cacheKeysToClear;

    @Deprecated
    public IndicesFieldDataCache(Settings settings, IndexFieldDataCache.Listener indicesFieldDataCacheListener) {
        this(settings, indicesFieldDataCacheListener, null, null);
    }

    public IndicesFieldDataCache(Settings settings, IndexFieldDataCache.Listener indicesFieldDataCacheListener, ClusterService clusterService, ThreadPool threadPool) {
        this.indicesFieldDataCacheListener = indicesFieldDataCacheListener;
        long sizeInBytes = INDICES_FIELDDATA_CACHE_SIZE_KEY.get(settings).getBytes();
        CacheBuilder<Key, Accountable> cacheBuilder = CacheBuilder.builder().removalListener(this);
        if (sizeInBytes > 0L) {
            cacheBuilder.setMaximumWeight(sizeInBytes).weigher(new FieldDataWeigher());
        }
        this.cache = cacheBuilder.build();
        if (clusterService != null) {
            clusterService.getClusterSettings().addSettingsUpdateConsumer(INDICES_FIELDDATA_CACHE_SIZE_KEY, this::updateMaximumWeight);
        } else {
            logger.warn("IndicesFieldDataCache ctor got null clusterService argument! Cluster setting updates for cache size will not work!");
        }
        this.threadPool = threadPool;
        if (threadPool == null) {
            logger.warn("IndicesFieldDataCache ctor got null threadPool! Evictions on cache resize will happen on cluster applier thread!");
        }
        this.indicesToClear = ConcurrentCollections.newConcurrentSet();
        this.fieldsToClear = new ConcurrentHashMap<Index, Set<String>>();
        this.cacheKeysToClear = ConcurrentCollections.newConcurrentSet();
    }

    public void close() {
        this.cache.invalidateAll();
    }

    public IndexFieldDataCache buildIndexFieldDataCache(IndexFieldDataCache.Listener listener, Index index, String fieldName) {
        return new IndexFieldCache(logger, this, index, fieldName, this.indicesFieldDataCacheListener, listener);
    }

    public Cache<Key, Accountable> getCache() {
        return this.cache;
    }

    @Override
    public void onRemoval(RemovalNotification<Key, Accountable> notification) {
        Key key = notification.getKey();
        assert (key != null && key.listeners != null);
        IndexFieldCache indexCache = key.indexCache;
        Accountable value = notification.getValue();
        for (IndexFieldDataCache.Listener listener : key.listeners) {
            try {
                listener.onRemoval(key.shardId, indexCache.fieldName, notification.getRemovalReason() == RemovalReason.EVICTED, value.ramBytesUsed());
            }
            catch (Exception e) {
                logger.error("Failed to call listener on field data cache unloading", (Throwable)e);
            }
        }
    }

    public void clear(Index index) {
        this.indicesToClear.add(index);
    }

    public void clear(Index index, String field) {
        Set fieldsOfIndex = this.fieldsToClear.computeIfAbsent(index, idx -> ConcurrentCollections.newConcurrentSet());
        fieldsOfIndex.add(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (!(this.indicesToClear.isEmpty() && this.fieldsToClear.isEmpty() && this.cacheKeysToClear.isEmpty())) {
            Set<Index> indicesToClearCopy = Set.copyOf(this.indicesToClear);
            Set<IndexReader.CacheKey> cacheKeysToClearCopy = Set.copyOf(this.cacheKeysToClear);
            HashMap fieldsToClearCopy = new HashMap();
            for (Map.Entry<Index, Set<String>> entry : this.fieldsToClear.entrySet()) {
                fieldsToClearCopy.put(entry.getKey(), Set.copyOf((Collection)entry.getValue()));
            }
            this.indicesToClear.removeAll(indicesToClearCopy);
            this.cacheKeysToClear.removeAll(cacheKeysToClearCopy);
            for (Map.Entry<Object, Set<String>> entry : fieldsToClearCopy.entrySet()) {
                Set<String> fieldsForIndex = this.fieldsToClear.get(entry.getKey());
                if (fieldsForIndex == null) continue;
                fieldsForIndex.removeAll((Collection)entry.getValue());
            }
            IndicesFieldDataCache indicesFieldDataCache = this;
            synchronized (indicesFieldDataCache) {
                Iterator<Key> iterator = this.getCache().keys().iterator();
                while (iterator.hasNext()) {
                    Key key = iterator.next();
                    if (indicesToClearCopy.contains(key.indexCache.index)) {
                        this.removeKey(iterator);
                        continue;
                    }
                    Set fieldsOfIndexToClear = (Set)fieldsToClearCopy.get(key.indexCache.index);
                    if (fieldsOfIndexToClear != null && fieldsOfIndexToClear.contains(key.indexCache.fieldName)) {
                        this.removeKey(iterator);
                        continue;
                    }
                    if (!cacheKeysToClearCopy.contains(key.readerKey)) continue;
                    this.removeKey(iterator);
                }
            }
        }
        this.cache.refresh();
    }

    private void removeKey(Iterator<Key> iterator) {
        try {
            iterator.remove();
        }
        catch (Exception e) {
            logger.warn("Exception occurred while removing key from cache", (Throwable)e);
        }
    }

    private void updateMaximumWeight(ByteSizeValue newMaximumWeight) {
        long oldMaximumWeight = this.cache.getMaximumWeight();
        this.cache.setMaximumWeight(newMaximumWeight.getBytes());
        if (newMaximumWeight.getBytes() < oldMaximumWeight) {
            if (this.threadPool != null) {
                this.threadPool.executor("generic").execute(this.cache::refresh);
            } else {
                this.cache.refresh();
            }
        }
    }

    public static class FieldDataWeigher
    implements ToLongBiFunction<Key, Accountable> {
        @Override
        public long applyAsLong(Key key, Accountable ramUsage) {
            int weight = (int)Math.min(ramUsage.ramBytesUsed(), Integer.MAX_VALUE);
            return weight == 0 ? 1L : (long)weight;
        }
    }

    static class IndexFieldCache
    implements IndexFieldDataCache,
    IndexReader.ClosedListener {
        private final Logger logger;
        final Index index;
        final String fieldName;
        final IndicesFieldDataCache nodeLevelCache;
        private final IndexFieldDataCache.Listener[] listeners;

        IndexFieldCache(Logger logger, IndicesFieldDataCache nodeLevelCache, Index index, String fieldName, IndexFieldDataCache.Listener ... listeners) {
            this.logger = logger;
            this.listeners = listeners;
            this.index = index;
            this.fieldName = fieldName;
            this.nodeLevelCache = nodeLevelCache;
        }

        @Override
        public <FD extends LeafFieldData, IFD extends IndexFieldData<FD>> FD load(LeafReaderContext context, IFD indexFieldData) throws Exception {
            ShardId shardId = ShardUtils.extractShardId(context.reader());
            IndexReader.CacheHelper cacheHelper = context.reader().getCoreCacheHelper();
            if (cacheHelper == null) {
                throw new IllegalArgumentException("Reader " + String.valueOf(context.reader()) + " does not support caching");
            }
            Key key = new Key(this, cacheHelper.getKey(), shardId);
            Accountable accountable = this.nodeLevelCache.getCache().computeIfAbsent(key, k -> {
                cacheHelper.addClosedListener((IndexReader.ClosedListener)this);
                Collections.addAll(k.listeners, this.listeners);
                Object fieldData = indexFieldData.loadDirect(context);
                for (IndexFieldDataCache.Listener listener : k.listeners) {
                    try {
                        listener.onCache(shardId, this.fieldName, (Accountable)fieldData);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to call listener on atomic field data loading", (Throwable)e);
                    }
                }
                return fieldData;
            });
            return (FD)((LeafFieldData)accountable);
        }

        @Override
        public <FD extends LeafFieldData, IFD extends IndexFieldData.Global<FD>> IFD load(DirectoryReader indexReader, IFD indexFieldData) throws Exception {
            ShardId shardId = ShardUtils.extractShardId(indexReader);
            IndexReader.CacheHelper cacheHelper = indexReader.getReaderCacheHelper();
            if (cacheHelper == null) {
                throw new IllegalArgumentException("Reader " + String.valueOf(indexReader) + " does not support caching");
            }
            Key key = new Key(this, cacheHelper.getKey(), shardId);
            Accountable accountable = this.nodeLevelCache.getCache().computeIfAbsent(key, k -> {
                OpenSearchDirectoryReader.addReaderCloseListener(indexReader, this);
                Collections.addAll(k.listeners, this.listeners);
                Accountable ifd = (Accountable)indexFieldData.loadGlobalDirect(indexReader);
                for (IndexFieldDataCache.Listener listener : k.listeners) {
                    try {
                        listener.onCache(shardId, this.fieldName, ifd);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to call listener on global ordinals loading", (Throwable)e);
                    }
                }
                return ifd;
            });
            return (IFD)((IndexFieldData.Global)accountable);
        }

        public void onClose(IndexReader.CacheKey key) throws IOException {
            this.nodeLevelCache.cacheKeysToClear.add(key);
        }

        @Override
        public void clear() {
            this.nodeLevelCache.clear(this.index);
        }

        @Override
        public void clear(String fieldName) {
            this.nodeLevelCache.clear(this.index, fieldName);
        }
    }

    @PublicApi(since="1.0.0")
    public static class Key {
        public final IndexFieldCache indexCache;
        public final IndexReader.CacheKey readerKey;
        public final ShardId shardId;
        public final List<IndexFieldDataCache.Listener> listeners = new ArrayList<IndexFieldDataCache.Listener>();

        Key(IndexFieldCache indexCache, IndexReader.CacheKey readerKey, @Nullable ShardId shardId) {
            this.indexCache = indexCache;
            this.readerKey = readerKey;
            this.shardId = shardId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.indexCache.equals(key.indexCache)) {
                return false;
            }
            return this.readerKey.equals(key.readerKey);
        }

        public int hashCode() {
            int result = this.indexCache.hashCode();
            result = 31 * result + this.readerKey.hashCode();
            return result;
        }
    }
}

