/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.rules.FakeRule;
import org.languagetool.rules.RemoteRuleFilters;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class RemoteRuleFiltersTest {
    private static Language testLang = TestTools.getDemoLanguage();
    private static final String TEST_RULE = "TEST_REMOTE_RULE";

    @Test
    public void load() throws Exception {
        Map rules = RemoteRuleFilters.load((Language)testLang);
        Assert.assertTrue((String)"loaded test rule", (boolean)rules.containsKey(TEST_RULE));
        Assert.assertEquals((String)"loaded test rule", (long)((List)rules.get(TEST_RULE)).size(), (long)1L);
    }

    private RuleMatch matchSubstring(final String ruleId, AnalyzedSentence sentence, String substring) {
        FakeRule r = new FakeRule(){

            public String getId() {
                return ruleId;
            }
        };
        int start = sentence.getText().indexOf(substring);
        int end = start + substring.length();
        return new RuleMatch((Rule)r, sentence, start, end, "test match");
    }

    @Test
    public void testSimpleFilter() throws IOException, ExecutionException {
        JLanguageTool lt = new JLanguageTool(testLang);
        AnalyzedSentence s = lt.getAnalyzedSentence("This is a test.");
        Assert.assertTrue((String)"Simple filter works", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(TEST_RULE, s, "test"))).isEmpty());
        Assert.assertFalse((String)"Filter respects IDs", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring("TEST_REMOTE_RULE_NEW", s, "test"))).isEmpty());
    }

    @Test
    public void testMultiTokenWhitespace() throws IOException, ExecutionException {
        String ruleId = "TEST_WHITESPACE";
        JLanguageTool lt = new JLanguageTool(testLang);
        String sub = "foo bar";
        AnalyzedSentence s = lt.getAnalyzedSentence("This is " + sub + " test.");
        Assert.assertTrue((String)"Filter works", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(ruleId, s, "foo bar"))).isEmpty());
        sub = "foo   bar";
        s = lt.getAnalyzedSentence("This is " + sub + " test.");
        Assert.assertTrue((String)"Filter works with multiple spaces", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(ruleId, s, sub))).isEmpty());
        sub = "foo \n bar";
        s = lt.getAnalyzedSentence("This is " + sub + " test.");
        Assert.assertTrue((String)"Filter works with newlines", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(ruleId, s, sub))).isEmpty());
    }

    @Test
    public void testMarker() throws IOException, ExecutionException {
        String ruleId = "TEST_MARKER";
        JLanguageTool lt = new JLanguageTool(testLang);
        AnalyzedSentence s = lt.getAnalyzedSentence("I went to the bar.");
        Assert.assertFalse((String)"Filter doesn't apply because of pre-marker context", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(ruleId, s, "bar"))).isEmpty());
        s = lt.getAnalyzedSentence("I went to the foo bar.");
        Assert.assertTrue((String)"Filter applies, marker wroks", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(ruleId, s, "bar"))).isEmpty());
    }

    @Test
    public void testAntipattern() throws IOException, ExecutionException {
        String ruleId = "TEST_ANTIPATTERN";
        JLanguageTool lt = new JLanguageTool(testLang);
        AnalyzedSentence s = lt.getAnalyzedSentence("I went to the test bar.");
        Assert.assertFalse((String)"Filter doesn't apply because of antipattern", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(ruleId, s, "test bar"))).isEmpty());
        s = lt.getAnalyzedSentence("I went to the best bar.");
        Assert.assertTrue((String)"Filter applies, antipattern did not match", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(ruleId, s, "best bar"))).isEmpty());
    }

    @Test
    public void testIDRegexFilter() throws IOException, ExecutionException {
        String ruleId = "TEST_ID_REGEX";
        JLanguageTool lt = new JLanguageTool(testLang);
        AnalyzedSentence s = lt.getAnalyzedSentence("This is a foo.");
        Assert.assertFalse((String)"Regex doesn't match", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(ruleId, s, "foo"))).isEmpty());
        Assert.assertTrue((String)"Regex matches 1", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(ruleId + "1", s, "foo"))).isEmpty());
        Assert.assertTrue((String)"Regex matches 2", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(ruleId + "2", s, "foo"))).isEmpty());
        Assert.assertTrue((String)"Regex matches 3", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(ruleId + "99", s, "foo"))).isEmpty());
        Assert.assertFalse((String)"Regex must match complete string", (boolean)RemoteRuleFilters.filterMatches((Language)testLang, (AnalyzedSentence)s, Arrays.asList(this.matchSubstring(ruleId + "100", s, "foo"))).isEmpty());
    }
}

