/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSegments<S extends Segment>
implements Segments<S> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSegments.class);
    final TreeMap<Long, S> segments = new TreeMap();
    final String name;
    private final long retentionPeriod;
    private final long segmentInterval;
    private final SimpleDateFormat formatter;
    Position position;

    AbstractSegments(String name, long retentionPeriod, long segmentInterval) {
        this.name = name;
        this.segmentInterval = segmentInterval;
        this.retentionPeriod = retentionPeriod;
        this.formatter = new SimpleDateFormat("yyyyMMddHHmm");
        this.formatter.setTimeZone(new SimpleTimeZone(0, "UTC"));
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public long segmentId(long timestamp) {
        return timestamp / this.segmentInterval;
    }

    @Override
    public String segmentName(long segmentId) {
        return this.name + "." + segmentId * this.segmentInterval;
    }

    @Override
    public S segmentForTimestamp(long timestamp) {
        return (S)((Segment)this.segments.get(this.segmentId(timestamp)));
    }

    @Override
    public S getOrCreateSegmentIfLive(long segmentId, StateStoreContext context, long streamTime) {
        long minLiveTimestamp = streamTime - this.retentionPeriod;
        long minLiveSegment = this.segmentId(minLiveTimestamp);
        if (segmentId >= minLiveSegment) {
            return this.getOrCreateSegment(segmentId, context);
        }
        return null;
    }

    @Override
    public void openExisting(StateStoreContext context, long streamTime) {
        try {
            File dir = new File(context.stateDir(), this.name);
            if (dir.exists()) {
                String[] list = dir.list();
                if (list != null) {
                    Arrays.stream(list).map(segment -> this.segmentIdFromSegmentName((String)segment, dir)).sorted().filter(segmentId -> segmentId >= 0L).forEach(segmentId -> this.getOrCreateSegment((long)segmentId, context));
                }
            } else if (!dir.mkdir()) {
                throw new ProcessorStateException(String.format("dir %s doesn't exist and cannot be created for segments %s", dir, this.name));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cleanupExpiredSegments(streamTime);
    }

    @Override
    public List<S> segments(long timeFrom, long timeTo, boolean forward) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        NavigableMap<Long, S> segmentsInRange = forward ? this.segments.subMap(this.segmentId(timeFrom), true, this.segmentId(timeTo), true) : this.segments.subMap(this.segmentId(timeFrom), true, this.segmentId(timeTo), true).descendingMap();
        for (Segment segment : segmentsInRange.values()) {
            if (!segment.isOpen()) continue;
            result.add(segment);
        }
        return result;
    }

    @Override
    public List<S> allSegments(boolean forward) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        Collection<Object> values = forward ? this.segments.values() : this.segments.descendingMap().values();
        for (Segment segment : values) {
            if (!segment.isOpen()) continue;
            result.add(segment);
        }
        return result;
    }

    @Override
    public void flush() {
        for (Segment segment : this.segments.values()) {
            segment.flush();
        }
    }

    @Override
    public void close() {
        for (Segment segment : this.segments.values()) {
            segment.close();
        }
        this.segments.clear();
    }

    protected void cleanupExpiredSegments(long streamTime) {
        long minLiveSegment = this.segmentId(streamTime - this.retentionPeriod);
        Iterator toRemove = this.segments.headMap(minLiveSegment, false).entrySet().iterator();
        while (toRemove.hasNext()) {
            Map.Entry next = toRemove.next();
            toRemove.remove();
            Segment segment = (Segment)next.getValue();
            segment.close();
            try {
                segment.destroy();
            }
            catch (IOException e) {
                log.error("Error destroying {}", (Object)segment, (Object)e);
            }
        }
    }

    private long segmentIdFromSegmentName(String segmentName, File parent) {
        long segmentId;
        int segmentSeparatorIndex = this.name.length();
        char segmentSeparator = segmentName.charAt(segmentSeparatorIndex);
        String segmentIdString = segmentName.substring(segmentSeparatorIndex + 1);
        if (segmentSeparator == '-') {
            try {
                segmentId = this.formatter.parse(segmentIdString).getTime() / this.segmentInterval;
            }
            catch (ParseException e) {
                log.warn("Unable to parse segmentName {} to a date. This segment will be skipped", (Object)segmentName);
                return -1L;
            }
            this.renameSegmentFile(parent, segmentName, segmentId);
        } else {
            try {
                segmentId = Long.parseLong(segmentIdString) / this.segmentInterval;
            }
            catch (NumberFormatException e) {
                throw new ProcessorStateException("Unable to parse segment id as long from segmentName: " + segmentName, e);
            }
            if (segmentSeparator == ':') {
                this.renameSegmentFile(parent, segmentName, segmentId);
            }
        }
        return segmentId;
    }

    private void renameSegmentFile(File parent, String segmentName, long segmentId) {
        File oldName = new File(parent, segmentName);
        File newName = new File(parent, this.segmentName(segmentId));
        if (!oldName.renameTo(newName)) {
            throw new ProcessorStateException("Unable to rename old style segment from: " + String.valueOf(oldName) + " to new name: " + String.valueOf(newName));
        }
    }
}

