/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.util.Vector;
import javajs.util.BS;
import org.jmol.modelset.Atom;
import org.jmol.quantum.NMRCalculation;
import org.jmol.quantum.NMRNoeMatrix;
import org.openscience.jmol.app.janocchio.NMR_JmolPanel;
import org.openscience.jmol.app.janocchio.NMR_Viewer;

public class NmrMolecule {
    protected final NMR_Viewer viewer;
    final NMR_JmolPanel nmrPanel;
    private final BS bsMol;
    private final String[] labelArray;
    protected final Vector<Double> distances = new Vector();
    protected final Vector<Double> couples = new Vector();
    protected final Vector<DihedralCouple> couplesWhole = new Vector();
    protected NMRNoeMatrix noeMatrix;
    protected String CHequation = "was";
    NMRNoeMatrix.NOEParams params = new NMRNoeMatrix.NOEParams();

    public NmrMolecule(NMR_JmolPanel nmrPanel, BS bsMol, String[] labelArray, boolean forNOE) {
        this.nmrPanel = nmrPanel;
        this.viewer = (NMR_Viewer)nmrPanel.vwr;
        this.bsMol = bsMol;
        this.labelArray = labelArray;
        this.addAtomstoMatrix();
    }

    protected DihedralCouple getDihedralCouple(Atom[] atoms) {
        return new DihedralCouple(atoms, false);
    }

    protected void addAtomstoMatrix() {
        this.noeMatrix = NMRNoeMatrix.createMatrix(this.viewer, this.bsMol, this.labelArray, this.params);
        this.viewer.setFrameModelInfo("noeMatrix", this.noeMatrix);
        try {
            this.noeMatrix.calcNOEs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("NMRMolecule saved \n" + this.noeMatrix.toString());
    }

    public Vector<Double> getDistances() {
        return this.distances;
    }

    public Vector<Double> getCouples() {
        return this.couples;
    }

    public void calcNOEs() {
        try {
            this.noeMatrix.calcNOEs();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void addCouple(Atom[] atoms) {
        DihedralCouple dihe = this.getDihedralCouple(atoms);
        double jvalue = dihe.getJvalue();
        if (Double.isNaN(jvalue)) {
            return;
        }
        this.couples.add(new Double(jvalue));
        this.couplesWhole.add(dihe);
    }

    public void addJmolCouple(int a1, int a2, int a3, int a4) {
        this.addCouple(new Atom[]{this.viewer.getAtomAt(a1), this.viewer.getAtomAt(a2), this.viewer.getAtomAt(a3), this.viewer.getAtomAt(a4)});
    }

    public double[] calcCouple(Atom[] atoms) {
        double[] dArray;
        DihedralCouple dc = this.getDihedralCouple(atoms);
        double jvalue = dc.getJvalue();
        if (Double.isNaN(jvalue)) {
            dArray = null;
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = dc.getTheta();
            dArray = dArray2;
            dArray2[1] = jvalue;
        }
        return dArray;
    }

    public double[] calcJmolCouple(int a1, int a2, int a3, int a4) {
        return this.calcCouple(new Atom[]{this.viewer.getAtomAt(a1), this.viewer.getAtomAt(a2), this.viewer.getAtomAt(a3), this.viewer.getAtomAt(a4)});
    }

    public void setCorrelationTimeTauPS(double t) {
        this.params.setCorrelationTimeTauPS(t);
    }

    public void setMixingTimeSec(double t) {
        this.params.setMixingTimeSec(t);
    }

    public void setNMRfreqMHz(double f) {
        this.params.setNMRfreqMHz(f);
    }

    public void setCutoffAng(double c) {
        this.params.setCutoffAng(c);
    }

    public void setRhoStar(double c) {
        this.params.setRhoStar(c);
    }

    public void setNoesy(boolean b) {
        this.params.setNoesy(b);
    }

    public void setCHequation(String eq) {
        this.CHequation = eq;
    }

    public double getJmolNoe(int a, int b) {
        return this.noeMatrix.getJmolNoe(a, b);
    }

    public void addJmolDistance(int a, int b) {
        this.distances.add(new Double(this.noeMatrix.getJmolDistance(a, b)));
    }

    public double getJmolDistance(int a, int b) {
        return this.noeMatrix.getJmolDistance(a, b);
    }

    class DihedralCouple {
        protected final double[] data;

        DihedralCouple(Atom[] atoms, boolean forNOE) {
            String CHEquation = NmrMolecule.this.nmrPanel.coupleTable.CHequation;
            this.data = NMRCalculation.calc2or3JorNOE(NmrMolecule.this.viewer, atoms, CHEquation, forNOE ? 8 : 7);
        }

        public double getTheta() {
            return this.data[0];
        }

        public double getJvalue() {
            return this.data[1];
        }
    }
}

