/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.messages.events;

import com.sparshui.common.Event;
import com.sparshui.common.Location;
import com.sparshui.common.utils.Converter;

public class ZoomEvent
implements Event {
    private static final long serialVersionUID = -4658011539863774168L;
    private float _scale;
    private Location _center;
    private long _time;

    public ZoomEvent() {
        this._scale = 1.0f;
        this._center = new Location();
    }

    public ZoomEvent(float scale, Location center, long time) {
        this._scale = scale;
        this._center = center;
        this._time = time;
    }

    public float getScale() {
        return this._scale;
    }

    public long getTime() {
        return this._time;
    }

    public Location getCenter() {
        return this._center;
    }

    public void setCenter(Location center) {
        this._center = center;
    }

    public float getX() {
        return this._center.getX();
    }

    public float getY() {
        return this._center.getY();
    }

    public ZoomEvent(byte[] data) {
        if (data.length < 12) {
            System.err.println("Error constructing Zoom Event.");
            this._scale = 1.0f;
            this._center = new Location(0.0f, 0.0f);
        } else {
            this._scale = Converter.byteArrayToFloat(data, 0);
            this._center = new Location(Converter.byteArrayToFloat(data, 4), Converter.byteArrayToFloat(data, 8));
        }
    }

    @Override
    public int getEventType() {
        return 4;
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[16];
        Converter.intToByteArray(data, 0, this.getEventType());
        Converter.floatToByteArray(data, 4, this._scale);
        Converter.floatToByteArray(data, 8, this._center.getX());
        Converter.floatToByteArray(data, 12, this._center.getY());
        return data;
    }

    public String toString() {
        return "ZOOM Scale: " + this._scale + ", Center: " + this._center.toString();
    }
}

