/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AntlrSpec
implements Serializable {
    public static final String PACKAGE_ARG = "-package";
    private List<String> arguments;
    private Set<File> inputDirectories;
    private Set<File> grammarFiles;
    private String maxHeapSize;
    private File outputDirectory;

    public AntlrSpec(List<String> arguments, Set<File> grammarFiles, Set<File> inputDirectories, File outputDirectory, String maxHeapSize) {
        this.arguments = arguments;
        this.inputDirectories = inputDirectories;
        this.grammarFiles = grammarFiles;
        this.outputDirectory = outputDirectory;
        this.maxHeapSize = maxHeapSize;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public Set<File> getGrammarFiles() {
        return this.grammarFiles;
    }

    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public List<String> asArgumentsWithFiles() {
        LinkedList commandLine = Lists.newLinkedList(this.arguments);
        commandLine.add("-o");
        commandLine.add(this.getOutputDirectory().getAbsolutePath());
        for (File file : this.getGrammarFiles()) {
            commandLine.add(file.getAbsolutePath());
        }
        return commandLine;
    }

    public Set<File> getInputDirectories() {
        return this.inputDirectories;
    }
}

