---
stage: Solutions Architecture
group: Solutions Architecture
info: This page is owned by the Solutions Architecture team.
title: Solution Components
---

This documentation section covers a variety of Solution components developed and provided by GitLab.
To download and run these solution components, request your account team for invitation code.

The use of any Solution component is subject to the [GitLab Subscription Agreement](https://handbook.gitlab.com/handbook/legal/subscription-agreement/) (the "Agreement") and constitutes Free Software as defined within the Agreement.

## DevSecOps Workflow

GitLab Solution to provide end to end DevSecOps workflow.

[Mobile Apps](workflow_mobileapps.md)

## Duo Adoption Metrics

GitLab Solution to provide metrics on Duo Adoption.

[Duo Adoption Metrics](duo_adoption_metrics.md)

## Integrated DevSecOps

GitLab Solution to provide an integrated end to end DevSecOps workflow.

[Secure Software Development Workflow Workflow: Snyk SAST](integrated_snyk.md)

[Change Control Workflow: ServiceNow](integrated_servicenow.md)

## By Use Cases

GitLab Solution Packages to provide rules and policies to enforce standards and application security tests.

[Secret detection](secret_detection.md)

[OSS License Check](oss_license_check.md)

## Metrics and KPIs

GitLab Metrics and KPI Dashboard and Solution

[Security Metrics and KPIs Dashboard](securitykpi.md)

Automatically sync Jira incidents to GitLab to unlock DORA metrics tracking. Real-time replication enables Change Failure Rate and Time to Restore Service measurement.

[Jira to GitLab DORA Integration](jira_dora.md)

Automatically sync Jira issues to GitLab to unlock VSA metrics tracking. Real-time replication enables Lead Time, Issues Created, and Issues Closed measurement.

[Jira to GitLab VSA Integration](jira_vsa.md)

## GenAI and Data Science

[Agentic Workflow: Apply Coding Style Guide](duo_workflow/duo_workflow_codestyle.md)

## Compliance and Best Practices

[Guide on Separation of Duties](guide_on_sod.md)
