---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: ファイルディレクトリツリーブラウザーを使用して、リポジトリファイルとディレクトリをナビゲートします。
title: ファイルツリーブラウザー
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 18.0で`repository_file_tree_browser`[フラグ](../../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/19530)されました。デフォルトでは無効になっています。
- GitLab 18.9で[GitLab.com、GitLab Self-Managed、およびGitLab Dedicatedで有効になりました](https://gitlab.com/gitlab-org/gitlab/-/issues/19530)。

{{< /history >}}

> [!flag] この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

ファイルツリーブラウザーは、リポジトリのファイルとディレクトリを折りたたみ可能なツリー構造で表示するドロワーです。これを使用すると、長いファイルリストをスクロールせずにリポジトリ内を移動できます。

ファイルツリーブラウザーは、以下に役立ちます:

- ネストされたディレクトリ構造をナビゲートします。
- リポジトリの階層を表示します。
- ディレクトリ構造のコンテキストを維持しながら、ファイルを切り替えます。

## ファイルツリーブラウザーの表示または非表示 {#show-or-hide-the-file-tree-browser}

ファイルツリーブラウザーを表示または非表示にするには、次の手順に従います:

1. 上部のバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. `/<project>/-/tree/<branch>`にあるリポジトリファイルに移動します。
1. 左上隅で、ファイルツリーブラウザーのアイコン（{{< icon name="file-tree" >}}）を選択します。

<kbd>Shift</kbd>+<kbd>F</kbd>を押して、ファイルツリーブラウザーを切り替えることもできます。

## ファイルとディレクトリのナビゲート {#navigate-files-and-directories}

ファイルツリーブラウザーには、展開および折りたたむことができるファイルとディレクトリを含むリポジトリの構造が表示されます。

ファイルツリーブラウザー内をナビゲートするには、次の手順に従います:

1. ファイルツリーブラウザーを開きます。次のいずれかの操作を行います。

   - 左上隅で、ファイルツリーブラウザーのアイコン（{{< icon name="file-tree" >}}）を選択します。
   - <kbd>Shift</kbd>+<kbd>F</kbd>を押します。

1. ディレクトリを展開するには、ディレクトリ名の横にある{{< icon name="chevron-right" >}}を選択します。
1. ファイルを表示するには、ファイル名を選択します。

ネストされたファイルに直接移動すると、ファイルツリーブラウザーは親ディレクトリを自動的に展開し、現在のファイルを強調表示します。

## ファイルの検索 {#search-files}

グローバル検索を使用して、リポジトリ内のファイルを名前で検索します。

ファイルを検索するには、次の手順に従います:

1. ファイルツリーブラウザーを開きます。次のいずれかの操作を行います。

   - 左上隅で、ファイルツリーブラウザーのアイコン（{{< icon name="file-tree" >}}）を選択します。
   - <kbd>Shift</kbd>+<kbd>F</kbd>を押します。

1. グローバル検索ダイアログを開くには、**ファイルの検索**を選択するか、<kbd>F</kbd>キーを押します。
1. 検索するファイル名の一部を入力します。検索結果リストには、一致するファイルとその親ディレクトリが表示されます。
1. 矢印キーを選択または使用して、<kbd>Enter</kbd>キーを押してファイルに移動します。

検索に一致するファイルがない場合、**結果が見つかりませんでした**と表示されます。

## キーボードショートカット {#keyboard-shortcuts}

ファイルツリーブラウザーは、これらのキーボードショートカットをサポートしています:

| ショートカット                      | アクション |
|-------------------------------|--------|
| <kbd>Shift</kbd>+<kbd>F</kbd> | ファイルツリーブラウザーの表示と非表示を切り替えます。 |
| <kbd>F</kbd>                  | グローバル検索ダイアログを開きます。 |

利用可能なキーボードショートカットの完全なリストについては、[GitLabキーボードショートカット](../../../shortcuts.md)を参照してください。

### ツリーナビゲーション {#tree-navigation}

ファイルツリーブラウザーは、キーボードナビゲーション用に[W3C ARIA treeviewパターン](https://www.w3.org/WAI/ARIA/apg/patterns/treeview/)を実装しています:

| キー                                                  | 機能 |
|------------------------------------------------------|----------|
| <kbd>Enter</kbd>または<kbd>Space</kbd>                 | フォーカスされたファイルまたはディレクトリを選択します |
| <kbd>Down arrow</kbd>                                | ディレクトリを開閉せずに、次のファイルまたはディレクトリにフォーカスを移動します。フォーカスが最後の項目にある場合、何も実行しません。 |
| <kbd>Up arrow</kbd>                                  | ディレクトリを開閉せずに、前のファイルまたはディレクトリにフォーカスを移動します。フォーカスが最初の項目にある場合、何も実行しません。 |
| <kbd>Right arrow</kbd>                               | フォーカスが閉じられたディレクトリにある場合は、それを開きます。フォーカスが開いているディレクトリにある場合は、内部の最初の項目にフォーカスを移動します。フォーカスがファイルにある場合は、何も実行しません。 |
| <kbd>Left arrow</kbd>                                | フォーカスが開いているディレクトリにある場合は、それを閉じます。フォーカスがファイルまたはネストされた項目にある場合は、その親ディレクトリにフォーカスを移動します。フォーカスが閉じられたルートディレクトリにある場合は、何も実行しません。 |
| <kbd>Home</kbd> <sup>1</sup>                                     | ディレクトリを開閉せずに、最初のファイルまたはディレクトリにフォーカスを移動します。 |
| <kbd>End</kbd> <sup>1</sup>                                       | 閉じられたディレクトリを展開せずに、最後のファイルまたはディレクトリにフォーカスを移動します。 |
| <kbd>a</kbd>-<kbd>z</kbd>、<kbd>A</kbd>-<kbd>Z</kbd> | 入力された文字で始まる名前の次のファイルまたはディレクトリにフォーカスを移動します。一致するものが見つからない場合、検索は最初の項目にラップされます。閉じられたディレクトリ内の項目は無視されます。 |
| <kbd>*</kbd>（アスタリスク）                              | フォーカスされた項目と同じレベルですべての閉じられたディレクトリを展開します。フォーカスは移動しません。 |

**脚注**: 

1. <kbd>Home</kbd>キーと<kbd>End</kbd>キーは、一部のキーボードでは使用できない場合があります。

## 関連トピック {#related-topics}

- [Webエディタ](../web_editor.md)
- [Gitファイル履歴](git_history.md)
- [Gitファイルblame](git_blame.md)
