---
stage: AI-powered
group: Workflow Catalog
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: エージェントツール
---

カスタムエージェントは、次のツールを使用できます。

<!-- markdownlint-disable MD044 -->

| 名前 | 説明 |
|-------|-------------|
| Gitlab Blob Search | グループまたはプロジェクト内のファイルの内容を検索します。 |
| CI Lint | CI/CDのYAML設定をCI/CD構文ルールに対して検証します。 |
| Gitコマンドの実行 | 現在の作業ディレクトリでGitコマンドを実行します。 |
| Gitlabコミット検索 | プロジェクトまたはグループ内のコミットを検索します。 |
| エピックの作成 | グループにエピックを作成します。 |
| イシューの作成 | プロジェクトにイシューを作成します。 |
| イシューノートの作成 | イシューにノートを追加します。 |
| マージリクエストの作成 | プロジェクトにマージリクエストを作成します。 |
| マージリクエストノートの作成 | マージリクエストにノートを追加します。クイックアクションはサポートされていません。 |
| ファイルの編集 | 既存のファイルを編集します。 |
| ファイルの検索 | プロジェクト内のファイルを再帰的に検索します。 |
| コミットの取得 | プロジェクトからコミットを取得します。 |
| コミットコメントの取得 | プロジェクト内のコミットのコメントを取得します。 |
| コミットの差分を取得 | プロジェクト内のコミットの差分を取得します。 |
| エピックの取得 | グループ内のエピックを取得します。 |
| エピックノートの取得 | エピックからノートを取得します。 |
| イシューの取得 | プロジェクトからイシューを取得します。 |
| イシューノートの取得 | イシューからノートを取得します。 |
| ジョブログの取得 | ジョブのトレースを取得します。 |
| マージリクエストの取得 | マージリクエストに関する詳細を取得します。 |
| パイプラインのエラーの取得 | マージリクエストの最新パイプラインから、失敗したジョブのログを取得します。 |
| プロジェクトの取得 | プロジェクトに関する詳細を取得します。 |
| リポジトリファイルの取得 | リモートリポジトリからファイルの内容を取得します。 |
| Grep | ファイル内のテキストパターンを再帰的に検索します。このツールは、`.gitignore`ファイルのルールを尊重します。 |
| Gitlabグループプロジェクト検索 | グループ内のプロジェクトを検索します。 |
| Gitlabイシュー検索 | プロジェクトまたはグループ内のイシューを検索します。 |
| すべてのマージリクエストノートをリスト | マージリクエストのすべてのノートをリストします。 |
| コミットの一覧表示 | プロジェクト内のコミットをリストします。 |
| ディレクトリの一覧表示 | プロジェクトのルートを基準としたディレクトリ内のファイルをリストします。 |
| エピックノートの一覧表示 | エピックのすべてのノートをリストします。 |
| エピックの一覧表示 | グループとそのサブグループのすべてのエピックをリストします。 |
| イシューノートの一覧表示 | イシューのすべてのノートをリストします。 |
| イシューの一覧表示 | プロジェクト内のすべてのイシューをリストします。 |
| マージリクエストの差分の一覧表示 | マージリクエストで変更されたファイルの差分をリストします。 |
| Gitlabマージリクエスト検索 | プロジェクトまたはグループ内のマージリクエストを検索します。 |
| Gitlabマイルストーン検索 | プロジェクトまたはグループ内のマイルストーンを検索します。 |
| Mkdir | 現在のワークツリーにディレクトリを作成します。 |
| Gitlabノート検索 | プロジェクト内のノートを検索します。 |
| ファイルの読み取り | ファイルの内容を読み取ります。 |
| コマンドの実行 | 現在の作業ディレクトリでbashコマンドを実行します。Gitコマンドはサポートされていません。 |
| タスクのステータスの設定 | タスクのステータスを設定します。 |
| エピックの更新 | グループ内のエピックを更新します。 |
| イシューの更新 | プロジェクト内のイシューを更新します。 |
| マージリクエストの更新 | マージリクエストを更新します。ターゲットブランチを変更したり、タイトルを編集したり、MRを閉じたりすることもできます。 |
| Gitlabユーザー検索 | プロジェクトまたはグループ内のユーザーを検索します。 |
| Gitlab Wiki Blob検索 | プロジェクトまたはグループ内のWikiの内容を検索します。 |
| コンテンツ付きファイルの作成 | ファイルを作成し、コンテンツを書き込みます。 |
| Gitlabドキュメント検索 | GitLabドキュメントで情報を検索します。 |
| 現在のユーザーを取得 | 現在のユーザーに関する次の情報を取得します: ユーザー名、役職、優先言語。 |
| 新しいタスクを追加 | タスクを追加します。 |
| 脆弱性イシューの作成 | プロジェクト内のセキュリティ脆弱性にリンクされたイシューを作成します。プロジェクトをフルパスで指定する必要があります。例: 「group/subgroup/project」。IDで脆弱性にリンクされたイシューを作成できます。一度に最大100個のIDを指定できます。 |
| ファイルの読み取り | ファイルの内容を読み取ります。 |
| 作業アイテムの取得 | グループまたはプロジェクトから作業アイテムを取得します。`group_id/project_id`と`work_item_iid`、または作業アイテムへのURLのいずれかを指定する必要があります。 |
| 計画の作成 | タスクのリストを作成します。 |
| 計画の取得 | タスクのリストを取得します。 |
| タスクの説明を更新 | タスクの説明を更新します。 |
| 検出された脆弱性に復元 | 脆弱性の状態を`detected`に戻します。復元する理由を説明するオプションのコメントを指定できます。IDで脆弱性を識別する必要があります。 |
| 以前のセッションコンテキストを取得 | 以前のセッションからコンテキストを取得します。 |
| リポジトリツリーの一覧表示 | リポジトリ内のファイルとディレクトリを一覧表示します。プロジェクトを識別するには、`project_id`またはプロジェクトへのURLのいずれかを指定する必要があります。サブディレクトリまたは特定のrefの内容を取得するためのパスを指定できます。 |
| 作業アイテムノートの作成 | 作業アイテムにノートを追加します。クイックアクションはサポートされていません。 |
| タスクの削除 | タスクのリストからタスクを削除します。IDでタスクを指定する必要があります。 |
| 脆弱性の重大度を更新 | プロジェクト内の脆弱性の重大度レベルを更新します。プロジェクトのフルパスを指定する必要があります。更新を説明するオプションのコメントを指定できます。 |
| プロジェクト監査イベントの一覧表示 | プロジェクトの監査イベントをリストします。プロジェクト監査イベントにアクセスするには、オーナーロールが必要です。 |
| グループ監査イベントの一覧表示 | グループの監査イベントをリストします。グループ監査イベントにアクセスするには、オーナーロールが必要です。 |
| 脆弱性をイシューにリンク | プロジェクト内のセキュリティ脆弱性にイシューをリンクします。プロジェクトのフルパスを指定する必要があります。一度に最大100個の脆弱性IDを指定できます。 |
| インスタンス監査イベントの一覧表示 | インスタンスレベルの監査イベントをリストします。インスタンス監査イベントを表示するには、管理者である必要があります。 |
| 脆弱性の詳細の取得 | IDで指定された脆弱性に関する次の情報を取得します: 基本的な脆弱性情報、場所の詳細、CVEエンリッチメントデータ、検出パイプライン情報、詳細な脆弱性レポートデータ。 |
| 脆弱性の無視 | プロジェクト内のセキュリティ脆弱性を無視します。プロジェクトのフルパスを指定する必要があります。無視を説明するオプションのコメントを指定できます。 |
| 脆弱性の確認 | プロジェクト内の脆弱性の状態を`CONFIRMED`に変更します。 |
| 作業アイテムの更新 | グループまたはプロジェクト内の既存の作業アイテムを更新します。クイックアクションはサポートされていません。 |
| 作業アイテムの一覧表示 | プロジェクトまたはグループ内の作業アイテムをリストします。 |
| コミットの作成 | リポジトリ内で複数のファイルアクションを含むコミットを作成します。プロジェクトを識別するには、`project_id`またはプロジェクトへのURLのいずれかを指定する必要があります。アクションには、ファイルのアクセス許可の作成、更新、削除、移動、または変更が含まれます。 |
| 脆弱性の一覧表示 | プロジェクト内のセキュリティ脆弱性をリストします。プロジェクトのフルパスを指定する必要があります。重大度レベルとレポートタイプで脆弱性をフィルタリングできます。 |
| 作業アイテムのノートを取得 | 作業アイテムのすべてのノートを取得します。作業アイテムを識別するには、`group_id/project_id`と`work_item_iid`、または作業アイテムへのURLのいずれかを指定する必要があります。 |
| 作業アイテムの作成 | グループまたはプロジェクトに作業アイテムを作成します。クイックアクションはサポートされていません。 |
| Wikiページの取得 | すべてのコメントを含め、プロジェクトまたはグループからWikiページを取得します。Wikiページのslugと、`project_id`または`group_id`のいずれかを指定する必要があります。 |
| セキュリティ検出結果の詳細を取得 | IDと、それを識別したパイプラインスキャンのIDで、潜在的な脆弱性の詳細を取得します。 |
| Gitlab Api Get | 任意のREST APIエンドポイントに対して、読み取り専用のGETリクエストを行います。直接APIエンドポイントパスとリソースURLの両方をサポートします。 |
| Gitlab Graphql | GraphQL APIに対して、読み取り専用のGraphQLクエリを実行します。 |
| 脆弱性をマージリクエストにリンク | GraphQLを使用して、プロジェクト内のマージリクエストにセキュリティ脆弱性をリンクします。プロジェクトのフルパスを指定する必要があります。このツールは、IDで脆弱性をマージリクエストにリンクすることをサポートしています。マージリクエストIDは、グローバルIDです。 |
| パイプライン失敗ジョブを取得 | パイプラインで失敗したジョブのIDを取得します。特定のパイプラインIDを指定するか、マージリクエストで失敗したすべてのジョブをリクエストできます。 |
| テストの実行 | 任意の言語またはフレームワークのテストコマンドを実行します。 |
| テキストからの行抽出 | テキストから特定の行を抽出します。|
| セキュリティ検出結果の一覧表示 | 特定のパイプラインセキュリティスキャンから、一時的なセキュリティ検出結果をリストします。 |
| レビュービルドマージリクエストコンテキスト | コードレビューのための包括的なマージリクエストコンテキストをビルドします。MRの詳細、AIレビュー可能な差分、およびファイルの内容をフェッチします。 |
| GitlabへのSast Fp分析の投稿 | SASTの誤検出検出分析結果を投稿します。 |
| Duoコードレビューの投稿 | マージリクエストにGitLab Duoコードレビューを投稿します。 |
