---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: エージェント型SAST脆弱性解決
description: GitLab Duoを使用して、SAST脆弱性の自動生成と解決を行います。
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated
- ステータス: ベータ版

{{< /details >}}

{{< history >}}

- [導入](https://gitlab.com/groups/gitlab-org/-/epics/17889)：GitLab 18.9で、`enable_vulnerability_resolution`および`agentic_sast_vr_ui`という[機能フラグ](../../../administration/feature_flags/_index.md)を持つ[ベータ](../../../policy/development_stages_support.md#beta)版として。デフォルトでは無効になっています。

{{< /history >}}

> [!flag] この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

GitLab Duoは、SAST脆弱性を自動的に分析し、コンテキスト認識型のコード修正を含むマージリクエストを生成します。このエージェント型アプローチでは、マルチショット推論を使用して、人間の介入を最小限に抑えながら脆弱性を解決し、修正時間を短縮し、セキュリティの成果を向上させます。

シングルショットの[脆弱性解決](_index.md#vulnerability-resolution)とは異なり、エージェント型の脆弱性解決では、反復的な推論を使用して以下を行います:

- コードベース全体の脆弱性のコンテキストを分析します。
- 根本原因に対処する高品質な修正を生成します。
- 自動テストを通じて修正を検証します。
- 提案されたソリューションの信頼性スコアリングを提供します。

エージェント型のSAST脆弱性解決は自動的に実行することも、手動で実行することもできます。

## 自動解決 {#automatic-resolution}

メインブランチでSASTセキュリティスキャンが完了すると、GitLab Duoは次のアクションを自動的に完了します:

1. 高および重大度の各SAST脆弱性を分析します。
1. 誤検出の検出が実行されたかどうかを確認します。
1. 脆弱性が可能性のある誤検出でない場合、GitLab Duoは提案された修正を含むマージリクエストを作成します。
1. 修正が脆弱性を解決することを検証するためにパイプラインを実行します。

このプロセスはバックグラウンドで実行され、手動でのトリガーは不要です。処理が完了すると、脆弱性レポートに結果が表示されます。

### 手動解決 {#manual-resolution}

重大度に関係なく、既存のSAST脆弱性に対して、いつでもエージェント型の脆弱性解決を手動でトリガーできます。手順については、[手動トリガー](#manual-trigger)を参照してください。

## 自動解決の条件 {#automatic-resolution-conditions}

次のすべての条件が満たされると、自動エージェント型脆弱性解決が実行されます:

- メインブランチでSASTセキュリティスキャンが正常に完了します。
- スキャンで、高または重大度の重大度の脆弱性が検出されます。
- 誤検出の検出が実行され、脆弱性が可能性のある誤検出であると判断されました。
- GitLab Duoの機能がプロジェクトに対して有効になっている。
- 脆弱性は、[サポートされているSASTアナライザー](../sast/analyzers.md)からのものです。

分析はバックグラウンドで行われ、処理が完了すると、脆弱性レポートに結果が表示されます。

## 手動トリガー {#manual-trigger}

既存のSAST脆弱性に対してエージェント型の脆弱性解決を手動で実行するには:

1. 上部のバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **脆弱性レポート**を選択します。
1. 解決する脆弱性を選択します。
1. 右上隅で、**AI vulnerability management** > **AIを使用して解決する**を選択します。

GitLab Duoは脆弱性を分析し、修正を作成できる場合はマージリクエストを生成します。手動による解決は、重大度に関係なく、すべてのSAST脆弱性で機能します。

## 設定 {#configuration}

エージェント型の脆弱性解決を使用するには、次の要件が設定されている必要があります:

- GitLab Duo Enterpriseアドオンサブスクリプション。
- プロジェクトまたはグループで[GitLab Duoを有効にする](../../gitlab_duo/turn_on_off.md)。
- **設定** > **一般** > **GitLab Duo**で、プロジェクトに対して**Use Duo Agentic SAST Vulnerability Resolution**を有効にします。
- GitLab 18.9以降。

追加の設定は必要ありません。この機能は、既存のSASTスキャナーと自動的に連携します。

## 生成されたマージリクエストのレビュー {#reviewing-generated-merge-requests}

GitLab Duoが脆弱性のマージリクエストを生成すると、次のようになります:

1. 提案された修正を含むマージリクエストが作成されます。
1. 説明には以下が含まれます:
   - 脆弱性の詳細と重大度
   - 修正アプローチの説明
   - 関連するセキュリティリソースへのリンク
   - 提案されたソリューションの信頼性スコア
1. 修正を検証するためにパイプラインが自動的に実行されます。
1. レビュアーは、変更とパイプラインの結果をレビューします。
1. マージリクエストをマージする権限を持つユーザーは、ワークフローに従ってそうします。

## トラブルシューティング {#troubleshooting}

エージェント型の脆弱性解決では、提案された修正を生成できない場合があります。一般的な原因は次のとおりです:

- コンテキストが不十分: 脆弱性は、追加のコンテキストまたは手動による介入を必要とする複雑なコードパターンで発生します。
- 誤検出が検出されました: AIモデルは、脆弱性が有効かどうかを評価します。モデルは、脆弱性が真の脆弱性ではない、または修正する価値がないと判断する場合があります。
  - 脆弱性が誤検出であるか、修正する価値がないことに同意する場合は、[脆弱性を無視する](_index.md#change-the-status-of-a-vulnerability)して、[一致する理由を選択](_index.md#vulnerability-dismissal-reasons)する必要があります。
- 一時的または予期しないエラー: エラーメッセージには、`an unexpected error has
  occurred`、`the upstream AI provider request timed out`、`something went wrong`、または同様の原因が記載されている場合があります。
  - これらのエラーは、AIプロバイダーまたはGitLab Duoの一時的な問題が原因である可能性があります。
  - 新しいリクエストが成功する可能性があるため、脆弱性の解決をもう一度試すことができます。
  - これらのエラーが引き続き表示される場合は、GitLabにお問い合わせください。

## フィードバックの提供 {#providing-feedback}

エージェント型の脆弱性解決はベータ機能であり、皆様からのフィードバックをお待ちしております。問題が発生した場合、または改善のための提案がある場合は、[イシュー585626](https://gitlab.com/gitlab-org/gitlab/-/issues/585626)にフィードバックをお寄せください。

## 関連トピック {#related-topics}

- [脆弱性の修正](_index.md#vulnerability-resolution)
- [SASTの誤検出判定](false_positive_detection.md)
- [脆弱性の詳細](_index.md)
- [脆弱性レポート](../vulnerability_report/_index.md)
- [SAST](../sast/_index.md)
- [GitLab Duo](../../gitlab_duo/_index.md)
