---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 強化 - アプリケーションに関する推奨事項
---

一般的な強化ガイドラインについては、[主要な強化ドキュメント](hardening.md)を参照してください。

WebインターフェースからGitLabインスタンスの強化に関する推奨事項を管理できます。

## システムフック {#system-hooks}

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **システムフック**を選択します。

一般的な強化された環境では、内部情報は送信されず、システムの外部に保存されません。オフライン環境システムでは、これは暗黙の了解事項です。トリガーに基づいて、システムフックは、環境内のローカルイベントが環境外の情報を伝達する方法を提供します。

この機能のユースケースはサポートされており、特にリモートシステムを介したシステムのモニタリングです。ただし、システムフックのデプロイには細心の注意を払う必要があります。強化されたシステムの場合、オフライン環境にすることを目的とする場合は、相互に通信できる信頼できるシステムの境界を適用する必要があります。したがって、フック（システム、Web、またはファイル）は、それらの信頼できるシステムとのみ通信する必要があります。システムフックを介した通信には、TLSを強くお勧めします。

## プッシュルール {#push-rules}

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **プッシュルール**を選択します。

次の項目が選択されていることを確認してください:

- **未認証のユーザーを拒否する**
- **`git push`でGitタグを削除することをユーザーに許可しない**
- **コミットの作成者がGitLabのユーザーであるかどうかを確認します**
- **シークレットファイルのプッシュを防止**

この調整は、確立され認証されたユーザーへのプッシュを制限するのに役立ちます。

## デプロイキー {#deploy-keys}

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **デプロイキー**を選択します。

パブリックデプロイキーは、インスタンス上の**すべて**のプロジェクトへの読み取りまたは読み取り/書き込みアクセスを許可するために使用され、プロジェクトにアクセスするためのリモート自動化を目的としています。パブリックデプロイキーは、強化された環境では使用しないでください。デプロイキーを使用する必要がある場合は、プロジェクトデプロイキーの代わりにプロジェクトを使用してください。詳細については、[デプロイキー](../user/project/deploy_keys/_index.md)と[プロジェクトデプロイキー](../user/project/deploy_keys/_index.md#create-a-project-deploy-key)に関するドキュメントを参照してください。

## 一般 {#general}

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。

強化の調整は、4つのセクションで行うことができます。

### 表示レベルとアクセス制御 {#visibility-and-access-control}

次の設定のデフォルトは**プライベート**です:

- **Default project visibility**（デフォルト）のプロジェクト表示レベル
- **Default snippet visibility**（デフォルト）のスニペット表示レベル
- **Default group visibility**（デフォルト）のグループ表示レベル

プロジェクト、スニペット、またはグループへの特定のアクセス権を付与されたユーザーのみが、これらのリソースにアクセスできます。これは、必要に応じて後で、または作成時に調整できます。これは、偶発的または悪意のある情報の開示を防ぐのに役立ちます。

セキュリティポリシーとポスチャによっては、認証されていないユーザーがユーザープロファイルを閲覧できないように、**Restricted visibility level**（制限付き）の表示レベルを**公開**に設定することをお勧めします。

**ソースをインポート**では、本当に必要なソースのみを選択します。

一般的なデプロイでは、**有効なGitアクセスプロトコル**が**SSHとHTTP(S)の両方**に設定されていますが、Gitプロトコルのいずれかがユーザーで使用されていない場合は、それに応じて**SSHのみ**または**HTTP(S)のみ**に設定します。これにより、アタックサーフェスが縮小されます。

SSHキーのタイプでは、次のものが推奨されます。`ED25519`（および`ED25519-SK`）、`RSA`、および`ECDSA`（および`ECDSA-SK`）の順に推奨されます。`ED25519`は、`RSA`が2048ビット以上に設定されている場合、`RSA`と同程度に安全であると考えられていますが、`ED25519`キーは小さく、アルゴリズムははるかに高速です。

`ED25519-SK`と`ECDSA-SK`はどちらも「セキュリティキー」を表す`-SK`で終わります。これらの`-SK`タイプは、FIDO/U2F標準と互換性があり、ハードウェアトークン（YubiKeyなど）での使用に関連しています。

`DSA`は「禁止」に設定する必要があります。`DSA`には既知の欠陥があり、多くの暗号研究者は`ECDSA`の使用を疑っており、サポートしていません。

GitLabがFIPSモードの場合、以下を使用します:

- FIPSモードで実行している場合:
  - `RSA`を使用し、**Must be at least 2048 bits**（少なくとも2048ビット）に設定します。
  - `ECDSA`（および`ECDSA-SK`）を使用し、**Must be at least 256 bits**（少なくとも256ビット）に設定します。
  - 他のすべてのキーのタイプを**Are forbidden**（禁止）に設定します。`RSA`と`ECDSA`はどちらもFIPSでの使用が承認されています。
- FIPSモードで実行していない場合は、`ED25519`を使用する必要があり、`RSA`も使用できます:
  - `ED25519`（および`ED25519-SK`）を**Must be at least 256 bits**（少なくとも256ビット）に設定します。
  - `RSA`を使用している場合は、**Must be at least 2048 bits**（少なくとも2048ビット）に設定します。
  - 他のすべてのキーのタイプを**Are forbidden**（禁止）に設定します。
- 新しいユーザーグループのインスタンスをセットアップする場合は、セキュリティを強化するために、ユーザーSSHキーポリシーを最大ビット数で定義します。

強化された環境では、RSSフィードは通常必要ありません。**フィードトークン**で、**Disabled feed token**（フィードトークンを無効にする）チェックボックスを選択します。

すべてのユーザーが特定のIPアドレスからアクセスしている場合は、**Global-allowed IP ranges**（グローバル許可IP範囲）を使用して、それらのアドレスのみを明示的に許可します。

**Visibility and access control**（表示レベルとアクセス制御）の詳細については、[表示レベルとアクセス制御](../administration/settings/visibility_and_access_controls.md)を参照してください。SSH設定の詳細については、[SSHキーの制限](ssh_keys_restrictions.md)を参照してください。

### アカウントと制限 {#account-and-limit}

強化を目的とする場合は、**Gravatarを有効化**の横にあるチェックボックスが選択されていないことを確認してください。すべての無関係な通信を削減する必要があり、一部の環境では制限される場合があります。アカウントアバターは、ユーザーが手動でアップロードできます。

このセクションの設定は、ユーザーに対する独自の特定の標準のカスタム実装を強制するのに役立つことを目的としています。さまざまなシナリオが非常に多く、多岐にわたるため、[アカウントと制限設定に関するドキュメント](../administration/settings/account_and_limit_settings.md)を確認し、変更を適用して独自のポリシーを適用する必要があります。

### サインアップの制限 {#sign-up-restrictions}

強化されたインスタンスでオープンサインアップが無効になっていることを確認してください。**サインアップは有効です**チェックボックスが選択されていないことを確認してください。

**メールの確認設定**で、**ハード**が選択されていることを確認します。アクセス権が付与される前に、メールアドレスのユーザー確認が強制されるようになりました。

**パスワードの最小文字数**デフォルト設定は12で、追加の認証手法が使用されている限り問題ありません。パスワードは複雑である必要があるため、次の4つのチェックボックスがすべて選択されていることを確認してください:

- **数字が必要**
- **大文字が必要**
- **小文字が必要**
- **記号が必要**

すべてのユーザーが、メールアドレスに特定のドメインを使用する同じ組織に属している場合は、**サインアップに許可されたドメイン**にそのドメインをリストします。これにより、他のドメインのメールアドレスを持つユーザーがサインアップできなくなります。

詳細については、[サインアップ制限](../administration/settings/sign_up_restrictions.md)を参照してください。

### サインインの制限 {#sign-in-restrictions}

2要素認証（2FA）は、すべてのユーザーに対して有効にする必要があります。**2要素認証**（2FA）の横にあるチェックボックスが選択されていることを確認してください。

**2要素認証の猶予期間**の猶予期間のデフォルト設定は48時間です。これは、8時間など、はるかに低い値に調整する必要があります。

**管理者モードを有効にする**の横にあるチェックボックスが選択されていることを確認して、**管理者モード**がアクティブになるようにします。これにより、管理者アクセス権を持つユーザーは、管理タスクを実行するために追加の認証を使用する必要があり、ユーザーによる追加の2FAを強制します。

**不明なサインインのメール通知**で、**メール通知を有効化**が選択されていることを確認します。これにより、認識されていない場所からサインインが発生すると、ユーザーにメールが送信されます。

詳細については、[サインイン制限](../administration/settings/sign_in_restrictions.md)を参照してください。

## インテグレーション {#integrations}

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **インテグレーション**を選択します。

一般に、管理者がユースケースを制御およびモニタリングしている限り、強化された環境ではインテグレーションは問題ありません。ローカルプロセスまたは認証されたユーザーが実行した場合に制限または監査するアクセスレベルを通常必要とするアクションとプロセスをトリガーする、外部システムからのアクションを許可するインテグレーションについては注意してください。

## メトリクスとプロファイリング {#metrics-and-profiling}

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **メトリクスとプロファイリング**を選択します。

強化のための主な焦点は**使用状況の統計**です:

- **バージョンチェックを有効にする**が選択されていることを確認する必要があります。これにより、最新バージョンのGitLabを実行しているかどうかが確認されます。新しい機能とセキュリティパッチを備えた新しいバージョンが頻繁にリリースされるため、最新の状態に保つことができます。

- 環境が隔離されている場合、または組織の要件により、ソフトウェアベンダーへのデータ収集と統計レポートが制限されている場合は、**Enable service ping**（Service Ping）機能をオフにする必要がある場合があります。

## ネットワーク {#network}

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **ネットワーク**を選択します。

レート制限を有効にする設定については、必ず選択されていることを確認してください。デフォルト値で問題ありません。さらに、アクセスを有効にする設定が多数あり、これらはすべてクリアする必要があります。

これらの調整を行った後、パフォーマンスとユーザーのニーズに合わせてシステムを微調整できます。これには、レート制限の無効化と調整、またはアクセスの有効化が必要になる場合があります。留意すべき注目すべき点を次に示します:

- **アウトバウンドリクエスト**で、限られた数のシステムへのアクセスを開く必要がある場合は、IPアドレスまたはホスト名を指定して、それらのシステムへのアクセスのみを制限できます。また、このセクションでは、アクセスを許可する場合は、**Enforce DNS rebinding attack protection**（DNSリバインディング攻撃保護を適用する）を選択したことを確認してください。

- **Notes rate limit**（メモのレート制限）と**Users API rate limit**（ユーザーAPIレート制限）では、必要に応じて、これらの制限から特定のユーザーを除外することができます。
