---
stage: GitLab Dedicated
group: Environment Automation
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLab Dedicatedの認証済みユーザーのレート制限、リファレンスアーキテクチャごとのデフォルトの制限、および処理戦略。
title: 認証済みユーザーレート制限
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Dedicated

{{< /details >}}

GitLab Dedicatedは、システムの安定性を確保し、インスタンス上のすべてのユーザーのパフォーマンスを維持するために、認証済みユーザーのレート制限を自動的に適用します。レート制限により、単一のユーザーまたはサービスアカウントが過剰なアラートを生成したり、インスタンスの広範囲な低下を引き起こしたりすることを防ぎます。

ユーザーがレート制限を超えると、GitLabは`429 Too Many Requests` HTTPステータスコードを返し、`Retry later`というプレーンテキストのレスポンスを返します。

レート制限は、GitLabによって自動的に構成および管理されます。次の操作はできません:

- レート制限の値を変更する。
- レート制限を無効にする。
- 管理者エリアからカスタムレート制限を構成する。
- UIでレート制限の設定にアクセスする。

GitLabは、インスタンスの最適なパフォーマンスと安定性を確保するために、これらの設定を管理します。

詳細については、[レート制限](../../security/rate_limits.md)を参照してください。

## リクエストタイプ別のレート制限 {#rate-limits-by-request-type}

レート制限は、一般ユーザーやサービスアカウントを含むすべての認証済みユーザーに適用されます。GitLabは、リファレンスアーキテクチャのサイズに基づいて、これらの制限を自動的に設定します。制限は、APIとWebリクエストに個別に適用されます:

- APIリクエスト: インテグレーション、CI/CDジョブ、および自動化スクリプトからのリクエストを含む、RESTおよびGraphQL APIコール。
- Webリクエスト: GitLab UIを介して行われたリクエスト。

| リファレンスアーキテクチャ | 1分あたりのAPIリクエスト | 1分あたりのWebリクエスト |
| ---------------------- | ----------------------- | ----------------------- |
| 1,000ユーザー            | 1,200                   | 120                     |
| 2,000ユーザー            | 2,400                   | 240                     |
| 3,000ユーザー            | 3,600                   | 360                     |
| 5,000ユーザー            | 6,000                   | 600                     |
| 10,000ユーザー           | 12,000                  | 1,200                   |
| 25,000ユーザー           | 30,000                  | 3,000                   |
| 50,000ユーザー           | 60,000                  | 6,000                   |

詳細については、[リファレンスアーキテクチャ](../reference_architectures/_index.md)を参照してください。

## レスポンスヘッダー {#response-headers}

GitLabには、すべてのリクエストのレスポンスヘッダーにレート制限情報が含まれています。これらのヘッダーを使用して、現在の使用量と残りのクォータを監視できます。

どのレート制限にレスポンスヘッダーと利用可能なヘッダーが含まれるかの詳細については、[複数のレート制限システム](../../administration/settings/user_and_ip_rate_limits.md#multiple-rate-limiting-systems)を参照してください。

## リクエストの効率性を改善する {#improve-request-efficiency}

レート制限をより効果的に利用するには:

1. リクエストパターンを最適化します:

   - 自動化されたスクリプトでリクエスト間に遅延を追加します。
   - 可能な場合は、APIリクエストを結合します。
   - GraphQLを使用して、必要なデータのみをフェッチします。
   - 大規模なデータセットに効率性の高いページネーションを実装します。

1. 大量使用の監査と最適化:

   - ほとんどのリクエストを行うユーザーまたはサービスアカウントをレビューします。
   - 過剰なAPIコールを行うCI/CDジョブをレビューします。
   - GitLabインスタンスに接続するインテグレーションをレビューします。
   - 自動化されたプロセスを更新して、レート制限のしきい値を下回るようにします。
