# frozen_string_literal: true

class QueueBackfillOccurrenceIdToVulnerabilityRepresentationInformation < Gitlab::Database::Migration[2.3]
  milestone '18.8'

  restrict_gitlab_migration gitlab_schema: :gitlab_sec

  MIGRATION = "BackfillOccurrenceIdToVulnerabilityRepresentationInformation"

  def up
    queue_batched_background_migration(
      MIGRATION,
      :vulnerability_representation_information,
      :vulnerability_id
    )
  end

  def down
    delete_batched_background_migration(MIGRATION, :vulnerability_representation_information, :vulnerability_id, [])
  end
end
