/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.webserver;

import fi.iki.elonen.NanoHTTPD;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.webserver.ContextHandler;
import org.fibs.geotag.webserver.WebServer;

public class ImageInfoHandler
implements ContextHandler {
    @Override
    public NanoHTTPD.Response serve(WebServer server, String uri, String method, Properties header, Properties parms) {
        int[] imageIDs = null;
        Enumeration<Object> parameters = parms.keys();
        while (parameters.hasMoreElements()) {
            String parameter = (String)parameters.nextElement();
            String value = parms.getProperty(parameter);
            if (!parameter.equals("ids")) continue;
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            imageIDs = new int[tokenizer.countTokens()];
            int index = 0;
            while (index < imageIDs.length) {
                imageIDs[index] = Integer.parseInt(tokenizer.nextToken());
                ++index;
            }
        }
        if (imageIDs != null) {
            return server.xmlResponse(this.imageInfoToXml(imageIDs));
        }
        WebServer webServer = server;
        webServer.getClass();
        return (NanoHTTPD)webServer.new NanoHTTPD.Response("404 Not Found", "text/plain", WebServer.FILE_NOT_FOUND);
    }

    private String imageInfoToXml(int[] imageIDs) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<images>\n");
        int index = 0;
        while (index < imageIDs.length) {
            ImageInfo imageInfo = ImageInfo.getImageInfo(imageIDs[index]);
            if (imageInfo != null) {
                stringBuilder.append(" <image id=\"" + imageInfo.getSequenceNumber() + "\"");
                stringBuilder.append(" name=\"" + imageInfo.getName() + "\"");
                int width = 0;
                int height = 0;
                ImageIcon thumbnail = imageInfo.getThumbnail();
                if (thumbnail != null) {
                    width = thumbnail.getIconWidth();
                    height = thumbnail.getIconHeight();
                }
                stringBuilder.append(" width=\"" + width + "\"");
                stringBuilder.append(" height=\"" + height + "\"");
                String latitude = Double.toString(51.477222222222224);
                String longitude = Double.toString(0.0);
                latitude = Settings.get(Settings.SETTING.LAST_GOOGLE_MAPS_LATITUDE, latitude);
                longitude = Settings.get(Settings.SETTING.LAST_GOOGLE_MAPS_LONGITUDE, longitude);
                if (imageInfo.getGpsLatitude() != null && imageInfo.getGpsLongitude() != null) {
                    latitude = imageInfo.getGpsLatitude();
                    longitude = imageInfo.getGpsLongitude();
                }
                stringBuilder.append(" latitude=\"" + latitude + "\"");
                stringBuilder.append(" longitude=\"" + longitude + "\"");
                String direction = "-1.0";
                if (imageInfo.getGpsImgDirection() != null) {
                    direction = imageInfo.getGpsImgDirection();
                }
                stringBuilder.append(" direction=\"" + direction + "\"");
                stringBuilder.append(" />\n");
            }
            ++index;
        }
        stringBuilder.append("</images>");
        return stringBuilder.toString();
    }
}

