﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/LaunchTemplate.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/ValidationWarning.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class CreateLaunchTemplateResponse {
 public:
  AWS_EC2_API CreateLaunchTemplateResponse() = default;
  AWS_EC2_API CreateLaunchTemplateResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API CreateLaunchTemplateResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Information about the launch template.</p>
   */
  inline const LaunchTemplate& GetLaunchTemplate() const { return m_launchTemplate; }
  template <typename LaunchTemplateT = LaunchTemplate>
  void SetLaunchTemplate(LaunchTemplateT&& value) {
    m_launchTemplateHasBeenSet = true;
    m_launchTemplate = std::forward<LaunchTemplateT>(value);
  }
  template <typename LaunchTemplateT = LaunchTemplate>
  CreateLaunchTemplateResponse& WithLaunchTemplate(LaunchTemplateT&& value) {
    SetLaunchTemplate(std::forward<LaunchTemplateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the launch template contains parameters or parameter combinations that are
   * not valid, an error code and an error message are returned for each issue that's
   * found.</p>
   */
  inline const ValidationWarning& GetWarning() const { return m_warning; }
  template <typename WarningT = ValidationWarning>
  void SetWarning(WarningT&& value) {
    m_warningHasBeenSet = true;
    m_warning = std::forward<WarningT>(value);
  }
  template <typename WarningT = ValidationWarning>
  CreateLaunchTemplateResponse& WithWarning(WarningT&& value) {
    SetWarning(std::forward<WarningT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  CreateLaunchTemplateResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  LaunchTemplate m_launchTemplate;
  bool m_launchTemplateHasBeenSet = false;

  ValidationWarning m_warning;
  bool m_warningHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
