/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.paths;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.regex.Pattern;
import xsbt.boot.internal.shaded.coursier.jniutils.WindowsEnvironmentVariables;

public class Util {
    private static final Pattern propertyRegex = Pattern.compile(Pattern.quote("${") + "[^" + Pattern.quote("{[()]}") + "]*" + Pattern.quote("}"));
    private static volatile Boolean useColorOutput0 = null;
    private static volatile Boolean useAnsiOutput0 = null;
    private static Boolean useJni0 = null;

    public static void createDirectories(Path path) throws IOException {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            return;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw fileAlreadyExistsException;
            }
            return;
        }
    }

    public static boolean useJni() {
        return Util.useJni(() -> {});
    }

    public static boolean useJni(Runnable runnable) {
        boolean bl;
        if (useJni0 != null) {
            return useJni0;
        }
        boolean bl2 = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
        if (!bl2) {
            useJni0 = Boolean.FALSE;
            return useJni0;
        }
        String string = System.getenv("COURSIER_JNI");
        if (string == null || string.isEmpty()) {
            string = System.getProperty("xsbt.boot.internal.shaded.coursier.jni", "");
        }
        if (bl = string.equalsIgnoreCase("force")) {
            runnable.run();
            useJni0 = Boolean.TRUE;
            return useJni0;
        }
        boolean bl3 = string.equalsIgnoreCase("false");
        if (bl3) {
            useJni0 = Boolean.FALSE;
            return useJni0;
        }
        try {
            runnable.run();
            WindowsEnvironmentVariables.get("PATH");
            useJni0 = Boolean.TRUE;
        }
        catch (Throwable throwable) {
            if (System.getProperty("xsbt.boot.internal.shaded.coursier.jni.check.throw", "").equalsIgnoreCase("true")) {
                throw new RuntimeException(throwable);
            }
            useJni0 = Boolean.FALSE;
        }
        return useJni0;
    }
}

