/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.collection.Hashing$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.HashCollisionSetNode;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.SetNode;
import scala.collection.immutable.SetNode$;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class BitmapIndexedSetNode<A>
extends SetNode<A> {
    private int dataMap;
    private int nodeMap;
    private Object[] content;
    private int[] originalHashes;
    private int size;
    private int cachedJavaKeySetHashCode;

    public final int dataMap() {
        return this.dataMap;
    }

    /*
     * WARNING - void declaration
     */
    public final void dataMap_$eq(int x$1) {
        void var1_1;
        this.dataMap = var1_1;
    }

    public final int nodeMap() {
        return this.nodeMap;
    }

    /*
     * WARNING - void declaration
     */
    public final void nodeMap_$eq(int x$1) {
        void var1_1;
        this.nodeMap = var1_1;
    }

    public final Object[] content() {
        return this.content;
    }

    /*
     * WARNING - void declaration
     */
    public final void content_$eq(Object[] x$1) {
        void var1_1;
        this.content = var1_1;
    }

    public final int[] originalHashes() {
        return this.originalHashes;
    }

    /*
     * WARNING - void declaration
     */
    public final void originalHashes_$eq(int[] x$1) {
        void var1_1;
        this.originalHashes = var1_1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final void size_$eq(int x$1) {
        void var1_1;
        this.size = var1_1;
    }

    @Override
    public final int cachedJavaKeySetHashCode() {
        return this.cachedJavaKeySetHashCode;
    }

    /*
     * WARNING - void declaration
     */
    public final void cachedJavaKeySetHashCode_$eq(int x$1) {
        void var1_1;
        this.cachedJavaKeySetHashCode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final A getPayload(int index) {
        void var1_1;
        return (A)this.content()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getHash(int index) {
        void var1_1;
        return this.originalHashes()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SetNode<A> getNode(int index) {
        void var1_1;
        return (SetNode)this.content()[this.content().length - 1 - var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(A element, int originalHash, int elementHash, int shift) {
        void var3_3;
        int mask = elementHash >>> shift & 0x1F;
        int bitpos = 1 << mask;
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            return this.originalHashes()[index] == originalHash && BoxesRunTime.equals(element, this.content()[var3_3]);
        }
        if ((this.nodeMap() & bitpos) != 0) {
            void var2_2;
            void var1_1;
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            return ((SetNode)this.getNode(index)).contains(var1_1, (int)var2_2, (int)var3_3, shift + 5);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitmapIndexedSetNode<A> updated(A element, int originalHash, int elementHash, int shift) {
        void var3_3;
        void var2_2;
        void var1_1;
        SetNode<Object> subNodeNew;
        int element0UnimprovedHash;
        int index;
        int mask = elementHash >>> shift & 0x1F;
        int bitpos = 1 << mask;
        if ((this.dataMap() & bitpos) != 0) {
            index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            Object element0 = this.content()[index];
            if (element0 == element) {
                return this;
            }
            element0UnimprovedHash = this.originalHashes()[index];
            int element0Hash = Hashing$.MODULE$.improve(element0UnimprovedHash);
            if (originalHash == element0UnimprovedHash && BoxesRunTime.equals(element0, element)) {
                return this;
            }
            subNodeNew = this.mergeTwoKeyValPairs(element0, element0UnimprovedHash, element0Hash, element, originalHash, elementHash, shift + 5);
            return this.copyAndMigrateFromInlineToNode(bitpos, element0Hash, subNodeNew);
        }
        if ((this.nodeMap() & bitpos) != 0) {
            index = Node$.MODULE$.indexFrom(this.nodeMap(), element0UnimprovedHash, bitpos);
            Node subNode = this.getNode(index);
            if (subNode == (subNodeNew = ((SetNode)subNode).updated(subNodeNew, originalHash, elementHash, shift + 5))) {
                return this;
            }
            return this.copyAndSetNode(bitpos, (SetNode<A>)subNode, (SetNode<A>)var1_1);
        }
        return this.copyAndInsertValue(bitpos, var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * Unable to fully structure code
     */
    public final int updateWithShallowMutations(A element, int originalHash, int elementHash, int shift, int shallowlyMutableNodeMap) {
        block5: {
            mask = elementHash >>> shift & 31;
            bitpos = 1 << mask;
            if ((this.dataMap() & bitpos) != 0) {
                index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
                element0 = this.content()[index];
                element0UnimprovedHash = this.originalHashes()[index];
                if (element0UnimprovedHash == originalHash && BoxesRunTime.equals(element0, element)) {
                    return shallowlyMutableNodeMap;
                }
                element0Hash = Hashing$.MODULE$.improve(element0UnimprovedHash);
                subNodeNew = this.mergeTwoKeyValPairs(element0, element0UnimprovedHash, element0Hash, element, originalHash, elementHash, shift + 5);
                this.migrateFromInlineToNodeInPlace(bitpos, element0Hash, subNodeNew);
                return shallowlyMutableNodeMap | bitpos;
            }
            if ((this.nodeMap() & bitpos) == 0) break block5;
            index = Node$.MODULE$.indexFrom(this.nodeMap(), element0UnimprovedHash, bitpos);
            subNode = this.getNode(index);
            subNodeSize = subNode.size();
            subNodeCachedJavaKeySetHashCode = subNode.cachedJavaKeySetHashCode();
            returnNodeMap = shallowlyMutableNodeMap;
            if (!(subNode instanceof BitmapIndexedSetNode)) ** GOTO lbl-1000
            var11_16 = (BitmapIndexedSetNode)subNode;
            if ((bitpos & shallowlyMutableNodeMap) != 0) {
                var11_16.updateWithShallowMutations(subNodeNew, originalHash, elementHash, shift + 5, 0);
                v0 = var11_16;
            } else lbl-1000:
            // 2 sources

            {
                if ((subNodeNew = subNode.updated(subNodeNew, originalHash, elementHash, shift + 5)) != subNode) {
                    returnNodeMap = shallowlyMutableNodeMap | bitpos;
                }
                v0 = subNodeNew;
            }
            subNodeNew = v0;
            this.content()[this.content().length - 1 - this.nodeIndex((int)bitpos)] = subNodeNew;
            v1 = this;
            v1.size_$eq(v1.size() - subNodeSize + subNodeNew.size());
            v2 = this;
            v2.cachedJavaKeySetHashCode_$eq(v2.cachedJavaKeySetHashCode() - subNodeCachedJavaKeySetHashCode + subNodeNew.cachedJavaKeySetHashCode());
            return returnNodeMap;
        }
        dataIx = this.dataIndex(bitpos);
        src = this.content();
        dst = new Object[src.length + 1];
        System.arraycopy(src, 0, dst, 0, dataIx);
        dst[dataIx] = subNodeNew;
        System.arraycopy(src, dataIx, dst, dataIx + 1, src.length - dataIx);
        v3 = this;
        dstHashes = v3.insertElement(v3.originalHashes(), dataIx, (int)var2_2);
        v4 = this;
        v4.dataMap_$eq(v4.dataMap() | bitpos);
        this.content_$eq(dst);
        this.originalHashes_$eq((int[])var1_1);
        v5 = this;
        v5.size_$eq(v5.size() + 1);
        v6 = this;
        v6.cachedJavaKeySetHashCode_$eq(v6.cachedJavaKeySetHashCode() + var3_3);
        return shallowlyMutableNodeMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitmapIndexedSetNode<A> removed(A element, int originalHash, int elementHash, int shift) {
        int n;
        int mask = elementHash >>> shift & 0x1F;
        int bitpos = 1 << mask;
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            if (BoxesRunTime.equals(this.content()[index], element)) {
                if (this.payloadArity() == 2 && this.nodeArity() == 0) {
                    int newDataMap;
                    int n2;
                    if (shift == 0) {
                        n2 = this.dataMap() ^ bitpos;
                    } else {
                        int bitposFrom_mask = elementHash & 0x1F;
                        n2 = newDataMap = 1 << bitposFrom_mask;
                    }
                    if (n == 0) {
                        return new BitmapIndexedSetNode<A>(newDataMap, 0, new Object[]{this.content()[1]}, new int[]{this.originalHashes()[1]}, this.size() - 1, Hashing$.MODULE$.improve(this.originalHashes()[1]));
                    }
                    return new BitmapIndexedSetNode<A>(newDataMap, 0, new Object[]{this.content()[0]}, new int[]{this.originalHashes()[0]}, this.size() - 1, Hashing$.MODULE$.improve(this.originalHashes()[0]));
                }
                return this.copyAndRemoveValue(bitpos, elementHash);
            }
            return this;
        }
        if ((this.nodeMap() & bitpos) != 0) {
            void newDataMap;
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            Node subNode = this.getNode(index);
            SetNode<void> subNodeNew = ((SetNode)subNode).removed(newDataMap, n, elementHash, shift + 5);
            if (subNodeNew == subNode) {
                return this;
            }
            n = subNodeNew.size();
            switch (n) {
                case 1: {
                    void var3_4;
                    if (this.size() == ((SetNode)subNode).size()) {
                        return (BitmapIndexedSetNode)subNodeNew;
                    }
                    return this.copyAndMigrateFromNodeToInline(bitpos, (int)var3_4, (SetNode<A>)subNode, subNodeNew);
                }
            }
            if (n > 1) {
                void var1_1;
                return this.copyAndSetNode(bitpos, (SetNode<A>)subNode, (SetNode<A>)var1_1);
            }
            return this;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final BitmapIndexedSetNode<A> removeWithShallowMutations(A element, int originalHash, int elementHash) {
        void var3_8;
        void var2_5;
        int mask = elementHash & 0x1F;
        int bitpos = 1 << mask;
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            if (BoxesRunTime.equals(this.content()[index], element)) {
                if (this.payloadArity() == 2 && this.nodeArity() == 0) {
                    int newCachedJavaKeySetHashCode;
                    int newDataMap = this.dataMap() ^ bitpos;
                    if (index == 0) {
                        Object[] newContent = new Object[]{this.content()[1]};
                        int[] newOriginalHashes = new int[]{this.originalHashes()[1]};
                        newCachedJavaKeySetHashCode = Hashing$.MODULE$.improve(this.originalHashes()[1]);
                        this.content_$eq(newContent);
                        this.originalHashes_$eq(newOriginalHashes);
                        this.cachedJavaKeySetHashCode_$eq(newCachedJavaKeySetHashCode);
                    } else {
                        void var3_10;
                        Object[] newContent = new Object[]{this.content()[0]};
                        int[] newOriginalHashes = new int[]{this.originalHashes()[0]};
                        newCachedJavaKeySetHashCode = Hashing$.MODULE$.improve(this.originalHashes()[0]);
                        this.content_$eq(newContent);
                        this.originalHashes_$eq((int[])var3_10);
                        this.cachedJavaKeySetHashCode_$eq(newCachedJavaKeySetHashCode);
                    }
                    this.dataMap_$eq(newDataMap);
                    this.nodeMap_$eq(0);
                    this.size_$eq(1);
                    return this;
                }
                int dataIx = this.dataIndex(bitpos);
                int idx = 1 * dataIx;
                Object[] src = this.content();
                Object[] dst = new Object[src.length - 1];
                System.arraycopy(src, 0, dst, 0, idx);
                System.arraycopy(src, idx + 1, dst, idx, src.length - var2_5 - 1);
                BitmapIndexedSetNode bitmapIndexedSetNode = this;
                int[] dstHashes = bitmapIndexedSetNode.removeElement(bitmapIndexedSetNode.originalHashes(), dataIx);
                BitmapIndexedSetNode bitmapIndexedSetNode2 = this;
                bitmapIndexedSetNode2.dataMap_$eq(bitmapIndexedSetNode2.dataMap() ^ bitpos);
                this.content_$eq(dst);
                this.originalHashes_$eq(dstHashes);
                BitmapIndexedSetNode bitmapIndexedSetNode3 = this;
                bitmapIndexedSetNode3.size_$eq(bitmapIndexedSetNode3.size() - 1);
                BitmapIndexedSetNode bitmapIndexedSetNode4 = this;
                bitmapIndexedSetNode4.cachedJavaKeySetHashCode_$eq(bitmapIndexedSetNode4.cachedJavaKeySetHashCode() - var3_8);
                return this;
            }
            return this;
        }
        if ((this.nodeMap() & bitpos) != 0) {
            void var1_1;
            void dstHashes;
            void src;
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), (int)src, bitpos);
            Node subNode = this.getNode(index);
            BitmapIndexedSetNode subNodeNew = (BitmapIndexedSetNode)((SetNode)subNode).removed(dstHashes, (int)var2_5, (int)var3_8, 5);
            if (subNodeNew == subNode) {
                return this;
            }
            if (subNodeNew.size() == 1) {
                if (this.payloadArity() == 0 && this.nodeArity() == 1) {
                    this.dataMap_$eq(subNodeNew.dataMap());
                    this.nodeMap_$eq(subNodeNew.nodeMap());
                    this.content_$eq(subNodeNew.content());
                    this.originalHashes_$eq(subNodeNew.originalHashes());
                    this.size_$eq(subNodeNew.size());
                    this.cachedJavaKeySetHashCode_$eq(subNodeNew.cachedJavaKeySetHashCode());
                    return this;
                }
                this.migrateFromNodeToInlineInPlace(bitpos, (int)var2_5, (int)var3_8, (SetNode<A>)subNode, subNodeNew);
                return this;
            }
            this.content()[this.content().length - 1 - this.nodeIndex((int)bitpos)] = subNodeNew;
            BitmapIndexedSetNode bitmapIndexedSetNode = this;
            bitmapIndexedSetNode.size_$eq(bitmapIndexedSetNode.size() - 1);
            BitmapIndexedSetNode bitmapIndexedSetNode5 = this;
            bitmapIndexedSetNode5.cachedJavaKeySetHashCode_$eq(bitmapIndexedSetNode5.cachedJavaKeySetHashCode() - subNode.cachedJavaKeySetHashCode() + var1_1.cachedJavaKeySetHashCode());
            return this;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SetNode<A> mergeTwoKeyValPairs(A key0, int originalKeyHash0, int keyHash0, A key1, int originalKeyHash1, int keyHash1, int shift) {
        void var1_1;
        void var7_7;
        void var2_2;
        void var3_3;
        if (shift >= 32) {
            return new HashCollisionSetNode(originalKeyHash0, keyHash0, Vector$.MODULE$.from((IterableOnce)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{key0, key1})));
        }
        int mask0 = keyHash0 >>> shift & 0x1F;
        int mask1 = keyHash1 >>> shift & 0x1F;
        if (mask0 != mask1) {
            int dataMap = 1 << mask0 | 1 << mask1;
            int newCachedHashCode = keyHash0 + keyHash1;
            if (mask0 < mask1) {
                return new BitmapIndexedSetNode<A>(dataMap, 0, new Object[]{key0, key1}, new int[]{originalKeyHash0, originalKeyHash1}, 2, newCachedHashCode);
            }
            return new BitmapIndexedSetNode<A>(dataMap, 0, new Object[]{key1, key0}, new int[]{originalKeyHash1, originalKeyHash0}, 2, (int)var3_3);
        }
        int nodeMap = 1 << mask0;
        SetNode<A> node = this.mergeTwoKeyValPairs(key0, (int)var2_2, (int)var3_3, key1, originalKeyHash1, keyHash1, (int)(var7_7 + 5));
        return new BitmapIndexedSetNode<A>(0, nodeMap, new Object[]{node}, Array$.MODULE$.emptyIntArray(), node.size(), var1_1.cachedJavaKeySetHashCode());
    }

    @Override
    public final boolean hasPayload() {
        return this.dataMap() != 0;
    }

    @Override
    public final int payloadArity() {
        return Integer.bitCount(this.dataMap());
    }

    @Override
    public final boolean hasNodes() {
        return this.nodeMap() != 0;
    }

    @Override
    public final int nodeArity() {
        return Integer.bitCount(this.nodeMap());
    }

    /*
     * WARNING - void declaration
     */
    public final int dataIndex(int bitpos) {
        void var1_1;
        return Integer.bitCount(this.dataMap() & var1_1 - true);
    }

    /*
     * WARNING - void declaration
     */
    public final int nodeIndex(int bitpos) {
        void var1_1;
        return Integer.bitCount(this.nodeMap() & var1_1 - true);
    }

    /*
     * WARNING - void declaration
     */
    public final BitmapIndexedSetNode<A> copyAndSetNode(int bitpos, SetNode<A> oldNode, SetNode<A> newNode) {
        void var3_3;
        void var2_2;
        int idx = this.content().length - 1 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        dst[var1_1] = newNode;
        return new BitmapIndexedSetNode<A>(this.dataMap(), this.nodeMap(), dst, this.originalHashes(), this.size() - oldNode.size() + newNode.size(), this.cachedJavaKeySetHashCode() - var2_2.cachedJavaKeySetHashCode() + var3_3.cachedJavaKeySetHashCode());
    }

    /*
     * WARNING - void declaration
     */
    public final BitmapIndexedSetNode<A> copyAndInsertValue(int bitpos, A key, int originalHash, int elementHash) {
        void var2_2;
        void var1_1;
        void var3_3;
        int dataIx = this.dataIndex(bitpos);
        int idx = 1 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length + 1];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        System.arraycopy(src, idx, dst, idx + 1, src.length - idx);
        BitmapIndexedSetNode bitmapIndexedSetNode = this;
        int[] dstHashes = bitmapIndexedSetNode.insertElement(bitmapIndexedSetNode.originalHashes(), dataIx, (int)var3_3);
        return new BitmapIndexedSetNode<A>(this.dataMap() | var1_1, this.nodeMap(), dst, (int[])var2_2, this.size() + 1, this.cachedJavaKeySetHashCode() + elementHash);
    }

    /*
     * WARNING - void declaration
     */
    public final BitmapIndexedSetNode<A> copyAndRemoveValue(int bitpos, int elementHash) {
        void var2_2;
        void var3_4;
        void var1_1;
        int dataIx = this.dataIndex(bitpos);
        int idx = 1 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 1];
        System.arraycopy(src, 0, dst, 0, idx);
        System.arraycopy(src, idx + 1, dst, idx, src.length - idx - 1);
        BitmapIndexedSetNode bitmapIndexedSetNode = this;
        int[] dstHashes = bitmapIndexedSetNode.removeElement(bitmapIndexedSetNode.originalHashes(), dataIx);
        return new BitmapIndexedSetNode<A>(this.dataMap() ^ var1_1, this.nodeMap(), dst, (int[])var3_4, this.size() - 1, this.cachedJavaKeySetHashCode() - var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final BitmapIndexedSetNode<A> copyAndMigrateFromInlineToNode(int bitpos, int elementHash, SetNode<A> node) {
        void var3_3;
        void var2_2;
        void var1_1;
        int dataIx = this.dataIndex(bitpos);
        int idxOld = 1 * dataIx;
        int idxNew = this.content().length - 1 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 1 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 1, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 1, dst, idxNew + 1, src.length - idxNew - 1);
        BitmapIndexedSetNode bitmapIndexedSetNode = this;
        int[] dstHashes = bitmapIndexedSetNode.removeElement(bitmapIndexedSetNode.originalHashes(), dataIx);
        return new BitmapIndexedSetNode<A>(this.dataMap() ^ bitpos, this.nodeMap() | var1_1, dst, dstHashes, this.size() - 1 + node.size(), this.cachedJavaKeySetHashCode() - var2_2 + var3_3.cachedJavaKeySetHashCode());
    }

    /*
     * WARNING - void declaration
     */
    public final BitmapIndexedSetNode<A> migrateFromInlineToNodeInPlace(int bitpos, int keyHash, SetNode<A> node) {
        void var3_3;
        void var2_2;
        void var1_1;
        int dataIx = this.dataIndex(bitpos);
        int idxOld = 1 * dataIx;
        int idxNew = this.content().length - 1 - this.nodeIndex(bitpos);
        System.arraycopy(this.content(), idxOld + 1, this.content(), idxOld, idxNew - idxOld);
        this.content()[idxNew] = node;
        BitmapIndexedSetNode bitmapIndexedSetNode = this;
        bitmapIndexedSetNode.dataMap_$eq(bitmapIndexedSetNode.dataMap() ^ bitpos);
        BitmapIndexedSetNode bitmapIndexedSetNode2 = this;
        bitmapIndexedSetNode2.nodeMap_$eq(bitmapIndexedSetNode2.nodeMap() | var1_1);
        BitmapIndexedSetNode bitmapIndexedSetNode3 = this;
        bitmapIndexedSetNode3.originalHashes_$eq(bitmapIndexedSetNode3.removeElement(this.originalHashes(), dataIx));
        BitmapIndexedSetNode bitmapIndexedSetNode4 = this;
        bitmapIndexedSetNode4.size_$eq(bitmapIndexedSetNode4.size() - 1 + node.size());
        BitmapIndexedSetNode bitmapIndexedSetNode5 = this;
        bitmapIndexedSetNode5.cachedJavaKeySetHashCode_$eq(bitmapIndexedSetNode5.cachedJavaKeySetHashCode() - var2_2 + var3_3.cachedJavaKeySetHashCode());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final BitmapIndexedSetNode<A> copyAndMigrateFromNodeToInline(int bitpos, int elementHash, SetNode<A> oldNode, SetNode<A> node) {
        void var3_4;
        void var2_3;
        void var1_1;
        int idxOld = this.content().length - 1 - this.nodeIndex(bitpos);
        int dataIxNew = this.dataIndex(bitpos);
        int idxNew = 1 * dataIxNew;
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 1 + 1];
        System.arraycopy(src, 0, dst, 0, idxNew);
        dst[idxNew] = node.getPayload(0);
        System.arraycopy(src, idxNew, dst, idxNew + 1, idxOld - idxNew);
        System.arraycopy(src, idxOld + 1, dst, idxOld + 1, src.length - idxOld - 1);
        int hash = node.getHash(0);
        BitmapIndexedSetNode bitmapIndexedSetNode = this;
        int[] dstHashes = bitmapIndexedSetNode.insertElement(bitmapIndexedSetNode.originalHashes(), dataIxNew, hash);
        return new BitmapIndexedSetNode<A>(this.dataMap() | bitpos, this.nodeMap() ^ var1_1, dst, (int[])var2_3, this.size() - oldNode.size() + 1, this.cachedJavaKeySetHashCode() - var3_4.cachedJavaKeySetHashCode() + node.cachedJavaKeySetHashCode());
    }

    /*
     * WARNING - void declaration
     */
    public final void migrateFromNodeToInlineInPlace(int bitpos, int originalHash, int elementHash, SetNode<A> oldNode, SetNode<A> node) {
        void var2_3;
        void var1_1;
        void var3_4;
        int idxOld = this.content().length - 1 - this.nodeIndex(bitpos);
        int dataIxNew = this.dataIndex(bitpos);
        A element = node.getPayload(0);
        System.arraycopy(this.content(), dataIxNew, this.content(), dataIxNew + 1, idxOld - dataIxNew);
        this.content()[dataIxNew] = element;
        int hash = node.getHash(0);
        BitmapIndexedSetNode bitmapIndexedSetNode = this;
        int[] dstHashes = bitmapIndexedSetNode.insertElement(bitmapIndexedSetNode.originalHashes(), (int)var3_4, hash);
        BitmapIndexedSetNode bitmapIndexedSetNode2 = this;
        bitmapIndexedSetNode2.dataMap_$eq(bitmapIndexedSetNode2.dataMap() | bitpos);
        BitmapIndexedSetNode bitmapIndexedSetNode3 = this;
        bitmapIndexedSetNode3.nodeMap_$eq(bitmapIndexedSetNode3.nodeMap() ^ var1_1);
        this.originalHashes_$eq((int[])var2_3);
        BitmapIndexedSetNode bitmapIndexedSetNode4 = this;
        bitmapIndexedSetNode4.size_$eq(bitmapIndexedSetNode4.size() - oldNode.size() + 1);
        BitmapIndexedSetNode bitmapIndexedSetNode5 = this;
        bitmapIndexedSetNode5.cachedJavaKeySetHashCode_$eq(bitmapIndexedSetNode5.cachedJavaKeySetHashCode() - oldNode.cachedJavaKeySetHashCode() + node.cachedJavaKeySetHashCode());
    }

    @Override
    public final <U> void foreach(Function1<A, U> f) {
        int thisPayloadArity = this.payloadArity();
        for (int i = 0; i < thisPayloadArity; ++i) {
            f.apply(this.content()[i]);
        }
        int thisNodeArity = this.nodeArity();
        for (int j = 0; j < thisNodeArity; ++j) {
            ((SetNode)this.getNode(j)).foreach(f);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final boolean subsetOf(SetNode<A> that, int shift) {
        block8: {
            if (this == that) {
                return true;
            }
            if (that instanceof HashCollisionSetNode) {
                return false;
            }
            if (!(that instanceof BitmapIndexedSetNode)) break block8;
            var3_3 = (BitmapIndexedSetNode)that;
            thisBitmap = this.dataMap() | this.nodeMap();
            if ((thisBitmap | (nodeBitmap = var3_3.dataMap() | var3_3.nodeMap())) != nodeBitmap) {
                return false;
            }
            bitmap = thisBitmap & nodeBitmap;
            bitsToSkip = Integer.numberOfTrailingZeros(bitmap);
            isValidSubset = true;
            while (isValidSubset && bitsToSkip < 32) {
                block10: {
                    block9: {
                        bitpos = 1 << bitsToSkip;
                        if ((this.dataMap() & bitpos) == 0) break block9;
                        if ((var3_3.dataMap() & bitpos) != 0) {
                            getPayload_index = Integer.bitCount(this.dataMap() & bitpos - 1);
                            payload0 = this.content()[getPayload_index];
                            getPayload_index = Integer.bitCount(var3_3.dataMap() & bitpos - 1);
                            payload1 = var3_3.content()[getPayload_index];
                            v0 = BoxesRunTime.equals(payload0, payload1);
                        } else {
                            thisDataIndex = Integer.bitCount(this.dataMap() & bitpos - 1);
                            payload = this.content()[thisDataIndex];
                            subNode = that.getNode(Integer.bitCount(var3_3.nodeMap() & bitpos - 1));
                            elementUnimprovedHash = this.originalHashes()[thisDataIndex];
                            elementHash = Hashing$.MODULE$.improve(elementUnimprovedHash);
                            v0 = subNode.contains(payload, elementUnimprovedHash, elementHash, shift + 5);
                        }
                        break block10;
                    }
                    if ((var3_3.dataMap() & bitpos) != 0) ** GOTO lbl-1000
                    subNode0 = this.getNode(Integer.bitCount(this.nodeMap() & bitpos - 1));
                    subNode1 = var3_3.getNode(Integer.bitCount(var3_3.nodeMap() & bitpos - 1));
                    if (subNode0.subsetOf(subNode1, shift + 5)) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                }
                var6_6 = v0;
                bitmap = newBitmap = bitmap ^ bitpos;
                var5_5 = Integer.numberOfTrailingZeros(newBitmap);
            }
            return var6_6;
        }
        throw new MatchError(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitmapIndexedSetNode<A> filterImpl(Function1<A, Object> pred, boolean flipped) {
        if (this.size() == 0) {
            return this;
        }
        if (this.size() == 1) {
            if (BoxesRunTime.unboxToBoolean(pred.apply(this.content()[0])) != flipped) {
                return this;
            }
            return SetNode$.MODULE$.empty();
        }
        if (this.nodeMap() == 0) {
            void var1_2;
            void var2_4;
            void i;
            int minimumIndex = Integer.numberOfTrailingZeros(this.dataMap());
            int maximumIndex = 32 - Integer.numberOfLeadingZeros(this.dataMap());
            int newDataMap = 0;
            int newCachedHashCode = 0;
            int dataIndex = 0;
            while (i < maximumIndex) {
                int bitpos = 1 << i;
                if ((bitpos & this.dataMap()) != 0) {
                    Object payload = this.content()[dataIndex];
                    if (BoxesRunTime.unboxToBoolean(pred.apply(payload)) != flipped) {
                        newDataMap |= bitpos;
                        newCachedHashCode += Hashing$.MODULE$.improve(this.originalHashes()[dataIndex]);
                    }
                    ++dataIndex;
                }
                ++i;
            }
            if (newDataMap == 0) {
                return SetNode$.MODULE$.empty();
            }
            if (newDataMap == this.dataMap()) {
                return this;
            }
            int newSize = Integer.bitCount(newDataMap);
            Object[] newContent = new Object[newSize];
            int[] newOriginalHashCodes = new int[newSize];
            int newMaximumIndex = 32 - Integer.numberOfLeadingZeros(newDataMap);
            int newDataIndex = 0;
            for (int j = Integer.numberOfTrailingZeros(newDataMap); j < newMaximumIndex; ++j) {
                int bitpos = 1 << j;
                if ((bitpos & newDataMap) == 0) continue;
                int oldIndex = Integer.bitCount(this.dataMap() & bitpos - 1);
                newContent[newDataIndex] = this.content()[oldIndex];
                newOriginalHashCodes[newDataIndex] = this.originalHashes()[oldIndex];
                ++newDataIndex;
            }
            return new BitmapIndexedSetNode<A>(newDataMap, 0, (Object[])var2_4, newOriginalHashCodes, (int)var1_2, newCachedHashCode);
        }
        int allMap = this.dataMap() | this.nodeMap();
        int minimumIndex = Integer.numberOfTrailingZeros(allMap);
        int maximumIndex = 32 - Integer.numberOfLeadingZeros(allMap);
        int oldDataPassThrough = 0;
        int nodeMigrateToDataTargetMap = 0;
        Object nodesToMigrateToData = null;
        int nodesToPassThroughMap = 0;
        int mapOfNewNodes = 0;
        Object newNodes = null;
        int newDataMap = 0;
        int newNodeMap = 0;
        int newSize = 0;
        int newCachedHashCode = 0;
        int dataIndex = 0;
        int nodeIndex = 0;
        for (int i = minimumIndex; i < maximumIndex; ++i) {
            void var2_3;
            void var1_1;
            int bitpos = 1 << i;
            if ((bitpos & this.dataMap()) != 0) {
                Object payload = this.content()[dataIndex];
                if (BoxesRunTime.unboxToBoolean(var1_1.apply(payload)) != var2_3) {
                    newDataMap |= bitpos;
                    oldDataPassThrough |= bitpos;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(this.originalHashes()[dataIndex]);
                }
                ++dataIndex;
                continue;
            }
            if ((bitpos & this.nodeMap()) == 0) continue;
            Node oldSubNode = this.getNode(nodeIndex);
            SetNode newSubNode = ((SetNode)oldSubNode).filterImpl(var1_1, (boolean)var2_3);
            newSize += newSubNode.size();
            newCachedHashCode += newSubNode.cachedJavaKeySetHashCode();
            if (newSubNode.size() > 1) {
                newNodeMap |= bitpos;
                if (oldSubNode == newSubNode) {
                    nodesToPassThroughMap |= bitpos;
                } else {
                    mapOfNewNodes |= bitpos;
                    if (newNodes == null) {
                        newNodes = Queue$.MODULE$.empty();
                    }
                    ((AbstractBuffer)newNodes).$plus$eq(newSubNode);
                }
            } else if (newSubNode.size() == 1) {
                newDataMap |= bitpos;
                nodeMigrateToDataTargetMap |= bitpos;
                if (nodesToMigrateToData == null) {
                    nodesToMigrateToData = Queue$.MODULE$.empty();
                }
                ((AbstractBuffer)nodesToMigrateToData).$plus$eq(newSubNode);
            }
            ++nodeIndex;
        }
        return this.newNodeFrom(newSize, newDataMap, newNodeMap, minimumIndex, oldDataPassThrough, nodesToPassThroughMap, nodeMigrateToDataTargetMap, (Queue<SetNode<A>>)nodesToMigrateToData, mapOfNewNodes, (Queue<SetNode<A>>)newNodes, newCachedHashCode);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitmapIndexedSetNode<A> diff(SetNode<A> that, int shift) {
        void var1_1;
        if (that instanceof BitmapIndexedSetNode) {
            BitmapIndexedSetNode bitmapIndexedSetNode = (BitmapIndexedSetNode)that;
            if (this.size() == 0) {
                return this;
            }
            if (this.size() == 1) {
                void var3_5;
                int h = this.originalHashes()[0];
                if (that.contains(this.content()[0], h, Hashing$.MODULE$.improve((int)var3_5), shift)) {
                    return SetNode$.MODULE$.empty();
                }
                return this;
            }
            int allMap = this.dataMap() | this.nodeMap();
            int minimumIndex = Integer.numberOfTrailingZeros(allMap);
            int maximumIndex = 32 - Integer.numberOfLeadingZeros(allMap);
            int oldDataPassThrough = 0;
            int nodeMigrateToDataTargetMap = 0;
            Object nodesToMigrateToData = null;
            int nodesToPassThroughMap = 0;
            int mapOfNewNodes = 0;
            Object newNodes = null;
            int newDataMap = 0;
            int newNodeMap = 0;
            int newSize = 0;
            int newCachedHashCode = 0;
            int dataIndex = 0;
            int nodeIndex = 0;
            for (int i = minimumIndex; i < maximumIndex; ++i) {
                SetNode<Object> setNode;
                int bitpos = 1 << i;
                if ((bitpos & this.dataMap()) != 0) {
                    int hash;
                    int originalHash;
                    Object payload = this.content()[dataIndex];
                    if (!bitmapIndexedSetNode.contains(payload, originalHash = this.originalHashes()[dataIndex], hash = Hashing$.MODULE$.improve(originalHash), shift)) {
                        newDataMap |= bitpos;
                        oldDataPassThrough |= bitpos;
                        ++newSize;
                        newCachedHashCode += hash;
                    }
                    ++dataIndex;
                    continue;
                }
                if ((bitpos & this.nodeMap()) == 0) continue;
                SetNode<Object> oldSubNode = this.getNode(nodeIndex);
                if ((bitpos & bitmapIndexedSetNode.dataMap()) != 0) {
                    int thatDataIndex = Integer.bitCount(bitmapIndexedSetNode.dataMap() & bitpos - 1);
                    Object thatPayload = bitmapIndexedSetNode.content()[thatDataIndex];
                    int thatOriginalHash = bitmapIndexedSetNode.originalHashes()[thatDataIndex];
                    int thatHash = Hashing$.MODULE$.improve(thatOriginalHash);
                    setNode = oldSubNode.removed(thatPayload, thatOriginalHash, thatHash, shift + 5);
                } else {
                    setNode = (bitpos & bitmapIndexedSetNode.nodeMap()) != 0 ? oldSubNode.diff((SetNode<Object>)bitmapIndexedSetNode.getNode(Integer.bitCount(bitmapIndexedSetNode.nodeMap() & bitpos - 1)), shift + 5) : oldSubNode;
                }
                SetNode<Object> newSubNode = setNode;
                newSize += newSubNode.size();
                newCachedHashCode += newSubNode.cachedJavaKeySetHashCode();
                if (newSubNode.size() > 1) {
                    newNodeMap |= bitpos;
                    if (oldSubNode == newSubNode) {
                        nodesToPassThroughMap |= bitpos;
                    } else {
                        mapOfNewNodes |= bitpos;
                        if (newNodes == null) {
                            newNodes = Queue$.MODULE$.empty();
                        }
                        ((AbstractBuffer)newNodes).$plus$eq(newSubNode);
                    }
                } else if (newSubNode.size() == 1) {
                    newDataMap |= bitpos;
                    nodeMigrateToDataTargetMap |= bitpos;
                    if (nodesToMigrateToData == null) {
                        nodesToMigrateToData = Queue$.MODULE$.empty();
                    }
                    ((AbstractBuffer)nodesToMigrateToData).$plus$eq(newSubNode);
                }
                ++nodeIndex;
            }
            return this.newNodeFrom(newSize, newDataMap, newNodeMap, minimumIndex, oldDataPassThrough, nodesToPassThroughMap, nodeMigrateToDataTargetMap, (Queue<SetNode<A>>)nodesToMigrateToData, mapOfNewNodes, (Queue<SetNode<A>>)newNodes, newCachedHashCode);
        }
        if (var1_1 instanceof HashCollisionSetNode) {
            throw new RuntimeException("BitmapIndexedSetNode diff HashCollisionSetNode");
        }
        throw new MatchError(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private BitmapIndexedSetNode<A> newNodeFrom(int newSize, int newDataMap, int newNodeMap, int minimumIndex, int oldDataPassThrough, int nodesToPassThroughMap, int nodeMigrateToDataTargetMap, Queue<SetNode<A>> nodesToMigrateToData, int mapOfNewNodes, Queue<SetNode<A>> newNodes, int newCachedHashCode) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (newSize == 0) {
            return SetNode$.MODULE$.empty();
        }
        if (newSize == this.size()) {
            return this;
        }
        int newDataSize = Integer.bitCount(newDataMap);
        int newContentSize = newDataSize + Integer.bitCount(newNodeMap);
        Object[] newContent = new Object[newContentSize];
        int[] newOriginalHashes = new int[newDataSize];
        int newAllMap = newDataMap | newNodeMap;
        int maxIndex = 32 - Integer.numberOfLeadingZeros(newAllMap);
        int oldDataIndex = 0;
        int oldNodeIndex = 0;
        int newDataIndex = 0;
        int newNodeIndex = 0;
        for (int i = minimumIndex; i < maxIndex; ++i) {
            void var20_21;
            int bitpos = 1 << i;
            if ((bitpos & oldDataPassThrough) != 0) {
                newContent[newDataIndex] = this.content()[oldDataIndex];
                newOriginalHashes[newDataIndex] = this.originalHashes()[oldDataIndex];
                ++newDataIndex;
                ++oldDataIndex;
                continue;
            }
            if ((bitpos & nodesToPassThroughMap) != 0) {
                newContent[newContentSize - newNodeIndex - 1] = this.getNode(oldNodeIndex);
                ++newNodeIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((bitpos & nodeMigrateToDataTargetMap) != 0) {
                SetNode<A> node = nodesToMigrateToData.dequeue();
                newContent[newDataIndex] = node.getPayload(0);
                newOriginalHashes[newDataIndex] = node.getHash(0);
                ++newDataIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((var20_21 & mapOfNewNodes) != 0) {
                newContent[newContentSize - newNodeIndex - 1] = newNodes.dequeue();
                ++newNodeIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((var20_21 & this.dataMap()) != 0) {
                ++oldDataIndex;
                continue;
            }
            if ((var20_21 & this.nodeMap()) == 0) continue;
            ++oldNodeIndex;
        }
        return new BitmapIndexedSetNode<A>((int)var2_2, (int)var3_3, newContent, newOriginalHashes, (int)var1_1, newCachedHashCode);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object that) {
        block6: {
            block8: {
                block7: {
                    boolean bl;
                    if (!(that instanceof BitmapIndexedSetNode)) break block6;
                    if (this == (that = (BitmapIndexedSetNode)that)) break block7;
                    if (this.cachedJavaKeySetHashCode() != ((BitmapIndexedSetNode)that).cachedJavaKeySetHashCode() || this.nodeMap() != ((BitmapIndexedSetNode)that).nodeMap() || this.dataMap() != ((BitmapIndexedSetNode)that).dataMap() || this.size() != ((BitmapIndexedSetNode)that).size() || !Arrays.equals(this.originalHashes(), ((BitmapIndexedSetNode)that).originalHashes())) break block8;
                    int n = this.content().length;
                    Object[] deepContentEquality_a2 = ((BitmapIndexedSetNode)that).content();
                    Object[] deepContentEquality_a1 = this.content();
                    if (deepContentEquality_a1 == deepContentEquality_a2) {
                        bl = true;
                    } else {
                        void deepContentEquality_length;
                        boolean deepContentEquality_isEqual = true;
                        for (int deepContentEquality_i = 0; deepContentEquality_isEqual && deepContentEquality_i < deepContentEquality_length; ++deepContentEquality_i) {
                            deepContentEquality_isEqual = BoxesRunTime.equals(deepContentEquality_a1[deepContentEquality_i], deepContentEquality_a2[deepContentEquality_i]);
                        }
                        bl = deepContentEquality_isEqual;
                    }
                    if (!bl) break block8;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        throw new UnsupportedOperationException("Trie nodes do not support hashing.");
    }

    public final String toString() {
        return StringOps$.MODULE$.format$extension("BitmapIndexedSetNode(size=%s, dataMap=%x, nodeMap=%x)", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.size(), this.dataMap(), this.nodeMap()}));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitmapIndexedSetNode<A> copy() {
        void var1_1;
        Object[] contentClone = (Object[])this.content().clone();
        int contentLength = contentClone.length;
        for (int i = Integer.bitCount(this.dataMap()); i < contentLength; ++i) {
            contentClone[i] = ((SetNode)contentClone[i]).copy();
        }
        return new BitmapIndexedSetNode<A>(this.dataMap(), this.nodeMap(), (Object[])var1_1, (int[])this.originalHashes().clone(), this.size(), this.cachedJavaKeySetHashCode());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitmapIndexedSetNode<A> concat(SetNode<A> that, int shift) {
        if (that instanceof BitmapIndexedSetNode) {
            void var3_4;
            BitmapIndexedSetNode bitmapIndexedSetNode;
            bitmapIndexedSetNode = bitmapIndexedSetNode;
            if (this.size() == 0) {
                return bitmapIndexedSetNode;
            }
            if (bitmapIndexedSetNode.size() == 0 || bitmapIndexedSetNode == this) {
                return this;
            }
            if (bitmapIndexedSetNode.size() == 1) {
                int originalHash = bitmapIndexedSetNode.getHash(0);
                return this.updated((Object)bitmapIndexedSetNode.getPayload(0), originalHash, Hashing$.MODULE$.improve(originalHash), shift);
            }
            boolean anyChangesMadeSoFar = false;
            int allMap = this.dataMap() | bitmapIndexedSetNode.dataMap() | this.nodeMap() | bitmapIndexedSetNode.nodeMap();
            int minimumBitPos = Node$.MODULE$.bitposFrom(Integer.numberOfTrailingZeros(allMap));
            int maximumBitPos = Node$.MODULE$.bitposFrom(32 - Integer.numberOfLeadingZeros(allMap) - 1);
            int leftNodeRightNode = 0;
            int leftDataRightNode = 0;
            int leftNodeRightData = 0;
            int leftDataOnly = 0;
            int rightDataOnly = 0;
            int leftNodeOnly = 0;
            int rightNodeOnly = 0;
            int leftDataRightDataMigrateToNode = 0;
            int leftDataRightDataLeftOverwrites = 0;
            int dataToNodeMigrationTargets = 0;
            int bitpos = minimumBitPos;
            int leftIdx = 0;
            int rightIdx = 0;
            boolean finished = false;
            while (!finished) {
                if ((bitpos & this.dataMap()) != 0) {
                    if ((bitpos & bitmapIndexedSetNode.dataMap()) != 0) {
                        if (this.getHash(leftIdx) == bitmapIndexedSetNode.getHash(rightIdx) && BoxesRunTime.equals(this.getPayload(leftIdx), bitmapIndexedSetNode.getPayload(rightIdx))) {
                            leftDataRightDataLeftOverwrites |= bitpos;
                        } else {
                            leftDataRightDataMigrateToNode |= bitpos;
                            Node$ node$ = Node$.MODULE$;
                            dataToNodeMigrationTargets |= node$.bitposFrom(node$.maskFrom(Hashing$.MODULE$.improve(this.getHash(leftIdx)), shift));
                        }
                        ++rightIdx;
                    } else if ((bitpos & bitmapIndexedSetNode.nodeMap()) != 0) {
                        leftDataRightNode |= bitpos;
                    } else {
                        leftDataOnly |= bitpos;
                    }
                    ++leftIdx;
                } else if ((bitpos & this.nodeMap()) != 0) {
                    if ((bitpos & bitmapIndexedSetNode.dataMap()) != 0) {
                        leftNodeRightData |= bitpos;
                        ++rightIdx;
                    } else if ((bitpos & bitmapIndexedSetNode.nodeMap()) != 0) {
                        leftNodeRightNode |= bitpos;
                    } else {
                        leftNodeOnly |= bitpos;
                    }
                } else if ((bitpos & bitmapIndexedSetNode.dataMap()) != 0) {
                    rightDataOnly |= bitpos;
                    ++rightIdx;
                } else if ((bitpos & bitmapIndexedSetNode.nodeMap()) != 0) {
                    rightNodeOnly |= bitpos;
                }
                if (bitpos == maximumBitPos) {
                    finished = true;
                    continue;
                }
                bitpos <<= 1;
            }
            int newDataMap = leftDataOnly | rightDataOnly | leftDataRightDataLeftOverwrites;
            int newNodeMap = leftNodeRightNode | leftDataRightNode | leftNodeRightData | leftNodeOnly | rightNodeOnly | dataToNodeMigrationTargets;
            if (newDataMap == (leftDataOnly | leftDataRightDataLeftOverwrites) && newNodeMap == leftNodeOnly) {
                return this;
            }
            int newDataSize = Integer.bitCount(newDataMap);
            int newContentSize = newDataSize + Integer.bitCount(newNodeMap);
            Object[] newContent = new Object[newContentSize];
            int[] newOriginalHashes = new int[newDataSize];
            int newSize = 0;
            int newCachedHashCode = 0;
            int leftDataIdx = 0;
            int rightDataIdx = 0;
            int leftNodeIdx = 0;
            int rightNodeIdx = 0;
            int nextShift = shift + 5;
            int compressedDataIdx = 0;
            int compressedNodeIdx = 0;
            int bitpos2 = minimumBitPos;
            boolean finished2 = false;
            while (!finished2) {
                if ((bitpos2 & leftNodeRightNode) != 0) {
                    SetNode newNode;
                    Node leftNode = this.getNode(leftNodeIdx);
                    if (leftNode != (newNode = ((SetNode)leftNode).concat(bitmapIndexedSetNode.getNode(rightNodeIdx), nextShift))) {
                        anyChangesMadeSoFar = true;
                    }
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    ++leftNodeIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightNode) != 0) {
                    SetNode<A> newNode;
                    anyChangesMadeSoFar = true;
                    Node n = bitmapIndexedSetNode.getNode(rightNodeIdx);
                    A leftPayload = this.getPayload(leftDataIdx);
                    int leftOriginalHash = this.getHash(leftDataIdx);
                    int leftImproved = Hashing$.MODULE$.improve(leftOriginalHash);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode = ((SetNode)n).updated(leftPayload, leftOriginalHash, leftImproved, nextShift);
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    ++leftDataIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftNodeRightData) != 0) {
                    int rightOriginalHash = bitmapIndexedSetNode.getHash(rightDataIdx);
                    Node leftNode = this.getNode(leftNodeIdx);
                    SetNode<A> updated = ((SetNode)leftNode).updated(bitmapIndexedSetNode.getPayload(rightDataIdx), bitmapIndexedSetNode.getHash(rightDataIdx), Hashing$.MODULE$.improve(rightOriginalHash), nextShift);
                    if (updated != leftNode) {
                        anyChangesMadeSoFar = true;
                    }
                    newContent[newContentSize - compressedNodeIdx - 1] = updated;
                    ++compressedNodeIdx;
                    ++leftNodeIdx;
                    ++rightDataIdx;
                    newSize += updated.size();
                    newCachedHashCode += updated.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataOnly) != 0) {
                    int originalHash = this.originalHashes()[leftDataIdx];
                    newContent[compressedDataIdx] = this.getPayload(leftDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++leftDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                } else if ((bitpos2 & rightDataOnly) != 0) {
                    anyChangesMadeSoFar = true;
                    int originalHash = bitmapIndexedSetNode.originalHashes()[rightDataIdx];
                    newContent[compressedDataIdx] = bitmapIndexedSetNode.getPayload(rightDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++rightDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                } else if ((bitpos2 & leftNodeOnly) != 0) {
                    Node newNode = this.getNode(leftNodeIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++leftNodeIdx;
                    newSize += ((SetNode)newNode).size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & rightNodeOnly) != 0) {
                    anyChangesMadeSoFar = true;
                    Node newNode = bitmapIndexedSetNode.getNode(rightNodeIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    newSize += ((SetNode)newNode).size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightDataMigrateToNode) != 0) {
                    SetNode<A> newNode;
                    anyChangesMadeSoFar = true;
                    int leftOriginalHash = this.getHash(leftDataIdx);
                    int rightOriginalHash = bitmapIndexedSetNode.getHash(rightDataIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode = bitmapIndexedSetNode.mergeTwoKeyValPairs(this.getPayload(leftDataIdx), leftOriginalHash, Hashing$.MODULE$.improve(leftOriginalHash), bitmapIndexedSetNode.getPayload(rightDataIdx), rightOriginalHash, Hashing$.MODULE$.improve(rightOriginalHash), nextShift);
                    ++compressedNodeIdx;
                    ++leftDataIdx;
                    ++rightDataIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightDataLeftOverwrites) != 0) {
                    int originalHash = bitmapIndexedSetNode.originalHashes()[rightDataIdx];
                    newContent[compressedDataIdx] = bitmapIndexedSetNode.getPayload(rightDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++rightDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                    ++leftDataIdx;
                }
                if (bitpos2 == maximumBitPos) {
                    finished2 = true;
                    continue;
                }
                bitpos2 <<= 1;
            }
            if (var3_4 != false) {
                return new BitmapIndexedSetNode<A>(newDataMap, newNodeMap, newContent, newOriginalHashes, newSize, newCachedHashCode);
            }
            return this;
        }
        throw new UnsupportedOperationException("Cannot concatenate a HashCollisionSetNode with a BitmapIndexedSetNode");
    }

    @Override
    public final void foreachWithHash(Function2<A, Object, BoxedUnit> f) {
        int iN = this.payloadArity();
        for (int i = 0; i < iN; ++i) {
            f.apply(this.content()[i], this.originalHashes()[i]);
        }
        int jN = this.nodeArity();
        for (int j = 0; j < jN; ++j) {
            ((SetNode)this.getNode(j)).foreachWithHash(f);
        }
    }

    /*
     * WARNING - void declaration
     */
    public BitmapIndexedSetNode(int dataMap, int nodeMap, Object[] content, int[] originalHashes, int size, int cachedJavaKeySetHashCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.dataMap = var1_1;
        this.nodeMap = var2_2;
        this.content = var3_3;
        this.originalHashes = originalHashes;
        this.size = size;
        this.cachedJavaKeySetHashCode = cachedJavaKeySetHashCode;
    }
}

