Apache Axiom 1.2.14 Release Note
================================

Axiom 1.2.14 contains fixes for more than twenty [JIRA issues][1] as well as lots of other
improvements.

Changes in this release
-----------------------

### Upgrade of Woodstox

Woodstox 3.2.x is no longer maintained. Starting with version 1.2.14, Axiom depends on Woodstox
4.1.x, although using 3.2.x (and 4.0.x) is still supported. This may have an impact on projects that
use Maven, because the artifact ID used by Woodstox changed from `wstx-asl` to `woodstox-core-asl`.
These projects may need to update their dependencies to avoid depending on two different versions of
Woodstox.

### DOOM factories are now stateless

In contrast to previous versions, the `OMFactory` implementations for DOOM are stateless in Axiom
1.2.14. This makes it easier to write application code that is portable between LLOM and DOOM (in
the sense that code that is known to work with LLOM will usually work with DOOM without changes).
However, this slightly changes the behavior of DOOM with respect to owner documents, which means
that in some cases existing code written for DOOM may trigger `WRONG_DOCUMENT_ERR` exceptions if it
uses the DOM API on a tree created or manipulated using the Axiom API.

For more information about the new semantics, refer to the Javadoc of `DOMMetaFactory` and to
[AXIOM-412][2].

### Removal of deprecated classes from core artifacts

Several deprecated classes have been moved to a new JAR file named `axiom-compat` and are no longer
included in the core artifacts (`axiom-api`, `axiom-impl` and `axiom-dom`). If you rely on these
deprecated classes or get `NoClassDefFoundError`s after upgrading to Axiom 1.2.14, then you need to
add this new JAR to your project's dependencies.

[1]: http://s.apache.org/axiom-changes-1.2.14
[2]: https://issues.apache.org/jira/browse/AXIOM-412
