/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi.conditions.geo;

import org.apache.unomi.persistence.spi.conditions.geo.DistanceUnit;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GeoDistance {
    HAVERSINE{

        @Override
        public double calculate(double lat1, double lon1, double lat2, double lon2, DistanceUnit unit) {
            double latRad1 = 1.toRadians(lat1);
            double latRad2 = 1.toRadians(lat2);
            double deltaLat = 1.toRadians(lat2 - lat1);
            double deltaLon = 1.toRadians(lon2 - lon1);
            double a = Math.sin(deltaLat / 2.0) * Math.sin(deltaLat / 2.0) + Math.cos(latRad1) * Math.cos(latRad2) * Math.sin(deltaLon / 2.0) * Math.sin(deltaLon / 2.0);
            double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
            return unit.convert(6371008.7714 * c, DistanceUnit.METERS);
        }
    }
    ,
    ARC{

        @Override
        public double calculate(double lat1, double lon1, double lat2, double lon2, DistanceUnit unit) {
            double latRad1 = 2.toRadians(lat1);
            double lonRad1 = 2.toRadians(lon1);
            double latRad2 = 2.toRadians(lat2);
            double lonRad2 = 2.toRadians(lon2);
            double deltaLon = lonRad2 - lonRad1;
            double cosTheta = Math.sin(latRad1) * Math.sin(latRad2) + Math.cos(latRad1) * Math.cos(latRad2) * Math.cos(deltaLon);
            double theta = Math.acos(Math.min(1.0, Math.max(-1.0, cosTheta)));
            return unit.convert(6371008.7714 * theta, DistanceUnit.METERS);
        }
    }
    ,
    PLANE{

        @Override
        public double calculate(double lat1, double lon1, double lat2, double lon2, DistanceUnit unit) {
            double x = 3.toRadians(lon2 - lon1) * Math.cos(3.toRadians((lat1 + lat2) / 2.0));
            double y = 3.toRadians(lat2 - lat1);
            double distance = Math.sqrt(x * x + y * y) * 6371008.7714;
            return unit.convert(distance, DistanceUnit.METERS);
        }
    };

    public static final double EARTH_MEAN_RADIUS = 6371008.7714;
    public static final double TO_RADIANS = Math.PI / 180;
    public static final double TO_DEGREES = 57.29577951308232;

    public static double toRadians(double degrees) {
        return degrees * (Math.PI / 180);
    }

    public abstract double calculate(double var1, double var3, double var5, double var7, DistanceUnit var9);

    public static GeoDistance fromString(String name) {
        if ("plane".equalsIgnoreCase(name)) {
            return PLANE;
        }
        if ("arc".equalsIgnoreCase(name)) {
            return ARC;
        }
        if ("haversine".equalsIgnoreCase(name)) {
            return HAVERSINE;
        }
        throw new IllegalArgumentException("Unknown GeoDistance method: " + name);
    }
}

