/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ws.rs.ext.ExceptionMapper;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.security.AbstractAuthorizingInInterceptor;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.openapi.OpenApiCustomizer;
import org.apache.cxf.jaxrs.openapi.OpenApiFeature;
import org.apache.cxf.jaxrs.security.SimpleAuthorizingFilter;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiConfig;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharingFilter;
import org.apache.unomi.api.ContextRequest;
import org.apache.unomi.api.EventsCollectorRequest;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.rest.authentication.AuthenticationFilter;
import org.apache.unomi.rest.authentication.AuthorizingInterceptor;
import org.apache.unomi.rest.authentication.RestAuthenticationConfig;
import org.apache.unomi.rest.deserializers.ContextRequestDeserializer;
import org.apache.unomi.rest.deserializers.EventsCollectorRequestDeserializer;
import org.apache.unomi.rest.server.provider.RetroCompatibilityParamConverterProvider;
import org.apache.unomi.rest.validation.request.RequestValidatorInterceptor;
import org.apache.unomi.schema.api.SchemaService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class RestServer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RestServer.class.getName());
    private Server server;
    private BundleContext bundleContext;
    private ServiceTracker jaxRSServiceTracker;
    final List<Object> serviceBeans = new CopyOnWriteArrayList<Object>();
    private Bus serverBus;
    private RestAuthenticationConfig restAuthenticationConfig;
    private List<ExceptionMapper> exceptionMappers = new ArrayList<ExceptionMapper>();
    private ConfigSharingService configSharingService;
    private SchemaService schemaService;
    private long timeOfLastUpdate = System.currentTimeMillis();
    private Timer refreshTimer = null;
    private long startupDelay = 1000L;
    private static final QName UNOMI_REST_SERVER_END_POINT_NAME = new QName("http://rest.unomi.apache.org/", "UnomiRestServerEndPoint");

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setSchemaService(SchemaService schemaService) {
        this.schemaService = schemaService;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setServerBus(Bus serverBus) {
        this.serverBus = serverBus;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setRestAuthenticationConfig(RestAuthenticationConfig restAuthenticationConfig) {
        this.restAuthenticationConfig = restAuthenticationConfig;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setConfigSharingService(ConfigSharingService configSharingService) {
        this.configSharingService = configSharingService;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void addExceptionMapper(ExceptionMapper exceptionMapper) {
        this.exceptionMappers.add(exceptionMapper);
        this.timeOfLastUpdate = System.currentTimeMillis();
        this.refreshServer();
    }

    public void removeExceptionMapper(ExceptionMapper exceptionMapper) {
        this.exceptionMappers.remove(exceptionMapper);
        this.timeOfLastUpdate = System.currentTimeMillis();
        this.refreshServer();
    }

    @Activate
    public void activate(ComponentContext componentContext) throws Exception {
        this.bundleContext = componentContext.getBundleContext();
        Filter filter = this.bundleContext.createFilter("(osgi.jaxrs.resource=true)");
        this.jaxRSServiceTracker = new ServiceTracker(this.bundleContext, filter, new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                Object serviceBean = RestServer.this.bundleContext.getService(reference);
                while (serviceBean == null) {
                    LOGGER.info("Waiting for service {} to become available...", reference.getProperty("objectClass"));
                    serviceBean = RestServer.this.bundleContext.getService(reference);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.warn("Interrupted thread exception", (Throwable)e);
                    }
                }
                LOGGER.info("Registering JAX RS service {}", (Object)serviceBean.getClass().getName());
                RestServer.this.serviceBeans.add(serviceBean);
                RestServer.this.timeOfLastUpdate = System.currentTimeMillis();
                RestServer.this.refreshServer();
                return serviceBean;
            }

            public void modifiedService(ServiceReference reference, Object service) {
                LOGGER.info("Refreshing JAX RS server because service {} was modified.", (Object)service.getClass().getName());
                RestServer.this.timeOfLastUpdate = System.currentTimeMillis();
                RestServer.this.refreshServer();
            }

            public void removedService(ServiceReference reference, Object service) {
                LOGGER.info("Removing JAX RS service {}", (Object)service.getClass().getName());
                RestServer.this.serviceBeans.remove(service);
                RestServer.this.timeOfLastUpdate = System.currentTimeMillis();
                RestServer.this.refreshServer();
            }
        });
        this.jaxRSServiceTracker.open();
    }

    @Deactivate
    public void deactivate() throws Exception {
        this.jaxRSServiceTracker.close();
        if (this.server != null) {
            this.server.destroy();
        }
    }

    private synchronized void refreshServer() {
        LOGGER.info("Refreshing JAX RS server...");
        long now = System.currentTimeMillis();
        LOGGER.info("Time (millis) since last update: {}", (Object)(now - this.timeOfLastUpdate));
        if (now - this.timeOfLastUpdate < this.startupDelay) {
            if (this.refreshTimer != null) {
                return;
            }
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    RestServer.this.refreshTimer = null;
                    RestServer.this.refreshServer();
                    LOGGER.info("Refreshed server task performed on: {} Thread's name: {}", (Object)new Date(), (Object)Thread.currentThread().getName());
                }
            };
            this.refreshTimer = new Timer("Timer-Refresh-REST-API");
            this.refreshTimer.schedule(task, this.startupDelay);
            return;
        }
        if (this.server != null) {
            LOGGER.info("JAX RS Server: Shutting down server...");
            this.server.destroy();
        }
        if (this.serviceBeans.isEmpty()) {
            LOGGER.info("JAX RS Server: Server not started because no JAX RS EndPoint registered yet");
            return;
        }
        LOGGER.info("JAX RS Server: Configuring server...");
        ArrayList<RequestValidatorInterceptor> inInterceptors = new ArrayList<RequestValidatorInterceptor>();
        ArrayList outInterceptors = new ArrayList();
        HashMap<Class, StdDeserializer> desers = new HashMap<Class, StdDeserializer>();
        desers.put(ContextRequest.class, new ContextRequestDeserializer(this.schemaService));
        desers.put(EventsCollectorRequest.class, new EventsCollectorRequestDeserializer(this.schemaService));
        CustomObjectMapper objectMapper = new CustomObjectMapper(desers);
        JAXRSServerFactoryBean jaxrsServerFactoryBean = new JAXRSServerFactoryBean();
        jaxrsServerFactoryBean.setAddress("/");
        jaxrsServerFactoryBean.setBus(this.serverBus);
        jaxrsServerFactoryBean.setProvider((Object)new JacksonJaxbJsonProvider((ObjectMapper)objectMapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS));
        jaxrsServerFactoryBean.setProvider((Object)new CrossOriginResourceSharingFilter());
        jaxrsServerFactoryBean.setProvider((Object)new RetroCompatibilityParamConverterProvider((ObjectMapper)objectMapper));
        jaxrsServerFactoryBean.setProvider((Object)new AuthenticationFilter(this.restAuthenticationConfig));
        SimpleAuthorizingFilter simpleAuthorizingFilter = new SimpleAuthorizingFilter();
        simpleAuthorizingFilter.setInterceptor((AbstractAuthorizingInInterceptor)new AuthorizingInterceptor(this.restAuthenticationConfig));
        jaxrsServerFactoryBean.setProvider((Object)simpleAuthorizingFilter);
        for (ExceptionMapper exceptionMapper : this.exceptionMappers) {
            jaxrsServerFactoryBean.setProvider((Object)exceptionMapper);
        }
        OpenApiFeature openApiFeature = new OpenApiFeature();
        openApiFeature.setContactEmail("dev@unomi.apache.org");
        openApiFeature.setLicense("Apache 2.0 License");
        openApiFeature.setLicenseUrl("http://www.apache.org/licenses/LICENSE-2.0.html");
        openApiFeature.setScan(false);
        openApiFeature.setUseContextBasedConfig(true);
        SwaggerUiConfig swaggerUiConfig = new SwaggerUiConfig().url("openapi.json").deepLinking(Boolean.valueOf(true)).queryConfigEnabled(false);
        openApiFeature.setSwaggerUiConfig(swaggerUiConfig);
        OpenApiCustomizer customizer = new OpenApiCustomizer();
        customizer.setDynamicBasePath(true);
        openApiFeature.setCustomizer(customizer);
        jaxrsServerFactoryBean.getFeatures().add(openApiFeature);
        inInterceptors.add(new RequestValidatorInterceptor(this.configSharingService));
        jaxrsServerFactoryBean.setInInterceptors(inInterceptors);
        jaxrsServerFactoryBean.setOutInterceptors(outInterceptors);
        jaxrsServerFactoryBean.setServiceBeans(this.serviceBeans);
        LOGGER.info("JAX RS Server: Starting server with {} JAX RS EndPoints registered", (Object)this.serviceBeans.size());
        this.server = jaxrsServerFactoryBean.create();
        this.server.getEndpoint().getEndpointInfo().setName(UNOMI_REST_SERVER_END_POINT_NAME);
    }
}

