/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.osgi.registry;

import org.apache.geronimo.osgi.registry.Activator;
import org.apache.geronimo.osgi.registry.ProviderRegistryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class ProviderBundleTrackerCustomizer
implements BundleTrackerCustomizer {
    private Activator activator;
    private Bundle registryBundle;
    private ProviderRegistryImpl registry;

    public ProviderBundleTrackerCustomizer(Activator a, Bundle b, ProviderRegistryImpl r) {
        this.activator = a;
        this.registryBundle = b;
        this.registry = r;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        this.log(4, "Bundle Considered for class providers: " + bundle.getSymbolicName());
        if (bundle.equals(this.registryBundle)) {
            return null;
        }
        return this.registry.addBundle(bundle);
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.registry.removeBundle(bundle, object);
    }

    private void log(int level, String message) {
        this.activator.log(level, message);
    }

    private void log(int level, String message, Throwable th) {
        this.activator.log(level, message, th);
    }
}

