/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.persistence.spi.conditions.evaluator.ConditionEvaluator;
import org.apache.unomi.persistence.spi.conditions.evaluator.ConditionEvaluatorDispatcher;

public class SourceEventPropertyConditionEvaluator
implements ConditionEvaluator {
    private static final Map<String, String> MAPPED_PROPERTIES = new HashMap<String, String>(4);
    private DefinitionsService definitionsService;

    private void appendConditionIfPropExist(List<Condition> conditions, Condition condition, String prop, ConditionType propConditionType) {
        Object parameter = condition.getParameter(prop);
        if (parameter != null && !"".equals(parameter)) {
            Condition propCondition = new Condition(propConditionType);
            propCondition.setParameter("comparisonOperator", (Object)"equals");
            propCondition.setParameter("propertyName", (Object)MAPPED_PROPERTIES.get(prop));
            propCondition.setParameter("propertyValue", parameter);
            conditions.add(propCondition);
        }
    }

    public boolean eval(Condition condition, Item item, Map<String, Object> context, ConditionEvaluatorDispatcher dispatcher) {
        if (item instanceof Event) {
            item = ((Event)item).getSource();
        }
        Condition andCondition = new Condition(this.definitionsService.getConditionType("booleanCondition"));
        andCondition.setParameter("operator", (Object)"and");
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (String prop : MAPPED_PROPERTIES.keySet()) {
            this.appendConditionIfPropExist(conditions, condition, prop, this.definitionsService.getConditionType("eventPropertyCondition"));
        }
        if (conditions.size() > 0) {
            if (item != null) {
                andCondition.setParameter("subConditions", conditions);
                return dispatcher.eval(andCondition, item);
            }
            return false;
        }
        return true;
    }

    public DefinitionsService getDefinitionsService() {
        return this.definitionsService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    static {
        MAPPED_PROPERTIES.put("id", "itemId");
        MAPPED_PROPERTIES.put("path", "properties.pageInfo.pagePath");
        MAPPED_PROPERTIES.put("type", "itemType");
        MAPPED_PROPERTIES.put("scope", "scope");
    }
}

