/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.GeoPoint;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.spi.PropertyHelper;
import org.apache.unomi.persistence.spi.conditions.ConditionContextHelper;
import org.apache.unomi.persistence.spi.conditions.DateUtils;
import org.apache.unomi.persistence.spi.conditions.evaluator.ConditionEvaluator;
import org.apache.unomi.persistence.spi.conditions.evaluator.ConditionEvaluatorDispatcher;
import org.apache.unomi.persistence.spi.conditions.geo.DistanceUnit;
import org.apache.unomi.plugins.baseplugin.conditions.HardcodedPropertyAccessorRegistry;
import org.apache.unomi.scripting.ExpressionFilterFactory;
import org.apache.unomi.scripting.SecureFilteringClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyConditionEvaluator
implements ConditionEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PropertyConditionEvaluator.class.getName());
    private static final SimpleDateFormat yearMonthDayDateFormat = new SimpleDateFormat("yyyyMMdd");
    private boolean usePropertyConditionOptimizations = true;
    private static final ClassLoader secureFilteringClassLoader = new SecureFilteringClassLoader(PropertyConditionEvaluator.class.getClassLoader());
    private static final HardcodedPropertyAccessorRegistry hardcodedPropertyAccessorRegistry = new HardcodedPropertyAccessorRegistry();
    private ExpressionFilterFactory expressionFilterFactory;

    public void setUsePropertyConditionOptimizations(boolean usePropertyConditionOptimizations) {
        this.usePropertyConditionOptimizations = usePropertyConditionOptimizations;
    }

    public void setExpressionFilterFactory(ExpressionFilterFactory expressionFilterFactory) {
        this.expressionFilterFactory = expressionFilterFactory;
    }

    private int compare(Object actualValue, String expectedValue, Object expectedValueDate, Object expectedValueInteger, Object expectedValueDateExpr, Object expectedValueDouble) {
        if (expectedValue == null && expectedValueDate == null && expectedValueInteger == null && DateUtils.getDate((Object)expectedValueDateExpr) == null && expectedValueDouble == null) {
            return actualValue == null ? 0 : 1;
        }
        if (actualValue == null) {
            return -1;
        }
        if (expectedValueInteger != null) {
            return PropertyHelper.getInteger((Object)actualValue).compareTo(PropertyHelper.getInteger((Object)expectedValueInteger));
        }
        if (expectedValueDouble != null) {
            return PropertyHelper.getDouble((Object)actualValue).compareTo(PropertyHelper.getDouble((Object)expectedValueDouble));
        }
        if (expectedValueDate != null) {
            return DateUtils.getDate((Object)actualValue).compareTo(DateUtils.getDate((Object)expectedValueDate));
        }
        if (expectedValueDateExpr != null) {
            return DateUtils.getDate((Object)actualValue).compareTo(DateUtils.getDate((Object)expectedValueDateExpr));
        }
        return actualValue.toString().compareTo(expectedValue);
    }

    private boolean compareValues(Object actualValue, Collection<?> expectedValues, Collection<?> expectedValuesInteger, Collection<?> expectedValuesDouble, Collection<?> expectedValuesDate, Collection<?> expectedValuesDateExpr, String op) {
        Collection expectedDateExpr = null;
        if (expectedValuesDateExpr != null) {
            expectedDateExpr = expectedValuesDateExpr.stream().map(DateUtils::getDate).collect(Collectors.toList());
        }
        Collection expected = (Collection)ObjectUtils.firstNonNull((Object[])new Collection[]{expectedValues, expectedValuesDate, expectedValuesInteger, expectedValuesDouble, expectedDateExpr});
        if (actualValue == null) {
            return expected == null;
        }
        if (expected == null) {
            return false;
        }
        Collection actual = ConditionContextHelper.foldToASCII(this.getValueSet(actualValue));
        boolean result = true;
        block8 : switch (op) {
            case "in": {
                result = false;
                for (Object a : actual) {
                    if (!expected.contains(a)) continue;
                    result = true;
                    break block8;
                }
                break;
            }
            case "inContains": {
                result = false;
                block17: for (Object a : actual) {
                    for (Object b : expected) {
                        if (!((String)a).contains((String)b)) continue;
                        result = true;
                        continue block17;
                    }
                }
                break;
            }
            case "notIn": {
                for (Object a : actual) {
                    if (!expected.contains(a)) continue;
                    result = false;
                    break block8;
                }
                break;
            }
            case "all": {
                for (Object e : expected) {
                    if (actual.contains(e)) continue;
                    result = false;
                    break block8;
                }
                break;
            }
            case "hasNoneOf": {
                if (Collections.disjoint(actual, expected)) break;
                return false;
            }
            case "hasSomeOf": {
                if (!Collections.disjoint(actual, expected)) break;
                return false;
            }
            default: {
                throw new IllegalArgumentException("Unknown comparison operator " + op);
            }
        }
        return result;
    }

    public boolean eval(Condition condition, Item item, Map<String, Object> context, ConditionEvaluatorDispatcher dispatcher) {
        Object actualValue;
        String op = (String)condition.getParameter("comparisonOperator");
        String name = (String)condition.getParameter("propertyName");
        String expectedValue = ConditionContextHelper.foldToASCII((String)((String)condition.getParameter("propertyValue")));
        Object expectedValueInteger = condition.getParameter("propertyValueInteger");
        Object expectedValueDouble = condition.getParameter("propertyValueDouble");
        Object expectedValueDate = condition.getParameter("propertyValueDate");
        Object expectedValueDateExpr = condition.getParameter("propertyValueDateExpr");
        if (item instanceof Event && "eventType".equals(name)) {
            actualValue = ((Event)item).getEventType();
        } else {
            try {
                long time = System.nanoTime();
                actualValue = this.getPropertyValue(item, name);
                time = System.nanoTime() - time;
                if (time > 5000000L) {
                    LOGGER.info("eval took {} ms for {} {}", new Object[]{time / 1000000L, item.getClass().getName(), name});
                }
            }
            catch (NullPointerException e) {
                actualValue = null;
            }
            catch (Exception e) {
                if (!StringUtils.startsWith((CharSequence)e.getMessage(), (CharSequence)"source is null for getProperty(null")) {
                    LOGGER.warn("Error evaluating value for {} {}. See debug level for more information", (Object)item.getClass().getName(), (Object)name);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Error evaluating value for {} {}", new Object[]{item.getClass().getName(), name, e});
                    }
                }
                actualValue = null;
            }
        }
        if (actualValue instanceof String) {
            actualValue = ConditionContextHelper.foldToASCII((String)((String)actualValue));
        }
        return this.isMatch(op, actualValue, expectedValue, expectedValueInteger, expectedValueDouble, expectedValueDate, expectedValueDateExpr, condition);
    }

    protected boolean isMatch(String op, Object actualValue, String expectedValue, Object expectedValueInteger, Object expectedValueDouble, Object expectedValueDate, Object expectedValueDateExpr, Condition condition) {
        if (op == null) {
            return false;
        }
        if (actualValue == null) {
            return op.equals("missing") || op.equals("notIn") || op.equals("notEquals") || op.equals("hasNoneOf");
        }
        if (op.equals("exists")) {
            if (actualValue instanceof List) {
                return ((List)actualValue).size() > 0;
            }
            return true;
        }
        if (op.equals("equals")) {
            if (actualValue instanceof Collection) {
                for (Object o : (Collection)actualValue) {
                    if (o instanceof String) {
                        o = ConditionContextHelper.foldToASCII((String)((String)o));
                    }
                    if (this.compare(o, expectedValue, expectedValueDate, expectedValueInteger, expectedValueDateExpr, expectedValueDouble) != 0) continue;
                    return true;
                }
                return false;
            }
            return this.compare(actualValue, expectedValue, expectedValueDate, expectedValueInteger, expectedValueDateExpr, expectedValueDouble) == 0;
        }
        if (op.equals("notEquals")) {
            return this.compare(actualValue, expectedValue, expectedValueDate, expectedValueInteger, expectedValueDateExpr, expectedValueDouble) != 0;
        }
        if (op.equals("greaterThan")) {
            return this.compare(actualValue, expectedValue, expectedValueDate, expectedValueInteger, expectedValueDateExpr, expectedValueDouble) > 0;
        }
        if (op.equals("greaterThanOrEqualTo")) {
            return this.compare(actualValue, expectedValue, expectedValueDate, expectedValueInteger, expectedValueDateExpr, expectedValueDouble) >= 0;
        }
        if (op.equals("lessThan")) {
            return this.compare(actualValue, expectedValue, expectedValueDate, expectedValueInteger, expectedValueDateExpr, expectedValueDouble) < 0;
        }
        if (op.equals("lessThanOrEqualTo")) {
            return this.compare(actualValue, expectedValue, expectedValueDate, expectedValueInteger, expectedValueDateExpr, expectedValueDouble) <= 0;
        }
        if (op.equals("between")) {
            Collection expectedValuesInteger = (Collection)condition.getParameter("propertyValuesInteger");
            Collection expectedValuesDouble = (Collection)condition.getParameter("propertyValuesDouble");
            Collection expectedValuesDate = (Collection)condition.getParameter("propertyValuesDate");
            Collection expectedValuesDateExpr = (Collection)condition.getParameter("propertyValuesDateExpr");
            return this.compare(actualValue, null, DateUtils.getDate((Object)this.getFirst(expectedValuesDate)), this.getFirst(expectedValuesInteger), this.getFirst(expectedValuesDateExpr), this.getFirst(expectedValuesDouble)) >= 0 && this.compare(actualValue, null, DateUtils.getDate((Object)this.getSecond(expectedValuesDate)), this.getSecond(expectedValuesInteger), this.getSecond(expectedValuesDateExpr), this.getSecond(expectedValuesDouble)) <= 0;
        }
        if (op.equals("contains")) {
            return actualValue.toString().contains(expectedValue);
        }
        if (op.equals("notContains")) {
            return !actualValue.toString().contains(expectedValue);
        }
        if (op.equals("startsWith")) {
            return actualValue.toString().startsWith(expectedValue);
        }
        if (op.equals("endsWith")) {
            return actualValue.toString().endsWith(expectedValue);
        }
        if (op.equals("matchesRegex")) {
            return expectedValue != null && Pattern.compile(expectedValue).matcher(actualValue.toString()).matches();
        }
        if (op.equals("in") || op.equals("inContains") || op.equals("notIn") || op.equals("hasSomeOf") || op.equals("hasNoneOf") || op.equals("all")) {
            Collection expectedValues = ConditionContextHelper.foldToASCII((Collection)((Collection)condition.getParameter("propertyValues")));
            Collection expectedValuesInteger = (Collection)condition.getParameter("propertyValuesInteger");
            Collection expectedValuesDate = (Collection)condition.getParameter("propertyValuesDate");
            Collection expectedValuesDateExpr = (Collection)condition.getParameter("propertyValuesDateExpr");
            Collection expectedValuesDouble = (Collection)condition.getParameter("propertyValuesDouble");
            return this.compareValues(actualValue, expectedValues, expectedValuesInteger, expectedValuesDouble, expectedValuesDate, expectedValuesDateExpr, op);
        }
        if (op.equals("isDay") && (expectedValueDate != null || expectedValueDateExpr != null)) {
            Object expectedDate = expectedValueDate == null ? expectedValueDateExpr : expectedValueDate;
            return yearMonthDayDateFormat.format(DateUtils.getDate((Object)actualValue)).equals(yearMonthDayDateFormat.format(DateUtils.getDate((Object)expectedDate)));
        }
        if (op.equals("isNotDay") && (expectedValueDate != null || expectedValueDateExpr != null)) {
            Object expectedDate = expectedValueDate == null ? expectedValueDateExpr : expectedValueDate;
            return !yearMonthDayDateFormat.format(DateUtils.getDate((Object)actualValue)).equals(yearMonthDayDateFormat.format(DateUtils.getDate((Object)expectedDate)));
        }
        if (op.equals("distance")) {
            GeoPoint actualCenter = null;
            if (actualValue instanceof GeoPoint) {
                actualCenter = (GeoPoint)actualValue;
            } else if (actualValue instanceof Map) {
                actualCenter = GeoPoint.fromMap((Map)((Map)actualValue));
            } else if (actualValue instanceof String) {
                actualCenter = GeoPoint.fromString((String)((String)actualValue));
            }
            if (actualCenter == null) {
                return false;
            }
            String unitString = (String)condition.getParameter("unit");
            String centerString = (String)condition.getParameter("center");
            Double distance = (Double)condition.getParameter("distance");
            if (centerString == null || distance == null) {
                return false;
            }
            GeoPoint expectedCenter = GeoPoint.fromString((String)centerString);
            DistanceUnit expectedUnit = unitString != null ? DistanceUnit.fromString((String)unitString) : DistanceUnit.DEFAULT;
            double distanceInMeters = expectedUnit.convert(distance.doubleValue(), DistanceUnit.METERS);
            return expectedCenter.distanceTo(actualCenter) <= distanceInMeters;
        }
        return false;
    }

    protected Object getPropertyValue(Item item, String expression) throws Exception {
        Object result;
        if (this.usePropertyConditionOptimizations && !"$$$###PROPERTY_NOT_FOUND###$$$".equals(result = this.getHardcodedPropertyValue(item, expression))) {
            return result;
        }
        return null;
    }

    protected Object getHardcodedPropertyValue(Item item, String expression) {
        return hardcodedPropertyAccessorRegistry.getProperty(item, expression);
    }

    private List<Object> getValueSet(Object expectedValue) {
        if (expectedValue instanceof List) {
            return (List)expectedValue;
        }
        if (expectedValue instanceof Collection) {
            return new ArrayList<Object>((Collection)expectedValue);
        }
        return Collections.singletonList(expectedValue);
    }

    private Object getFirst(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return null;
        }
        Iterator<?> iterator = collection.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private Object getSecond(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return null;
        }
        Iterator<?> iterator = collection.iterator();
        if (iterator.hasNext()) {
            iterator.next();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        return null;
    }
}

